import re
import sys
import subprocess
import os
#import pexpect

inputFile=sys.argv[1]
semantics=sys.argv[2]
omitType=sys.argv[3]
asprin=sys.argv[4]

if len(sys.argv)>5:
    omitpreds=sys.argv[5]
    omitpreds=omitpreds.split(",")
else:
    omitpreds=[]
    
if semantics!="adm" and semantics!="stable" and semantics!="grounded":
    print("enter correct semantics!")
    sys.exit()
    
if omitpreds!=[]:
        usedatomsfile = open("guess_"+semantics+"_atoms_to_omit_forgrounding.lp", "r") 
        pickedatomstext=""
        for line in usedatomsfile:
            matches=False
            for o in omitpreds:
                if "omitted("+o+"(" in line or "omitted(aux"+o+"(" in line:
                    matches=True
                    break
            if matches==True:
                pickedatomstext+=line
        usedatomsfile.close()            
        if pickedatomstext!="":
            pickedatomsfile = open("guess_picked_atoms_to_omit_forgrounding.lp", "w") 
            pickedatomsfile.write(pickedatomstext)
            pickedatomsfile.close()
        else:
            if omitType=="3":
                os.popen("cp guess_"+semantics+"_atoms_to_omit_forgrounding.lp guess_picked_atoms_to_omit_forgrounding.lp")        
            else:
                open("guess_picked_atoms_to_omit_forgrounding.lp", "a").close() 
        usedatomsfile = open("guess_"+semantics+"_atoms_to_omit.lp", "r") 
        pickedatomstext=""
        for line in usedatomsfile:
            matches=False
            for o in omitpreds:
                if "omitted("+o+"(" in line:
                    matches=True
                    break
            if matches==True:
                pickedatomstext+=line
        usedatomsfile.close()
        if pickedatomstext!="":
            pickedatomsfile = open("guess_picked_atoms_to_omit.lp", "w") 
            pickedatomsfile.write(pickedatomstext)
            pickedatomsfile.close()
        else:
            if omitType=="3":
                os.popen("cp guess_"+semantics+"_atoms_to_omit.lp guess_picked_atoms_to_omit.lp")      
            else:
                open("guess_picked_atoms_to_omit.lp", "a").close() 
            
    
graphInput = open(inputFile, "r") 
text=""
textomitted=""
textguessomitted=""
for line in graphInput: 
    if line=="\n":
        text+="\n"
        continue
    if ":-" not in line:
        atom=line[:line.index(".")]
        text+=atom+" :- not omitted("+atom+").\n"
        if omitpreds==[]:
            textomitted+="{omitted("+atom+")}.\n"
#            textomitted+="negomitted("+atom+") :- not omitted("+atom+"), "+atom+".\n"
            textguessomitted+="{guessedomitted("+atom+")}.\n"
        else:
            matches=False
            for o in omitpreds:
                if o+"("==atom[:atom.index("(")+1]:
                    matches=True
                    break
            if matches==True:
                textomitted+="{omitted("+atom+")}.\n"
                textguessomitted+="{guessedomitted("+atom+")}.\n"
                    
    else:
        atom=re.findall(r"not (\S+)\.",line)[0]
        text+="f :- not f, not "+atom+", not omitted("+atom+").\n"
graphInput.close()

dirpath = os.getcwd()
dirName = 'auxiliaryFiles'

if not os.path.exists(dirName):
    os.mkdir(dirName)

graphInputModified=dirpath+"/"+dirName+"/"+inputFile[inputFile.rfind("/")+1:inputFile.find(".lp")]+"_omission.lp"
f=open(graphInputModified, "w") 
f.write(text)
f.close()

argAttOmitForGrounding=dirpath+"/"+dirName+"/"+inputFile[inputFile.rfind("/")+1:inputFile.find(".lp")]+"_guess_arg_att_to_omit_for_grounding.lp"
f=open(argAttOmitForGrounding, "w") 
f.write(textomitted)
f.close()

argAttOmitGuess=dirpath+"/"+dirName+"/"+inputFile[inputFile.rfind("/")+1:inputFile.find(".lp")]+"_guess_arg_att_to_omit.lp"
f=open(argAttOmitGuess, "w") 
f.write(textguessomitted)
f.close()

if omitpreds!=[]:
    showtext=""
    if omitpreds==["arg","att"] and omitType=="3":
        showtext="#show notomitted/1.\n"
    else:
        for o in omitpreds:
            if o=="att":
                showtext+="#show notomitted(atom(att(X,Y))) : notomitted(atom(att(X,Y))).\n"
            else:
                showtext+="#show notomitted(atom("+o+"(X))) : notomitted(atom("+o+"(X))).\n"
else:
    showtext="#show notomitted/1.\n"
showGivenAtoms=dirpath+"/"+dirName+"/"+inputFile[inputFile.rfind("/")+1:inputFile.find(".lp")]+"_show_atoms.lp"
f=open(showGivenAtoms, "w") 
f.write(showtext)
f.close()

graphInputReification=graphInputModified[:graphInputModified.index(".lp")]+"_reify.lp"


if omitType=="0":
    gringo = subprocess.Popen("gringo --text {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp | gringo-3.0.3-x86-linux/gringo --reify > "+graphInputReification), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
    gringoout, gringoerr = gringo.communicate()
    gringo.wait()
    del gringo
    gringoout = gringoout.decode('utf-8')
elif omitType=="1":
    print("gringo --text {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp guess_"+semantics+"_atoms_to_omit_forgrounding.lp | gringo-3.0.3-x86-linux/gringo --reify > "+graphInputReification))
    gringo = subprocess.Popen("gringo --text {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp guess_"+semantics+"_atoms_to_omit_forgrounding.lp | gringo-3.0.3-x86-linux/gringo --reify > "+graphInputReification), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
    gringoout, gringoerr = gringo.communicate()
    gringo.wait()
    del gringo
    gringoout = gringoout.decode('utf-8')
elif omitType=="2" or omitType=="3":
    #print("gringo --text --keep-facts {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp guess_picked_atoms_to_omit_forgrounding.lp"))
    #print("gringo --text {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp guess_picked_atoms_to_omit_forgrounding.lp"))
    print("========")
    gringo = subprocess.Popen("gringo --text {}".format(graphInputModified + " " + argAttOmitForGrounding+ " encoding_"+semantics+".lp guess_picked_atoms_to_omit_forgrounding.lp | gringo-3.0.3-x86-linux/gringo --reify > "+graphInputReification), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
    gringoout, gringoerr = gringo.communicate()
    gringo.wait()
    del gringo
    gringoout = gringoout.decode('utf-8')
    



reifyFile = open(graphInputReification, "r") 
graphInputReificationModify=graphInputReification[:graphInputReification.index(".lp")]+"_modified.lp"
fout=open(graphInputReificationModify,"w")
for line in reifyFile: 
    if "wlist" not in line and "sum" not in line:
        fout.write(line)
reifyFile.close()
fout.close()

if asprin=="1":
    if omitType=="0":
        text="asprin {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        asprin = subprocess.Popen("asprin {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        asprinout, asprinerr = asprin.communicate()
        asprin.wait()
        del asprin
        asprinout = asprinout.decode('utf-8')
    elif omitType=="1":
        text="asprin guess_"+semantics+"_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        asprin = subprocess.Popen("asprin guess_"+semantics+"_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        asprinout, asprinerr = asprin.communicate()
        asprin.wait()
        del asprin
        asprinout = asprinout.decode('utf-8')
    elif omitType=="2":
        text="asprin guess_picked_atoms_to_omit.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        asprin = subprocess.Popen("asprin guess_picked_atoms_to_omit.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        asprinout, asprinerr = asprin.communicate()
        asprin.wait()
        del asprin
        asprinout = asprinout.decode('utf-8')
    elif omitType=="3":
        text="asprin guess_picked_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        asprin = subprocess.Popen("asprin guess_picked_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp preference.lp 0".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        asprinout, asprinerr = asprin.communicate()
        asprin.wait()
        del asprin
        asprinout = asprinout.decode('utf-8')
        
    print(asprinout)
else:
    if omitType=="0":
        text="clingo {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        clingo = subprocess.Popen("clingo {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        #clingoout, clingoerr = clingo.communicate()
        #clingo.wait()
        #del clingo
        try:
            clingoout, clingoerr = clingo.communicate(timeout=900)
        except subprocess.TimeoutExpired:
            clingo.kill()
            clingoout, clingoerr = clingo.communicate()
            del clingo
        else:
            clingo.wait()
            del clingo
        clingoout = clingoout.decode('utf-8')
    elif omitType=="1":
        text="clingo guess_"+semantics+"_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        clingo = subprocess.Popen("clingo guess_"+semantics+"_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        try:
            clingoout, clingoerr = clingo.communicate(timeout=900)
        except subprocess.TimeoutExpired:
            clingo.kill()
            clingoout, clingoerr = clingo.communicate()
            del clingo
        else:
            clingo.wait()
            del clingo
        clingoout = clingoout.decode('utf-8')
    elif omitType=="2":
        text="clingo guess_picked_atoms_to_omit.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        clingo = subprocess.Popen("clingo guess_picked_atoms_to_omit.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        try:
            clingoout, clingoerr = clingo.communicate(timeout=900)
        except subprocess.TimeoutExpired:
            clingo.kill()
            clingoout, clingoerr = clingo.communicate()
            del clingo
        else:
            clingo.wait()
            del clingo
        clingoout = clingoout.decode('utf-8')
    elif omitType=="3":
        text="clingo guess_picked_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms)
        print(text)
        clingo = subprocess.Popen("clingo guess_picked_atoms_to_omit.lp infer_"+semantics+"_omitted_atoms.lp {} aux_meta_omitted.lp metaD.lp optimization.lp".format(argAttOmitGuess+" "+graphInputReificationModify+" "+showGivenAtoms), shell=True, stdout=subprocess.PIPE, stderr=sys.stderr)
        try:
            clingoout, clingoerr = clingo.communicate(timeout=900)
        except subprocess.TimeoutExpired:
            clingo.kill()
            clingoout, clingoerr = clingo.communicate()
            del clingo
        else:
            clingo.wait()
            del clingo
        clingoout = clingoout.decode('utf-8')
        
    print(clingoout)
        

