/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.gui.AgentTreeModel;
import jade.gui.MyFilterImage;
import jade.gui.NodeDescriptor;
import jade.gui.TreeIconRenderer;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;

public class AgentTree
extends JPanel {
    private static String localPlatformName = "ThisPlatform";
    public JTree tree;
    protected static Icon[] icons;
    private Map mapDescriptor = new HashMap();
    private static final String FROZEN_AGENTS = "Frozen Agents";

    public AgentTree(Font font) {
        this.tree = new JTree();
        this.tree.setFont(font);
        this.tree.setModel(new AgentTreeModel(new SuperContainer("AgentPlatforms")));
        this.tree.setLargeModel(false);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(4);
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        localPlatformFolderNode localPlatformFolderNode2 = new localPlatformFolderNode(localPlatformName);
        agentTreeModel.insertNodeInto(localPlatformFolderNode2, mutableTreeNode, mutableTreeNode.getChildCount());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setShowsRootHandles(true);
        TreeIconRenderer treeIconRenderer = new TreeIconRenderer();
        this.tree.setCellRenderer(treeIconRenderer);
        this.tree.setRowHeight(0);
    }

    public void listenerTree(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public Node createNewNode(String string, int n) {
        switch (n) {
            case 0: {
                return new ContainerNode(string);
            }
            case 1: {
                return new AgentNode(string);
            }
        }
        return null;
    }

    public void refreshLocalPlatformName(String string) {
        String string2 = localPlatformName;
        localPlatformName = string;
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string3 = node.getName();
            if (!string3.equalsIgnoreCase(string2)) continue;
            node.setName(string);
            return;
        }
    }

    public void clearLocalPlatform() {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Object object;
            Node node = (Node)enumeration.nextElement();
            String string = node.getName();
            if (!string.equalsIgnoreCase(localPlatformName)) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (enumeration2.hasMoreElements()) {
                object = (Node)enumeration2.nextElement();
                linkedList.add(object);
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                MutableTreeNode mutableTreeNode2 = (MutableTreeNode)object.next();
                agentTreeModel.removeNodeFromParent(mutableTreeNode2);
            }
        }
    }

    public void addContainerNode(ContainerNode containerNode, String string, InetAddress inetAddress) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        containerNode.setType(string);
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string2 = node.getName();
            if (!string2.equalsIgnoreCase(localPlatformName)) continue;
            agentTreeModel.insertNodeInto(containerNode, node, node.getChildCount());
        }
        containerNode.setAddress(inetAddress);
    }

    public void removeContainerNode(String string) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string2 = node.getName();
            if (!string2.equalsIgnoreCase(localPlatformName)) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string3 = node2.getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                agentTreeModel.removeNodeFromParent(node2);
                return;
            }
        }
    }

    public void addRemotePlatformsFolderNode() {
        Node node;
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        boolean bl = false;
        while (enumeration.hasMoreElements() & !bl) {
            node = (Node)enumeration.nextElement();
            String string = node.getName();
            if (!string.equalsIgnoreCase("REMOTEPLATFORMS")) continue;
            bl = true;
        }
        if (!bl) {
            node = new RemotePlatformsFolderNode("RemotePlatforms");
            agentTreeModel.insertNodeInto(node, mutableTreeNode, mutableTreeNode.getChildCount());
        }
    }

    public void addAgentNode(AgentNode agentNode, String string, String string2, String string3, String string4) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        agentNode.setType(string4);
        AgentNode agentNode2 = agentNode;
        agentNode2.address(string3);
        agentNode2.setState("Running");
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string5 = node.getName();
            if (!string5.equalsIgnoreCase(localPlatformName)) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string6 = node2.getName();
                if (!string6.equalsIgnoreCase(string)) continue;
                agentTreeModel.insertNodeInto(agentNode, node2, node2.getChildCount());
                return;
            }
        }
    }

    public void modifyAgentNode(String string, String string2, String string3, String string4, String string5) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string6 = node.getName();
            if (!string6.equalsIgnoreCase(localPlatformName)) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string7 = node2.getName();
                if (!string7.equalsIgnoreCase(string)) continue;
                Enumeration<TreeNode> enumeration3 = node2.children();
                while (enumeration3.hasMoreElements()) {
                    Node node3 = (Node)enumeration3.nextElement();
                    if (!node3.getName().equalsIgnoreCase(string2)) continue;
                    if (string4 != null) {
                        node3.setState(string4);
                    }
                    if (string5 != null) {
                        node3.setOwnership(string5);
                    }
                    node3.changeIcon(string4);
                    agentTreeModel.nodeChanged(node3);
                    return;
                }
            }
        }
    }

    public void moveAgentNode(String string, String string2, String string3) {
        AgentTreeModel agentTreeModel = this.getModel();
        Node node = this.findContainerNode(string);
        Node node2 = this.findContainerNode(string2);
        Node node3 = this.findFrozenAgentsFolder(node2, FROZEN_AGENTS);
        if (node3 != null) {
            Node node4 = this.findAgentNode(node3, string3);
            if (node4 == null) {
                node4 = this.findAgentNode(node, string3);
                agentTreeModel.removeNodeFromParent(node4);
                agentTreeModel.insertNodeInto(node4, node2, node2.getChildCount());
            }
        } else {
            Node node5 = this.findAgentNode(node, string3);
            agentTreeModel.removeNodeFromParent(node5);
            agentTreeModel.insertNodeInto(node5, node2, node2.getChildCount());
        }
    }

    public void freezeAgentNode(String string, String string2, String string3) {
        AgentTreeModel agentTreeModel = this.getModel();
        Node node = this.findContainerNode(string);
        Node node2 = this.findAgentNode(node, string3);
        agentTreeModel.removeNodeFromParent(node2);
        node2.setState("frozen");
        node2.changeIcon("frozen");
        Node node3 = this.findContainerNode(string2);
        Node node4 = this.findFrozenAgentsFolder(node3, FROZEN_AGENTS);
        if (node4 == null) {
            node4 = this.createNewNode(FROZEN_AGENTS, 0);
            node4.setType("FROZENCONTAINER");
            agentTreeModel.insertNodeInto(node4, node3, 0);
        }
        agentTreeModel.insertNodeInto(node2, node4, node4.getChildCount());
    }

    public void thawAgentNode(String string, String string2, String string3) {
        AgentTreeModel agentTreeModel = this.getModel();
        Node node = this.findContainerNode(string);
        Node node2 = this.findFrozenAgentsFolder(node, FROZEN_AGENTS);
        Node node3 = this.findAgentNode(node2, string3);
        agentTreeModel.removeNodeFromParent(node3);
        if (node2.isLeaf()) {
            agentTreeModel.removeNodeFromParent(node2);
        }
        node3.setState("active");
        node3.changeIcon("active");
        Node node4 = this.findContainerNode(string2);
        agentTreeModel.insertNodeInto(node3, node4, node4.getChildCount());
    }

    public void removeAgentNode(String string, String string2) {
        AgentTreeModel agentTreeModel = this.getModel();
        Node node = this.findContainerNode(string);
        Node node2 = this.findAgentNode(node, string2);
        if (node2 != null) {
            agentTreeModel.removeNodeFromParent(node2);
        } else {
            Node node3 = this.findFrozenAgentsFolder(node, FROZEN_AGENTS);
            if (node3 != null) {
                node2 = this.findAgentNode(node3, string2);
                agentTreeModel.removeNodeFromParent(node2);
                if (node3.isLeaf()) {
                    agentTreeModel.removeNodeFromParent(node3);
                }
            }
        }
    }

    public void addRemotePlatformNode(AID aID, APDescription aPDescription) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            RemotePlatformNode remotePlatformNode;
            Node node = (Node)enumeration.nextElement();
            String string = node.getName();
            if (!string.equalsIgnoreCase("REMOTEPLATFORMS")) continue;
            boolean bl = false;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements() && !bl) {
                remotePlatformNode = (RemotePlatformNode)enumeration2.nextElement();
                String string2 = remotePlatformNode.getName();
                if (!string2.equalsIgnoreCase(aPDescription.getName())) continue;
                remotePlatformNode.setAPDescription(aPDescription);
                bl = true;
            }
            if (!bl) {
                remotePlatformNode = new RemotePlatformNode(aPDescription.getName());
                remotePlatformNode.setAPDescription(aPDescription);
                remotePlatformNode.setAmsAID(aID);
                agentTreeModel.insertNodeInto(remotePlatformNode, node, node.getChildCount());
            }
            return;
        }
    }

    public void removeRemotePlatformNode(String string) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string2 = node.getName();
            if (!string2.equalsIgnoreCase("REMOTEPLATFORMS")) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string3 = node2.getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                agentTreeModel.removeNodeFromParent(node2);
                if (node.getChildCount() == 0) {
                    agentTreeModel.removeNodeFromParent(node);
                }
                return;
            }
        }
    }

    public void addRemoteAgentNode(AMSAgentDescription aMSAgentDescription, String string) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string2 = node.getName();
            if (!string2.equalsIgnoreCase("REMOTEPLATFORMS")) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                RemoteAgentNode remoteAgentNode;
                Node node2 = (Node)enumeration2.nextElement();
                String string3 = node2.getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                Enumeration<TreeNode> enumeration3 = node2.children();
                boolean bl = false;
                while (enumeration3.hasMoreElements() && !bl) {
                    remoteAgentNode = (RemoteAgentNode)enumeration3.nextElement();
                    String string4 = remoteAgentNode.getName();
                    if (!string4.equalsIgnoreCase(aMSAgentDescription.getName().getName())) continue;
                    remoteAgentNode.setAMSDescription(aMSAgentDescription);
                    bl = true;
                }
                if (bl) continue;
                remoteAgentNode = new RemoteAgentNode(aMSAgentDescription.getName().getName());
                remoteAgentNode.setAMSDescription(aMSAgentDescription);
                agentTreeModel.insertNodeInto(remoteAgentNode, node2, node2.getChildCount());
            }
        }
    }

    public AgentTreeModel getModel() {
        if (this.tree.getModel() instanceof AgentTreeModel) {
            return (AgentTreeModel)this.tree.getModel();
        }
        System.out.println(this.tree.getModel());
        return null;
    }

    public void register(String string, JPopupMenu jPopupMenu, String string2) {
        if (!this.mapDescriptor.containsKey(string)) {
            NodeDescriptor nodeDescriptor = new NodeDescriptor(jPopupMenu, string2);
            this.mapDescriptor.put(string, nodeDescriptor);
        }
    }

    public JPopupMenu getPopupMenu(String string) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)this.mapDescriptor.get(string);
        return nodeDescriptor.getPopupMenu();
    }

    public void setNewPopupMenu(String string, JPopupMenu jPopupMenu) {
        if (this.mapDescriptor.containsKey(string)) {
            NodeDescriptor nodeDescriptor = (NodeDescriptor)this.mapDescriptor.get(string);
            nodeDescriptor.setNewPopupMenu(jPopupMenu);
        }
    }

    protected String getIconAgent(String string) {
        NodeDescriptor nodeDescriptor = (NodeDescriptor)this.mapDescriptor.get(string);
        return nodeDescriptor.getPathImage();
    }

    private Node findAgentNode(Node node, String string) {
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.getName().equalsIgnoreCase(string)) continue;
            return node2;
        }
        return null;
    }

    private Node findContainerNode(String string) {
        AgentTreeModel agentTreeModel = this.getModel();
        MutableTreeNode mutableTreeNode = (MutableTreeNode)agentTreeModel.getRoot();
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            String string2 = node.getName();
            if (!string2.equalsIgnoreCase(localPlatformName)) continue;
            Enumeration<TreeNode> enumeration2 = node.children();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                String string3 = node2.getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                return node2;
            }
        }
        return null;
    }

    private Node findFrozenAgentsFolder(Node node, String string) {
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (!node2.getName().equalsIgnoreCase(string) || !node2.getType().equalsIgnoreCase("FROZENCONTAINER")) continue;
            return node2;
        }
        return null;
    }

    public class RemoteAgentNode
    extends AgentNode {
        private AMSAgentDescription amsd;

        public RemoteAgentNode(String string) {
            super(string);
        }

        public String getToolTipText() {
            return "Remote Agent";
        }

        public void setType(String string) {
        }

        public String getType() {
            return "REMOTEAGENT";
        }

        public void setAMSDescription(AMSAgentDescription aMSAgentDescription) {
            this.amsd = aMSAgentDescription;
        }

        public AMSAgentDescription getAMSDescription() {
            return this.amsd;
        }
    }

    public class RemotePlatformNode
    extends Node {
        private APDescription AP_Profile;
        private AID amsAID;

        public RemotePlatformNode(String string) {
            super(string);
        }

        public String getToolTipText() {
            return "Remote Platform";
        }

        public void setType(String string) {
        }

        public String getType() {
            return "REMOTEPLATFORM";
        }

        public void setAPDescription(APDescription aPDescription) {
            this.AP_Profile = aPDescription;
        }

        public APDescription getAPDescription() {
            return this.AP_Profile;
        }

        public void setAmsAID(AID aID) {
            this.amsAID = aID;
        }

        public AID getAmsAID() {
            return this.amsAID;
        }
    }

    public class localPlatformFolderNode
    extends Node {
        public localPlatformFolderNode(String string) {
            super(string);
            AgentTree.this.register("LOCALPLATFORM", new JPopupMenu(), "images/folderyellow.gif");
        }

        public String getToolTipText() {
            return "Local JADE Platform";
        }

        public void setType(String string) {
        }

        public String getType() {
            return "LOCALPLATFORM";
        }
    }

    public class RemotePlatformsFolderNode
    extends Node {
        public RemotePlatformsFolderNode(String string) {
            super(string);
        }

        public String getToolTipText() {
            return "List of RemotePlatforms";
        }

        public void setType(String string) {
        }

        public String getType() {
            return "REMOTEPLATFORMS";
        }
    }

    public class SuperContainer
    extends Node {
        public SuperContainer(String string) {
            super(string);
            AgentTree.this.register("SUPERCONTAINER", new JPopupMenu(), "images/folderyellow.gif");
        }

        public String getToolTipText() {
            return "Java Agent DEvelopment Framework";
        }

        public String getType() {
            return "SUPERCONTAINER";
        }

        public void setType(String string) {
        }
    }

    public class ContainerNode
    extends Node {
        InetAddress addressmachine;
        String typeContainer;

        public ContainerNode(String string) {
            super(string);
        }

        public void setAddress(InetAddress inetAddress) {
            this.addressmachine = inetAddress;
        }

        public void setType(String string) {
            this.typeContainer = string;
        }

        public String getType() {
            return this.typeContainer;
        }

        public String getToolTipText() {
            if (this.addressmachine != null) {
                return this.name + ":" + this.addressmachine.getHostName() + "[" + this.addressmachine.getHostAddress() + "]";
            }
            return this.name + ":<Unknown Host> [???:???:???:???]";
        }
    }

    public class AgentNode
    extends Node {
        private String typeAgent;
        private String addressAgent;

        public AgentNode(String string) {
            super(string);
        }

        public void address(String string) {
            this.addressAgent = string;
        }

        public void setType(String string) {
            this.typeAgent = string;
        }

        public String getType() {
            return this.typeAgent;
        }

        public String getAddress() {
            return this.addressAgent;
        }

        public String getToolTipText() {
            return "Local Agent";
        }
    }

    public abstract class Node
    extends DefaultMutableTreeNode {
        protected Icon img;
        protected String name;
        protected String state;
        protected String ownership;
        protected boolean greyOut = false;

        public Node(String string) {
            this.name = string;
        }

        public Icon getIcon(String string) {
            Image image = AgentTree.this.getToolkit().getImage(this.getClass().getResource(AgentTree.this.getIconAgent(string)));
            if (this.greyOut) {
                MyFilterImage myFilterImage = new MyFilterImage();
                Image image2 = AgentTree.this.createImage(new FilteredImageSource(image.getSource(), myFilterImage));
                return new ImageIcon(image2);
            }
            return new ImageIcon(image);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getState() {
            return this.state != null ? this.state : "";
        }

        public void setState(String string) {
            this.state = string;
        }

        public String getOwnership() {
            return this.ownership != null ? this.ownership : "";
        }

        public void setOwnership(String string) {
            this.ownership = string;
        }

        public void changeIcon(String string) {
            if (string.equalsIgnoreCase("suspended")) {
                this.greyOut = true;
                this.setType("FIPAAGENT");
            } else if (string.equalsIgnoreCase("active")) {
                this.greyOut = false;
                this.setType("FIPAAGENT");
            } else if (string.equalsIgnoreCase("frozen")) {
                this.greyOut = false;
                this.setType("FROZENAGENT");
            }
        }

        public abstract String getType();

        public abstract void setType(String var1);

        public abstract String getToolTipText();
    }
}

