/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.gui.StringDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class VisualStringList
extends JPanel {
    Component owner;
    JList genericList;
    JScrollPane pane;
    DefaultListModel listModel;
    JPopupMenu popUp;
    JMenuItem editItem;
    JMenuItem addItem;
    JMenuItem removeItem;
    static String VIEW_LABEL = "View";
    static String EDIT_LABEL = "Edit";
    static String ADD_LABEL = "Add";
    static String REMOVE_LABEL = "Remove";

    VisualStringList(Iterator iterator, Component component) {
        this.owner = component;
        this.listModel = new DefaultListModel();
        try {
            while (iterator.hasNext()) {
                this.listModel.addElement(iterator.next());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.genericList = new JList(this.listModel);
        this.genericList.setCellRenderer(new VisualListCellRenderer(this));
        this.genericList.setSelectionMode(0);
        this.genericList.setSelectedIndex(0);
        this.pane = new JScrollPane(this.genericList);
        this.genericList.setToolTipText("Right mouse click to show the popup menu");
        this.genericList.addMouseListener(new PopupMouser());
        this.popUp = new JPopupMenu();
        this.popUp.setLightWeightPopupEnabled(false);
        this.editItem = new JMenuItem(EDIT_LABEL);
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(EDIT_LABEL)) {
                    VisualStringList.this.editAction();
                } else if (string.equals(VIEW_LABEL)) {
                    VisualStringList.this.viewAction();
                }
            }
        });
        this.popUp.add(this.editItem);
        this.addItem = new JMenuItem(ADD_LABEL);
        this.addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string = actionEvent.getActionCommand();
                if (string.equals(ADD_LABEL) && (object = VisualStringList.this.editElement(null, true)) != null) {
                    VisualStringList.this.addElement(object);
                }
            }
        });
        this.popUp.insert(this.addItem, 0);
        this.removeItem = new JMenuItem(REMOVE_LABEL);
        this.removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object e;
                String string = actionEvent.getActionCommand();
                if (string.equals(REMOVE_LABEL) && VisualStringList.this.genericList.getModel().getSize() > 0 && (e = VisualStringList.this.genericList.getSelectedValue()) != null) {
                    VisualStringList.this.removeElement(e);
                }
            }
        });
        this.popUp.insert(this.removeItem, 2);
        this.add(this.pane);
    }

    private void viewAction() {
        Object e;
        if (this.genericList.getModel().getSize() > 0 && (e = this.genericList.getSelectedValue()) != null) {
            this.editElement(e, false);
        }
    }

    private void editAction() {
        if (this.genericList.getModel().getSize() > 0) {
            Object object;
            Object e = this.genericList.getSelectedValue();
            int n = this.genericList.getSelectedIndex();
            if (e != null && (object = this.editElement(e, true)) != null) {
                this.listModel.set(n, object);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addItem.setEnabled(bl);
        this.removeItem.setEnabled(bl);
        if (!bl) {
            this.editItem.setText(VIEW_LABEL);
        }
    }

    protected String getElementName(Object object) {
        return object.toString();
    }

    private void addElement(Object object) {
        this.listModel.addElement(object);
    }

    protected void removeElement(Object object) {
        this.listModel.removeElement(object);
    }

    protected void resetContent(Iterator iterator) {
        this.listModel = new DefaultListModel();
        try {
            while (iterator.hasNext()) {
                this.listModel.addElement(iterator.next());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.genericList.setModel(this.listModel);
    }

    protected Object editElement(Object object, boolean bl) {
        String string = null;
        if (bl) {
            StringDlg stringDlg = new StringDlg(this.owner, "Insert a new value:");
            string = stringDlg.editString((String)object);
        } else {
            StringDlg stringDlg = new StringDlg(this.owner, "Value:");
            stringDlg.viewString((String)object);
        }
        return string;
    }

    public Enumeration getContent() {
        return this.listModel.elements();
    }

    public void setDimension(Dimension dimension) {
        this.pane.setPreferredSize(dimension);
        this.pane.setMinimumSize(dimension);
        this.pane.setMaximumSize(dimension);
    }

    private class PopupMouser
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                VisualStringList.this.popUp.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                VisualStringList.this.popUp.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getComponent().getParent().getParent().getParent().isEnabled()) {
                    ((VisualStringList)mouseEvent.getComponent().getParent().getParent().getParent()).editAction();
                } else {
                    ((VisualStringList)mouseEvent.getComponent().getParent().getParent().getParent()).viewAction();
                }
            }
        }
    }

    private class VisualListCellRenderer
    extends DefaultListCellRenderer {
        private VisualStringList myList;

        VisualListCellRenderer(VisualStringList visualStringList2) {
            this.myList = visualStringList2;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Font font = new Font("Courier", 1, 12);
            this.setFont(font);
            this.setText(this.myList.getElementName(object));
            this.setBackground(bl ? Color.lightGray : Color.white);
            return this;
        }
    }
}

