/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.core.AID;
import jade.domain.DFGUIAdapter;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLParser;
import jade.tools.applet.AppletRequestProto;
import jade.tools.applet.FIPAAppletRequestProto;
import jade.tools.applet.JADEAppletRequestProto;
import jade.tools.dfgui.DFGUI;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.applet.Applet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;

public class DFAppletCommunicator
implements DFGUIAdapter {
    private Applet a;
    private DataInputStream in;
    private PrintStream out;
    private static final int DEFAULT_PORT = 6789;
    private ACLParser parser;
    private DFGUI gui;
    private String address;
    private String hap;
    private DFAgentDescription thisDF = null;
    private Logger logger = Logger.getMyLogger((String)this.getClass().getName());

    public DFAppletCommunicator(Applet applet) {
        try {
            this.a = applet;
            this.hap = this.a.getParameter("HAP");
            if (this.logger.isLoggable(Logger.FINEST)) {
                this.logger.log(Logger.FINEST, "HAP:" + this.hap);
            }
            Socket socket = new Socket(this.a.getCodeBase().getHost(), 6789);
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "DFAppletClient connected to local port " + socket.getLocalPort() + " and remote port " + socket.getPort());
            }
            this.in = new DataInputStream(socket.getInputStream());
            this.parser = new ACLParser((InputStream)this.in);
            this.out = new PrintStream(socket.getOutputStream(), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.a.stop();
        }
    }

    void setGUI(DFGUI dFGUI) {
        this.gui = dFGUI;
    }

    DFGUI getGUI() {
        return this.gui;
    }

    public void doDelete() {
        this.gui.showStatusMsg("Operation not authorized");
    }

    public String getName() {
        String string = "df@" + this.hap;
        return string;
    }

    public void postGuiEvent(GuiEvent guiEvent) {
        switch (guiEvent.getType()) {
            case 0: {
                this.gui.dispose();
                this.a.destroy();
                break;
            }
            case 1: {
                this.gui.dispose();
                this.a.destroy();
                break;
            }
            case 1006: {
                this.refreshDFGUI();
                break;
            }
            case 1001: {
                this.RegisterNewAgent(guiEvent);
                break;
            }
            case 1002: {
                this.DeregisterAgent(guiEvent);
                break;
            }
            case 1004: {
                this.SearchAgents(guiEvent);
                break;
            }
            case 1003: {
                this.Modify(guiEvent);
                break;
            }
            case 1005: {
                this.Federate(guiEvent);
            }
        }
    }

    public void refreshDFGUI() {
        AID aID = this.getDescriptionOfThisDF().getName();
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        SearchConstraints searchConstraints = new SearchConstraints();
        try {
            Object object;
            FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID, "search", dFAgentDescription, searchConstraints);
            fIPAAppletRequestProto.doProto();
            Iterator iterator = fIPAAppletRequestProto.getSearchResult().iterator();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            while (iterator.hasNext()) {
                object = (DFAgentDescription)iterator.next();
                arrayList.add((Object)object.getName());
                if (!this.isADF((DFAgentDescription)object)) continue;
                arrayList2.add((Object)object.getName());
            }
            object = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "getparents", null, null);
            ((AppletRequestProto)object).doProto();
            Iterator iterator2 = ((JADEAppletRequestProto)object).getResult().iterator();
            this.gui.refresh(arrayList.iterator(), iterator2, arrayList2.iterator());
        }
        catch (FIPAAppletRequestProto.NotYetReady notYetReady) {
            notYetReady.printStackTrace();
        }
        catch (JADEAppletRequestProto.NotYetReady notYetReady) {
            notYetReady.printStackTrace();
        }
        catch (FIPAException fIPAException) {
            fIPAException.printStackTrace();
        }
    }

    private void RegisterNewAgent(GuiEvent guiEvent) {
        AID aID = (AID)guiEvent.getParameter(0);
        DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
        if (aID.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID, "register", dFAgentDescription, null);
                fIPAAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "registerwith", dFAgentDescription, aID);
                jADEAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
    }

    private void DeregisterAgent(GuiEvent guiEvent) {
        AID aID = (AID)guiEvent.getParameter(0);
        DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
        if (aID.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID, "deregister", dFAgentDescription, null);
                fIPAAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "deregisterfrom", dFAgentDescription, aID);
                jADEAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
    }

    private void SearchAgents(GuiEvent guiEvent) {
        AID aID = (AID)guiEvent.getParameter(0);
        DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
        SearchConstraints searchConstraints = (SearchConstraints)guiEvent.getParameter(2);
        if (aID.getName().equalsIgnoreCase(this.thisDF.getName().getName())) {
            try {
                FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID, "search", dFAgentDescription, searchConstraints);
                fIPAAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "searchon", dFAgentDescription, aID, searchConstraints);
                jADEAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
    }

    private void Modify(GuiEvent guiEvent) {
        AID aID = (AID)guiEvent.getParameter(0);
        DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
        if (aID.equals((Object)this.thisDF.getName())) {
            try {
                FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID, "modify", dFAgentDescription, null);
                fIPAAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        } else {
            try {
                JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.thisDF.getName(), "modifyon", dFAgentDescription, aID);
                jADEAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
    }

    private void Federate(GuiEvent guiEvent) {
        AID aID = (AID)guiEvent.getParameter(0);
        if (aID.equals((Object)this.thisDF.getName())) {
            this.gui.showStatusMsg("Self federation not allowed.");
            return;
        }
        DFAgentDescription dFAgentDescription = (DFAgentDescription)guiEvent.getParameter(1);
        try {
            JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "federate", dFAgentDescription, aID);
            jADEAppletRequestProto.doProto();
        }
        catch (FIPAException fIPAException) {
            fIPAException.printStackTrace();
        }
    }

    public DFAgentDescription getDFAgentDsc(AID aID) throws FIPAException {
        DFAgentDescription dFAgentDescription = null;
        AID aID2 = this.getDescriptionOfThisDF().getName();
        DFAgentDescription dFAgentDescription2 = new DFAgentDescription();
        dFAgentDescription2.setName(aID);
        SearchConstraints searchConstraints = new SearchConstraints();
        try {
            FIPAAppletRequestProto fIPAAppletRequestProto = new FIPAAppletRequestProto(this, aID2, "search", dFAgentDescription2, searchConstraints);
            fIPAAppletRequestProto.doProto();
            Iterator iterator = fIPAAppletRequestProto.getSearchResult().iterator();
            if (iterator.hasNext()) {
                dFAgentDescription = (DFAgentDescription)iterator.next();
            }
        }
        catch (FIPAAppletRequestProto.NotYetReady notYetReady) {
            notYetReady.printStackTrace();
        }
        catch (FIPAException fIPAException) {
            fIPAException.printStackTrace();
        }
        return dFAgentDescription;
    }

    public DFAgentDescription getDescriptionOfThisDF() {
        block2: {
            if (this.thisDF != null) break block2;
            AID aID = new AID(this.getName(), true);
            System.out.println(aID.getName());
            try {
                JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, aID, "getdescription", null, null);
                jADEAppletRequestProto.doProto();
            }
            catch (FIPAException fIPAException) {
                fIPAException.printStackTrace();
            }
        }
        return this.thisDF;
    }

    public DFAgentDescription getDescriptionOfThisDF(AID aID) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "CALLED METHOD: getDescriptionOfThisDF(aid) into DFAppletCommunicator");
        }
        DFAgentDescription dFAgentDescription = null;
        try {
            JADEAppletRequestProto jADEAppletRequestProto = new JADEAppletRequestProto(this, this.getDescriptionOfThisDF().getName(), "getdescriptionused", null, aID);
            jADEAppletRequestProto.doProto();
            List list = jADEAppletRequestProto.getResult();
            dFAgentDescription = (DFAgentDescription)list.get(0);
        }
        catch (FIPAException fIPAException) {
            fIPAException.printStackTrace();
        }
        catch (JADEAppletRequestProto.NotYetReady notYetReady) {
            notYetReady.printStackTrace();
        }
        return dFAgentDescription;
    }

    boolean isADF(DFAgentDescription dFAgentDescription) {
        try {
            ServiceDescription serviceDescription = (ServiceDescription)dFAgentDescription.getAllServices().next();
            return serviceDescription.getType().equalsIgnoreCase("fipa-df");
        }
        catch (Exception exception) {
            return false;
        }
    }

    void setDescription(DFAgentDescription dFAgentDescription) {
        this.thisDF = dFAgentDescription;
    }

    PrintStream getStream() {
        return this.out;
    }

    ACLParser getParser() {
        return this.parser;
    }
}

