/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.dfgui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAException;
import jade.gui.DFAgentDscDlg;
import jade.tools.dfgui.DFGUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class DFGUIViewAction
extends AbstractAction {
    private DFGUI gui;

    public DFGUIViewAction(DFGUI dFGUI) {
        super("View");
        this.gui = dFGUI;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        int n = this.gui.kindOfOperation();
        AID aID = this.gui.getSelectedAgentInTable();
        if (aID != null) {
            if (n == DFGUI.AGENT_VIEW || n == DFGUI.CHILDREN_VIEW || n == DFGUI.LASTSEARCH_VIEW) {
                try {
                    if (n == DFGUI.LASTSEARCH_VIEW) {
                        dFAgentDescription = this.gui.getDFAgentSearchDsc(aID);
                    }
                    dFAgentDescription = this.gui.myAgent.getDFAgentDsc(aID);
                }
                catch (FIPAException fIPAException) {
                    this.gui.showStatusMsg("WARNING! No description for agent called " + aID + " is found");
                    return;
                }
            } else if (n == DFGUI.PARENT_VIEW) {
                dFAgentDescription = this.gui.myAgent.getDescriptionOfThisDF(aID);
            }
        } else {
            return;
        }
        if (dFAgentDescription != null && n != -1) {
            DFAgentDscDlg dFAgentDscDlg = new DFAgentDscDlg(this.gui);
            dFAgentDscDlg.ShowDFDGui(dFAgentDescription, false, false);
        }
    }
}

