/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class ACLTimeChooserDialog
implements ActionListener {
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int OK = 1;
    public static final int CANCEL = 0;
    JToggleButton absButton;
    JToggleButton relButton;
    private Date date;
    private int mode;
    private int retVal = 0;
    private JDialog dlg;
    private JTextField year;
    private JTextField month;
    private JTextField day;
    private JTextField hour;
    private JTextField min;
    private JTextField sec;

    public ACLTimeChooserDialog() {
        this.date = null;
    }

    public ACLTimeChooserDialog(Date date) {
        this.date = date;
    }

    public static void main(String[] stringArray) {
        ACLTimeChooserDialog aCLTimeChooserDialog = new ACLTimeChooserDialog();
        aCLTimeChooserDialog.setDate(new Date());
        aCLTimeChooserDialog.showViewTimeDlg(null);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int showEditTimeDlg(JFrame jFrame) {
        this.dlg = new JDialog((Frame)jFrame, "Edit time");
        this.dlg.setBackground(Color.white);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (this.date != null) {
            gregorianCalendar.setTime(this.date);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 3));
        ((GridLayout)jPanel.getLayout()).setHgap(5);
        jPanel.setBackground(Color.white);
        this.year = new JTextField(4);
        this.year.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(1), this.year, "Year:", Integer.MAX_VALUE);
        this.month = new JTextField(4);
        this.month.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(2) + 1, this.month, "Month:", 12);
        this.day = new JTextField(4);
        this.day.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(5), this.day, "Day:", 31);
        this.hour = new JTextField(4);
        this.hour.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(11), this.hour, "Hour:", 23);
        this.min = new JTextField(4);
        this.min.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(12), this.min, "Min:", 59);
        this.sec = new JTextField(4);
        this.sec.setEditable(false);
        this.addTimeUnitLine(jPanel, gregorianCalendar.get(13), this.sec, "Sec:", 59);
        jPanel.setBorder(new TitledBorder("Time"));
        this.dlg.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        JButton jButton = new JButton("Set");
        jButton.setBackground(Color.white);
        jButton.setFont(new Font("Dialog", 0, 11));
        JButton jButton2 = new JButton("Reset");
        jButton2.setBackground(Color.white);
        jButton2.setFont(new Font("Dialog", 0, 11));
        JButton jButton3 = new JButton("Cancel");
        jButton3.setBackground(Color.white);
        jButton3.setFont(new Font("Dialog", 0, 11));
        jButton.setPreferredSize(jButton3.getPreferredSize());
        jButton2.setPreferredSize(jButton3.getPreferredSize());
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        this.dlg.getContentPane().add((Component)jPanel2, "South");
        this.dlg.setModal(true);
        this.dlg.pack();
        this.dlg.setResizable(false);
        if (jFrame != null) {
            this.dlg.setLocation(jFrame.getX() + (jFrame.getWidth() - this.dlg.getWidth()) / 2, jFrame.getY() + (jFrame.getHeight() - this.dlg.getHeight()) / 2);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)dimension.getWidth() / 2;
            int n2 = (int)dimension.getHeight() / 2;
            this.dlg.setLocation(n - this.dlg.getWidth() / 2, n2 - this.dlg.getHeight() / 2);
        }
        this.dlg.show();
        return this.retVal;
    }

    public void showViewTimeDlg(JFrame jFrame) {
        Serializable serializable;
        String string;
        this.dlg = new JDialog((Frame)jFrame, "View Time");
        this.dlg.getContentPane().setLayout(new BoxLayout(this.dlg.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        if (this.date == null) {
            string = new String("No time indication to display");
        } else {
            serializable = DateFormat.getDateTimeInstance(2, 3);
            string = ((DateFormat)serializable).format(this.date);
        }
        serializable = new JLabel(string);
        ((JComponent)serializable).setBackground(Color.white);
        ((JComponent)serializable).setFont(new Font("Dialog", 0, 11));
        jPanel.add((Component)serializable);
        this.dlg.getContentPane().add(jPanel);
        jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        JButton jButton = new JButton("Close");
        jButton.setBackground(Color.white);
        jButton.setFont(new Font("Dialog", 0, 11));
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.dlg.getContentPane().add(jPanel);
        this.dlg.setBackground(Color.white);
        this.dlg.setModal(true);
        this.dlg.pack();
        this.dlg.setResizable(false);
        if (jFrame != null) {
            this.dlg.setLocation(jFrame.getX() + (jFrame.getWidth() - this.dlg.getWidth()) / 2, jFrame.getY() + (jFrame.getHeight() - this.dlg.getHeight()) / 2);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)dimension.getWidth() / 2;
            int n2 = (int)dimension.getHeight() / 2;
            this.dlg.setLocation(n - this.dlg.getWidth() / 2, n2 - this.dlg.getHeight() / 2);
        }
        this.dlg.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Set")) {
            Integer n = new Integer(this.year.getText());
            int n2 = n;
            n = new Integer(this.month.getText());
            int n3 = n;
            n = new Integer(this.day.getText());
            int n4 = n;
            n = new Integer(this.hour.getText());
            int n5 = n;
            n = new Integer(this.min.getText());
            int n6 = n;
            n = new Integer(this.sec.getText());
            int n7 = n;
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            this.date = gregorianCalendar.getTime();
            this.retVal = 1;
            this.dlg.dispose();
        } else if (string.equals("Reset")) {
            this.date = null;
            this.retVal = 1;
            this.dlg.dispose();
        } else if (string.equals("Cancel")) {
            this.retVal = 0;
            this.dlg.dispose();
        } else if (string.equals("Close")) {
            this.dlg.dispose();
        } else if (string.equals("Absolute")) {
            this.absButton.setSelected(true);
            this.relButton.setSelected(false);
            this.mode = 0;
        } else if (string.equals("Relative")) {
            this.relButton.setSelected(true);
            this.absButton.setSelected(false);
            this.mode = 1;
        }
    }

    private void addTimeUnitLine(JPanel jPanel, int n, final JTextField jTextField, final String string, final int n2) {
        JPanel jPanel2 = new JPanel();
        ((FlowLayout)jPanel2.getLayout()).setHgap(0);
        jPanel2.setBackground(Color.white);
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(Color.white);
        jLabel.setFont(new Font("Dialog", 0, 11));
        jTextField.setText(String.valueOf(n));
        JButton jButton = new JButton("+");
        jButton.setBackground(Color.white);
        jButton.setFont(new Font("Dialog", 0, 11));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Integer n = new Integer(jTextField.getText());
                int n22 = n + 1;
                if (n22 <= n2) {
                    jTextField.setText(String.valueOf(n22));
                }
            }
        });
        JButton jButton2 = new JButton("-");
        jButton2.setBackground(Color.white);
        jButton2.setFont(new Font("Dialog", 0, 11));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Integer n2 = new Integer(jTextField.getText());
                int n3 = n2 - 1;
                int n4 = n = string.equalsIgnoreCase("Hour:") || string.equalsIgnoreCase("Min:") || string.equalsIgnoreCase("Sec:") ? 0 : 1;
                if (n3 >= n) {
                    jTextField.setText(String.valueOf(n3));
                }
            }
        });
        jButton.setMargin(new Insets(2, 4, 2, 4));
        jButton2.setMargin(new Insets(2, 4, 2, 4));
        Dimension dimension = new Dimension();
        dimension.height = jButton.getPreferredSize().height;
        dimension.width = new JLabel((String)"XXXXX").getPreferredSize().width;
        jLabel.setPreferredSize(dimension);
        jLabel.setAlignmentX(1.0f);
        jTextField.setPreferredSize(new Dimension(50, dimension.height));
        jPanel2.add(jLabel);
        jPanel2.add(jButton);
        jPanel2.add(jTextField);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
    }
}

