/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import jade.tools.gui.ACLFrame;
import jade.tools.gui.ACLMessageNode;
import jade.tools.gui.ACLPerformativesRenderer;
import jade.tools.gui.ACLStatisticsFrame;
import jade.tools.sl.SLFormatter;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ACLTracePanel
extends JPanel {
    private Logger logger = Logger.getMyLogger((String)this.getClass().getName());
    public static final String DIRECTION_IN = "in";
    public static final String DIRECTION_OUT = "out";
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    JLabel jLabel1 = new JLabel();
    ButtonGroup sortingButtonGroup = new ButtonGroup();
    JComboBox sortComboBox = new JComboBox();
    JRadioButton ascRadioButton = new JRadioButton();
    JRadioButton descRadioButton = new JRadioButton();
    JButton sortButton = new JButton();
    JMenuItem saveQMenuItem = new JMenuItem();
    JMenuItem openQMenuItem = new JMenuItem();
    JMenuItem clearQMenuItem = new JMenuItem();
    Border border2;
    Border border3;
    private boolean sorting = false;
    private JMenuItem deleteMenuItem = new JMenuItem();
    private int inMsgCount = 0;
    private int outMsgCount = 0;
    private int aclIndex = 0;
    private DefaultMutableTreeNode aclRoot = new DefaultMutableTreeNode("messagetrace");
    private DefaultTreeModel aclModel = new DefaultTreeModel(this.aclRoot);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JScrollPane aclTreeScrollPane = new JScrollPane();
    private JTree aclTree = new JTree();
    private ACLTreeRenderer aclTreeRenderer = new ACLTreeRenderer();
    private JPopupMenu thePopupMenu = new JPopupMenu();
    private JMenuItem systemMenuItem = new JMenuItem();
    private JMenuItem zoomMenuItem = new JMenuItem();
    private int currentSelection = 0;
    private JMenuItem saveMenuItem = new JMenuItem();
    private JMenuItem stasticsMenuItem = new JMenuItem();
    private JMenuItem aboutMenuItem = new JMenuItem();
    private ImageIcon sortIcon = new ImageIcon(this.getClass().getResource("images/sort.gif"));
    private DefaultComboBoxModel sortComboBoxModel = new DefaultComboBoxModel();
    private Agent agent;
    private File currentDir;
    private int x;
    private int y;
    private ACLMessage currentACL;
    private Border border1;
    private TitledBorder titledBorder1;

    public ACLTracePanel(Agent agent) {
        this.agent = agent;
        this.inMsgCount = 0;
        this.outMsgCount = 0;
        this.aclIndex = 0;
        try {
            this.jbInit();
            this.aclTree.setCellRenderer(this.aclTreeRenderer);
            this.fillSortComboBoxModel();
            this.sortComboBox.setModel(this.sortComboBoxModel);
            this.sortComboBox.setRenderer(new SortRenderer());
            this.sortComboBox.setSelectedIndex(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ACLMessage getCurrentACL() {
        return this.currentACL;
    }

    public void doSystemOut() {
        if (this.currentACL == null) {
            return;
        }
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "\n" + this.currentACL.toString() + "\n");
        }
    }

    public void addMessageNode(ACLMessageNode aCLMessageNode) {
        this.addMessageNode(aCLMessageNode.getDirection(), aCLMessageNode.getTime(), aCLMessageNode.getMessage());
    }

    public void addMessageNode(String string, ACLMessage aCLMessage) {
        String string2 = this.getTimeStamp();
        this.addMessageNode(string, string2, aCLMessage);
    }

    public void addMessageNode(String string, String string2, ACLMessage aCLMessage) {
        Properties properties;
        Date date;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9 = aCLMessage.toString();
        string9 = string9.replace('\n', ' ');
        String string10 = aCLMessage.getContent() != null ? aCLMessage.getContent().replace('\n', ' ') : "";
        String string11 = aCLMessage.getSender().getLocalName();
        String string12 = "<none>";
        if (aCLMessage.getAllReceiver().hasNext()) {
            string12 = ((AID)aCLMessage.getAllReceiver().next()).getLocalName();
        }
        if (string.startsWith("i")) {
            ++this.inMsgCount;
            string9 = ACLMessage.getPerformative((int)aCLMessage.getPerformative()) + ": from  " + string11 + " - " + string10 + " ";
        } else {
            ++this.outMsgCount;
            string9 = ACLMessage.getPerformative((int)aCLMessage.getPerformative()) + ": to  " + string12 + " - " + string10 + " ";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(":content");
        ACLMessageNode aCLMessageNode = new ACLMessageNode(string2 + " " + string + ": " + string9);
        aCLMessageNode.setMessage(aCLMessage);
        aCLMessageNode.setDirection(string);
        aCLMessageNode.setTime(string2);
        this.aclModel.insertNodeInto(aCLMessageNode, this.aclRoot, this.aclIndex++);
        String string13 = aCLMessage.getLanguage() != null ? aCLMessage.getLanguage() : "<unknown>";
        String string14 = string8 = aCLMessage.getContent() != null ? aCLMessage.getContent() : "";
        if (string13.indexOf("SL") >= 0) {
            try {
                new SLFormatter();
                string8 = SLFormatter.format(string8);
            }
            catch (Exception exception) {}
        }
        while (string8.indexOf(10) == 0) {
            string8 = string8.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string8, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(stringTokenizer.nextToken()));
        }
        int n = 0;
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":act " + ACLMessage.getPerformative((int)aCLMessage.getPerformative())), aCLMessageNode, n++);
        AID aID = aCLMessage.getSender();
        if (aID != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":sender " + aID.toString()), aCLMessageNode, n++);
        }
        AID aID2 = new AID();
        Iterator iterator = aCLMessage.getAllReceiver();
        while (iterator.hasNext()) {
            aID2 = (AID)iterator.next();
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":receiver " + aID2.toString()), aCLMessageNode, n++);
        }
        Iterator iterator2 = aCLMessage.getAllReplyTo();
        while (iterator2.hasNext()) {
            aID2 = (AID)iterator2.next();
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-to " + aID2.toString()), aCLMessageNode, n++);
        }
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- Description of Content ---"), aCLMessageNode, n++);
        this.aclModel.insertNodeInto(defaultMutableTreeNode, aCLMessageNode, n++);
        String string15 = aCLMessage.getLanguage();
        if (string15 != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":language " + string15), aCLMessageNode, n++);
        }
        if ((string7 = aCLMessage.getEncoding()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":encoding " + string7), aCLMessageNode, n++);
        }
        if ((string6 = aCLMessage.getOntology()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":ontology " + string6), aCLMessageNode, n++);
        }
        this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- Message control ---"), aCLMessageNode, n++);
        String string16 = aCLMessage.getProtocol();
        if (string16 != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":protocol " + string16), aCLMessageNode, n++);
        }
        if ((string5 = aCLMessage.getConversationId()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":conversation-id " + string5), aCLMessageNode, n++);
        }
        if ((string4 = aCLMessage.getInReplyTo()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":in-reply-to " + string4), aCLMessageNode, n++);
        }
        if ((string3 = aCLMessage.getReplyWith()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-with " + string3), aCLMessageNode, n++);
        }
        if ((date = aCLMessage.getReplyByDate()) != null) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":reply-by " + date.toString()), aCLMessageNode, n++);
        }
        if ((properties = aCLMessage.getAllUserDefinedParameters()).size() > 0) {
            this.aclModel.insertNodeInto(new DefaultMutableTreeNode("--- User Defined Parameters ---"), aCLMessageNode, n++);
            Enumeration enumeration = properties.elements();
            while (enumeration.hasMoreElements()) {
                String string17 = (String)enumeration.nextElement();
                String string18 = properties.getProperty(string17);
                this.aclModel.insertNodeInto(new DefaultMutableTreeNode(":X-" + string17 + " " + string18), aCLMessageNode, n++);
            }
        }
        if (!this.sorting) {
            this.doSort();
        }
        this.aclTree.expandPath(new TreePath(this.aclRoot.getPath()));
    }

    public void deleteCurrent() {
        TreePath treePath = this.aclTree.getSelectionPath();
        if (treePath == null) {
            this.currentACL = null;
        } else {
            this.currentACL = ((ACLMessageNode)treePath.getPathComponent(1)).getMessage();
            this.aclModel.removeNodeFromParent((ACLMessageNode)treePath.getPathComponent(1));
            this.refresh();
            --this.aclIndex;
        }
    }

    public void doShowAbout() {
        new AboutFrame().show();
    }

    public void saveACL() {
        block5: {
            int n;
            UIManager.put("FileChooser.saveButtonToolTipText", "Save ACLMessage");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new ACLFileFilter());
            jFileChooser.setSelectedFile(new File("itsmessage.acl"));
            jFileChooser.setDialogTitle("Save ACLMessage");
            if (this.currentDir != null) {
                jFileChooser.setCurrentDirectory(this.currentDir);
            }
            if ((n = jFileChooser.showSaveDialog(null)) != 0) break block5;
            this.currentDir = jFileChooser.getCurrentDirectory();
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            try {
                FileWriter fileWriter = new FileWriter(string);
                StringACLCodec stringACLCodec = new StringACLCodec(null, (Writer)fileWriter);
                stringACLCodec.write(this.currentACL);
                fileWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + string);
                }
            }
            catch (IOException iOException) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block5;
                this.logger.log(Logger.WARNING, "IO Exception");
            }
        }
    }

    public void doShowCurrentACL() {
        this.showCurrentACL(this.x, this.y);
    }

    public void showStastistics() {
        ACLStatisticsFrame.show(this.aclModel);
    }

    public void saveQueue() {
        block7: {
            int n;
            UIManager.put("FileChooser.saveButtonToolTipText", "Save ACLMessage Trace");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new TraceFileFilter());
            jFileChooser.setSelectedFile(new File("itsTrace.trc"));
            jFileChooser.setDialogTitle("Save ACLMessage Trace");
            if (this.currentDir != null) {
                jFileChooser.setCurrentDirectory(this.currentDir);
            }
            if ((n = jFileChooser.showSaveDialog(null)) != 0) break block7;
            this.currentDir = jFileChooser.getCurrentDirectory();
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".trc")) {
                string = string + ".trc";
            }
            try {
                FileWriter fileWriter = new FileWriter(string);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                int n2 = this.aclModel.getChildCount(this.aclRoot);
                int n3 = 0;
                while (n3 < n2) {
                    System.out.println("aclModel: " + this.aclModel.getChild(this.aclRoot, n3).getClass());
                    ACLMessageNode aCLMessageNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, n3);
                    String string2 = aCLMessageNode.getDirection();
                    String string3 = aCLMessageNode.getTime();
                    ACLMessage aCLMessage = aCLMessageNode.getMessage();
                    bufferedWriter.newLine();
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                    bufferedWriter.write(string3);
                    bufferedWriter.newLine();
                    bufferedWriter.write(aCLMessage.toString());
                    bufferedWriter.newLine();
                    ++n3;
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + string);
                }
            }
            catch (IOException iOException) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block7;
                this.logger.log(Logger.WARNING, "IO Exception");
            }
        }
    }

    public void loadQueue() {
        block9: {
            int n;
            UIManager.put("FileChooser.openButtonToolTipText", "Open ACLMessage Trace");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new TraceFileFilter());
            jFileChooser.setDialogTitle("Open ACLMessage Trace From File");
            if (this.currentDir != null) {
                jFileChooser.setCurrentDirectory(this.currentDir);
            }
            if ((n = jFileChooser.showOpenDialog(null)) != 0) break block9;
            this.currentDir = jFileChooser.getCurrentDirectory();
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            try {
                this.clearACLModel();
                FileReader fileReader = new FileReader(string);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String string3 = bufferedReader.readLine();
                    String string4 = bufferedReader.readLine();
                    String string5 = "";
                    string2 = bufferedReader.readLine();
                    while (string2 != null && !string2.equals("")) {
                        string5 = string5 + "\n" + string2;
                        string2 = bufferedReader.readLine();
                    }
                    char[] cArray = string5.toCharArray();
                    StringACLCodec stringACLCodec = new StringACLCodec((Reader)new StringReader(new String(cArray)), null);
                    ACLMessage aCLMessage = stringACLCodec.decode();
                    this.addMessageNode(string3, string4, aCLMessage);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Can't open file: " + string);
                }
            }
            catch (IOException iOException) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "IO Exception");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void clearACLModel() {
        int n = this.aclModel.getChildCount(this.aclRoot);
        int n2 = n - 1;
        while (n2 >= 0) {
            ACLMessageNode aCLMessageNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, n2);
            this.aclRoot.remove(aCLMessageNode);
            --n2;
        }
        this.aclIndex = 0;
        this.aclModel.reload();
        this.aclTree.validate();
        this.aclTree.repaint();
    }

    public void doSort() {
        int n = this.sortComboBox.getSelectedIndex();
        int n2 = this.ascRadioButton.isSelected() ? 1 : -1;
        ACLMessageNodeComparator aCLMessageNodeComparator = new ACLMessageNodeComparator(n, n2);
        int n3 = this.aclModel.getChildCount(this.aclRoot);
        if (n3 < 2) {
            return;
        }
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        while (n4 < n3) {
            ACLMessageNode aCLMessageNode = (ACLMessageNode)this.aclModel.getChild(this.aclRoot, n4);
            objectArray[n4] = aCLMessageNode;
            ++n4;
        }
        Arrays.sort(objectArray, aCLMessageNodeComparator);
        this.clearACLModel();
        this.sorting = true;
        int n5 = 0;
        while (n5 < n3) {
            ACLMessageNode aCLMessageNode = (ACLMessageNode)objectArray[n5];
            this.addMessageNode(aCLMessageNode);
            ++n5;
        }
        this.sorting = false;
        this.aclModel.reload();
        this.aclTree.validate();
        this.aclTree.repaint();
    }

    String getTimeStamp() {
        return dateFormat.format(new Date());
    }

    void refresh() {
        this.aclTree.validate();
        this.aclTree.updateUI();
    }

    void aclTree_mouseClicked(MouseEvent mouseEvent) {
        try {
            TreePath treePath = this.aclTree.getSelectionPath();
            this.currentACL = treePath == null ? null : ((ACLMessageNode)treePath.getPathComponent(1)).getMessage();
            if (mouseEvent.getModifiers() == 4) {
                if (this.currentACL == null) {
                    JOptionPane.showMessageDialog(null, "No ACL", "Select a Message", 0);
                    return;
                }
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                this.thePopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                if (this.currentACL == null) {
                    JOptionPane.showMessageDialog(null, "No ACL", "Select a Message", 0);
                    return;
                }
                this.showCurrentACL(mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {}
    }

    void systemMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.currentACL == null) {
            return;
        }
    }

    void zoomMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.doShowCurrentACL();
    }

    void saveMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.saveACL();
    }

    void stasticsMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.showStastistics();
    }

    void aclTree_keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            this.deleteCurrent();
        }
    }

    void deleteMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.deleteCurrent();
    }

    void sortButton_actionPerformed(ActionEvent actionEvent) {
        this.doSort();
    }

    void sortComboBox_itemStateChanged(ItemEvent itemEvent) {
        this.doSort();
    }

    void ascRadioButton_itemStateChanged(ItemEvent itemEvent) {
        this.doSort();
    }

    void descRadioButton_itemStateChanged(ItemEvent itemEvent) {
        this.doSort();
    }

    void aboutMenuItem_mouseClicked(MouseEvent mouseEvent) {
        this.doShowAbout();
    }

    void saveQMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.saveQueue();
    }

    void clearQMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.clearACLModel();
    }

    void openQMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.loadQueue();
    }

    void aboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.doShowAbout();
    }

    private void fillSortComboBoxModel() {
        this.sortComboBoxModel.addElement("date");
        this.sortComboBoxModel.addElement("direction");
        this.sortComboBoxModel.addElement("sender");
        this.sortComboBoxModel.addElement("receiver");
        this.sortComboBoxModel.addElement("performative");
        this.sortComboBoxModel.addElement("ontology");
    }

    private void showCurrentACL(int n, int n2) {
        if (this.currentACL == null) {
            return;
        }
        ACLFrame.show(this.currentACL, this.agent);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder1 = new TitledBorder(this.border1, "actions");
        this.border2 = BorderFactory.createLineBorder(Color.black, 0);
        this.border3 = BorderFactory.createLineBorder(Color.darkGray, 1);
        this.setLayout(this.gridBagLayout2);
        this.aclTree.setModel(this.aclModel);
        this.aclTree.addKeyListener(new ACLTreePanel_aclTree_keyAdapter(this));
        this.aclTree.addMouseListener(new ACLTreePanel_aclTree_mouseAdapter(this));
        this.addMouseListener(new ACLTreePanel_this_mouseAdapter(this));
        this.systemMenuItem.setBackground(Color.white);
        this.systemMenuItem.setFont(new Font("Dialog", 0, 11));
        this.systemMenuItem.setMnemonic('O');
        this.systemMenuItem.setText("System.out");
        this.systemMenuItem.addActionListener(new ACLTreePanel_systemMenuItem_actionAdapter(this));
        this.zoomMenuItem.setBackground(Color.white);
        this.zoomMenuItem.setFont(new Font("Dialog", 0, 11));
        this.zoomMenuItem.setMnemonic('V');
        this.zoomMenuItem.setText("View ACLMessage");
        this.zoomMenuItem.addActionListener(new ACLTreePanel_zoomMenuItem_actionAdapter(this));
        this.thePopupMenu.setBackground(Color.white);
        this.thePopupMenu.setBorder(BorderFactory.createLineBorder(Color.black));
        this.thePopupMenu.setOpaque(false);
        this.saveMenuItem.setBackground(Color.white);
        this.saveMenuItem.setFont(new Font("Dialog", 0, 11));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save ACLMessage");
        this.saveMenuItem.addActionListener(new ACLTreePanel_saveMenuItem_actionAdapter(this));
        this.stasticsMenuItem.setBackground(Color.white);
        this.stasticsMenuItem.setFont(new Font("Dialog", 0, 11));
        this.stasticsMenuItem.setMnemonic('T');
        this.stasticsMenuItem.setText("Show Statistics");
        this.stasticsMenuItem.addActionListener(new ACLTreePanel_stasticsMenuItem_actionAdapter(this));
        this.aboutMenuItem.setBackground(Color.white);
        this.aboutMenuItem.setFont(new Font("Dialog", 0, 11));
        this.aboutMenuItem.setForeground(new Color(0, 0, 140));
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ACLTracePanel_aboutMenuItem_actionAdapter(this));
        this.deleteMenuItem.setBackground(Color.white);
        this.deleteMenuItem.setFont(new Font("Dialog", 0, 11));
        this.deleteMenuItem.setMnemonic('D');
        this.deleteMenuItem.setText("Delete ACLMessage");
        this.deleteMenuItem.addActionListener(new ACLTreePanel_deleteMenuItem_actionAdapter(this));
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setOpaque(true);
        this.jLabel1.setText("sort by:");
        this.ascRadioButton.setSelected(true);
        this.ascRadioButton.setText("Ascending");
        this.ascRadioButton.setToolTipText("Sort ACLMessage Trace Ascending");
        this.ascRadioButton.setBackground(Color.white);
        this.ascRadioButton.setFont(new Font("Dialog", 0, 12));
        this.ascRadioButton.addItemListener(new ACLTracePanel_ascRadioButton_itemAdapter(this));
        this.descRadioButton.setText("Descending");
        this.descRadioButton.setToolTipText("Sort ACLMessage Trace Descending");
        this.descRadioButton.setBackground(Color.white);
        this.descRadioButton.setFont(new Font("Dialog", 0, 12));
        this.descRadioButton.addItemListener(new ACLTracePanel_descRadioButton_itemAdapter(this));
        this.sortButton.setForeground(Color.white);
        this.sortButton.setBorder(this.border2);
        this.sortButton.setMaximumSize(new Dimension(23, 20));
        this.sortButton.setPreferredSize(new Dimension(23, 20));
        this.sortButton.setToolTipText("Sort ACLMessage Trace");
        this.sortButton.setIcon(this.sortIcon);
        this.sortButton.addActionListener(new ACLTracePanel_sortButton_actionAdapter(this));
        this.sortButton.addActionListener(new ACLTracePanel_sortButton_actionAdapter(this));
        this.setBackground(Color.white);
        this.sortComboBox.setBackground(Color.white);
        this.sortComboBox.setFont(new Font("Dialog", 0, 12));
        this.sortComboBox.setForeground(Color.blue);
        this.sortComboBox.setToolTipText("Select on which field to sort the ACLMessage Trace");
        this.sortComboBox.addItemListener(new ACLTracePanel_sortComboBox_itemAdapter(this));
        this.aclTreeScrollPane.setBorder(this.border3);
        this.saveQMenuItem.setBackground(Color.white);
        this.saveQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.saveQMenuItem.setMnemonic('A');
        this.saveQMenuItem.setText("Save ACLMessage Trace");
        this.saveQMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLTracePanel.this.saveQMenuItem_actionPerformed(actionEvent);
            }
        });
        this.openQMenuItem.setBackground(Color.white);
        this.openQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.openQMenuItem.setMnemonic('P');
        this.openQMenuItem.setText("Open ACLMessage Trace");
        this.openQMenuItem.addActionListener(new ACLTracePanel_openQMenuItem_actionAdapter(this));
        this.clearQMenuItem.setBackground(Color.white);
        this.clearQMenuItem.setFont(new Font("Dialog", 0, 11));
        this.clearQMenuItem.setMnemonic('C');
        this.clearQMenuItem.setText("Clear ACLMessage Trace");
        this.clearQMenuItem.addActionListener(new ACLTracePanel_clearQMenuItem_actionAdapter(this));
        this.add((Component)this.aclTreeScrollPane, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sortComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.ascRadioButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.descRadioButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sortButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.aclTreeScrollPane.getViewport().add((Component)this.aclTree, null);
        this.thePopupMenu.add(this.systemMenuItem);
        this.thePopupMenu.add(this.zoomMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.saveMenuItem);
        this.thePopupMenu.add(this.deleteMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.saveQMenuItem);
        this.thePopupMenu.add(this.openQMenuItem);
        this.thePopupMenu.add(this.clearQMenuItem);
        this.thePopupMenu.addSeparator();
        this.thePopupMenu.add(this.stasticsMenuItem);
        this.thePopupMenu.add(this.aboutMenuItem);
        this.sortingButtonGroup.add(this.ascRadioButton);
        this.sortingButtonGroup.add(this.descRadioButton);
    }

    private class ACLTracePanel_aboutMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_aboutMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.aboutMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTracePanel_openQMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_openQMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.openQMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTracePanel_clearQMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_clearQMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.clearQMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTracePanel_aboutMenuItem_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTracePanel_aboutMenuItem_mouseAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.adaptee.aboutMenuItem_mouseClicked(mouseEvent);
        }
    }

    private class SortRenderer
    extends JLabel
    implements ListCellRenderer {
        public SortRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 10));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                String string = (String)object;
                this.setText((String)object);
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.blue);
            }
            return this;
        }
    }

    private class ACLTreeRenderer
    extends JLabel
    implements TreeCellRenderer {
        public ImageIcon rootIcon = new ImageIcon(this.getClass().getResource("images/inbox.gif"));
        public ImageIcon nodeIcon = new ImageIcon(this.getClass().getResource("images/service.gif"));
        public ImageIcon smallAgentIcon = new ImageIcon(this.getClass().getResource("images/smallagent.gif"));
        public ImageIcon messageTypeIcon = new ImageIcon(this.getClass().getResource("images/messagetype.gif"));
        public ImageIcon detailsIcon = new ImageIcon(this.getClass().getResource("images/details.gif"));
        public ImageIcon incomingIcon = new ImageIcon(this.getClass().getResource("images/incoming.gif"));
        public ImageIcon outgoingIcon = new ImageIcon(this.getClass().getResource("images/outgoing.gif"));

        ACLTreeRenderer() {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.setText(((DefaultMutableTreeNode)object).toString());
            int n2 = ((DefaultMutableTreeNode)object).getLevel();
            this.setFont(new Font("SansSerif", 0, 11));
            Color color = Color.black;
            String string = object.toString();
            switch (n2) {
                case 0: {
                    this.setIcon(this.rootIcon);
                    break;
                }
                case 1: {
                    if (string.indexOf("in:") > 0) {
                        this.setIcon(this.incomingIcon);
                        color = Color.red;
                        break;
                    }
                    this.setIcon(this.outgoingIcon);
                    color = Color.blue;
                    break;
                }
                case 2: {
                    this.setIcon(this.nodeIcon);
                    if (string.startsWith(":act ")) {
                        this.setIcon(this.messageTypeIcon);
                        String string2 = string.substring(5, string.length());
                        color = ACLPerformativesRenderer.determineColor(string2);
                        this.setFont(new Font("SansSerif", 1, 11));
                    }
                    if (string.startsWith(":content")) {
                        this.setIcon(this.detailsIcon);
                    }
                    if (string.startsWith(":sender")) {
                        this.setIcon(this.smallAgentIcon);
                    }
                    if (!string.startsWith(":receiver") && !string.startsWith(":reply-to")) break;
                    this.setIcon(this.smallAgentIcon);
                    break;
                }
                case 3: {
                    this.setIcon(this.detailsIcon);
                }
            }
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : color);
            return this;
        }

        private void jbInit() throws Exception {
            this.setFont(new Font("SansSerif", 0, 11));
            this.setOpaque(true);
        }
    }

    private class ACLTreePanel_deleteMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_deleteMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.deleteMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTreePanel_aclTree_keyAdapter
    extends KeyAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_aclTree_keyAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.adaptee.aclTree_keyTyped(keyEvent);
        }
    }

    private class ACLTreePanel_saveMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_saveMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.saveMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTreePanel_zoomMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_zoomMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.zoomMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTreePanel_systemMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_systemMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.systemMenuItem_actionPerformed(actionEvent);
        }
    }

    private class ACLTreePanel_aclTree_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_aclTree_mouseAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.adaptee.aclTree_mouseClicked(mouseEvent);
        }
    }

    private class ACLTreePanel_this_mouseAdapter
    extends MouseAdapter {
        ACLTracePanel adaptee;

        ACLTreePanel_this_mouseAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }

    private class ACLTreePanel_stasticsMenuItem_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTreePanel_stasticsMenuItem_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.stasticsMenuItem_actionPerformed(actionEvent);
        }
    }

    private class AboutFrame
    extends JWindow {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel logoLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        Border border1;

        public AboutFrame() {
            try {
                this.jbInit();
                this.setSize(400, 175);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void logoLabel_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void logoLabel3_mousePressed(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel2_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void logoLabel3_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void logoLabel_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void logoLabel_mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void logoLabel3_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void logoLabel3_mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void jLabel2_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel2_mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void logoLabel_mousePressed(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void logoLabel_mouseReleased(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel2_mousePressed(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel2_mouseReleased(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel4_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void contentPanel_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel1_mouseClicked(MouseEvent mouseEvent) {
            this.setVisible(false);
        }

        void jLabel4_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel1_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void contentPanel_mouseEntered(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        void jLabel4_mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        void contentPanel_mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        private void jbInit() throws Exception {
            this.border1 = new TitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 128), 1), "jade.tools.gui");
            this.getContentPane().setBackground(Color.white);
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.contentPanel.setLayout(this.gridBagLayout2);
            this.jLabel1.setText("donated by Acklin B.V. to the Jade project");
            this.jLabel1.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = aboutFrame;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.jLabel1_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.jLabel1_mouseEntered(mouseEvent);
                }
            });
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jLabel2.setText("web: www.acklin.nl  |  email: info@acklin.nl");
            this.jLabel2.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = aboutFrame;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.jLabel2_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.jLabel2_mouseEntered(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.jLabel2_mouseExited(mouseEvent);
                }
            });
            this.contentPanel.setBackground(Color.white);
            this.contentPanel.setFont(new Font("Dialog", 0, 11));
            this.contentPanel.setBorder(this.border1);
            this.contentPanel.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = aboutFrame;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.contentPanel_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.contentPanel_mouseEntered(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.contentPanel_mouseExited(mouseEvent);
                }
            });
            this.logoLabel3.setFont(new Font("SansSerif", 1, 60));
            this.logoLabel3.setForeground(new Color(0, 0, 128));
            this.logoLabel3.setText("Acklin");
            this.logoLabel3.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = aboutFrame;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.logoLabel3_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.logoLabel3_mouseEntered(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.logoLabel3_mouseExited(mouseEvent);
                }
            });
            this.jLabel4.setFont(new Font("Dialog", 1, 20));
            this.jLabel4.setForeground(Color.darkGray);
            this.jLabel4.setText("agent based support");
            this.jLabel4.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AboutFrame this$1;
                {
                    this.this$1 = aboutFrame;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.jLabel4_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.jLabel4_mouseEntered(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.jLabel4_mouseExited(mouseEvent);
                }
            });
            this.getContentPane().add((Component)this.contentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.contentPanel.add((Component)this.logoLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.contentPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        }
    }

    private class TraceFileFilter
    extends FileFilter {
        private String[] extensions = new String[]{".trc"};

        public String getDescription() {
            return "ACLMessageTrace files (*.trc)";
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.isFile() && file.getName().endsWith(".trc");
        }
    }

    private class ACLFileFilter
    extends FileFilter {
        public String getDescription() {
            return "ACLMessage files (*.acl)";
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.isFile() && file.getName().endsWith(".acl");
        }
    }

    private class ACLTracePanel_sortButton_actionAdapter
    implements ActionListener {
        ACLTracePanel adaptee;

        ACLTracePanel_sortButton_actionAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.sortButton_actionPerformed(actionEvent);
        }
    }

    private class ACLTracePanel_descRadioButton_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_descRadioButton_itemAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.adaptee.descRadioButton_itemStateChanged(itemEvent);
        }
    }

    private class ACLTracePanel_ascRadioButton_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_ascRadioButton_itemAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.adaptee.ascRadioButton_itemStateChanged(itemEvent);
        }
    }

    private class ACLTracePanel_sortComboBox_itemAdapter
    implements ItemListener {
        ACLTracePanel adaptee;

        ACLTracePanel_sortComboBox_itemAdapter(ACLTracePanel aCLTracePanel2) {
            this.adaptee = aCLTracePanel2;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.adaptee.sortComboBox_itemStateChanged(itemEvent);
        }
    }

    private class ACLMessageNodeComparator
    implements Comparator {
        static final int DATE = 0;
        static final int DIRECTION = 1;
        static final int SENDER = 2;
        static final int RECEIVER = 3;
        static final int PERFORMATIVE = 4;
        static final int ONTOLOGY = 5;
        static final int SORT_ASCENDING = 1;
        static final int SORT_DESCENDING = -1;
        private int sorting;
        private int mode;

        public ACLMessageNodeComparator(int n, int n2) {
            this.mode = n;
            this.sorting = n2;
        }

        public int compare(Object object, Object object2) {
            ACLMessageNode aCLMessageNode = (ACLMessageNode)object;
            ACLMessageNode aCLMessageNode2 = (ACLMessageNode)object2;
            String string = "";
            String string2 = "";
            switch (this.mode) {
                case 1: {
                    string = aCLMessageNode.getDirection() != null ? aCLMessageNode.getDirection() : "";
                    string2 = aCLMessageNode2.getDirection() != null ? aCLMessageNode2.getDirection() : "";
                    break;
                }
                case 0: {
                    Date date = aCLMessageNode.getTheDate();
                    Date date2 = aCLMessageNode2.getTheDate();
                    return this.sorting * date.compareTo(date2);
                }
                case 2: {
                    string = aCLMessageNode.getMessage().getSender() != null ? aCLMessageNode.getMessage().getSender().getName() : "";
                    string2 = aCLMessageNode2.getMessage().getSender() != null ? aCLMessageNode2.getMessage().getSender().getName() : "";
                    break;
                }
                case 3: {
                    string = aCLMessageNode.getMessage().getAllReceiver().hasNext() ? ((AID)aCLMessageNode.getMessage().getAllReceiver().next()).getName() : "";
                    string2 = aCLMessageNode2.getMessage().getAllReceiver().hasNext() ? ((AID)aCLMessageNode2.getMessage().getAllReceiver().next()).getName() : "";
                    break;
                }
                case 4: {
                    string = ACLMessage.getPerformative((int)aCLMessageNode.getMessage().getPerformative());
                    string2 = ACLMessage.getPerformative((int)aCLMessageNode2.getMessage().getPerformative());
                    break;
                }
                case 5: {
                    string = aCLMessageNode.getMessage().getOntology() != null ? aCLMessageNode.getMessage().getOntology() : "";
                    string2 = aCLMessageNode2.getMessage().getOntology() != null ? aCLMessageNode2.getMessage().getOntology() : "";
                }
            }
            return this.sorting * string.compareTo(string2);
        }

        public boolean equals(Object object) {
            throw new UnsupportedOperationException("Method equals() not yet implemented.");
        }
    }
}

