/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector;

import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPAService;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.SentMessage;
import jade.domain.introspection.StartNotify;
import jade.gui.AgentTreeModel;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREInitiator;
import jade.proto.SimpleAchieveREResponder;
import jade.tools.ToolAgent;
import jade.tools.introspector.Sensor;
import jade.tools.introspector.SensorManager;
import jade.tools.introspector.gui.IntrospectorGUI;
import jade.tools.introspector.gui.MainWindow;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Introspector
extends ToolAgent {
    private Set allAgents = null;
    private Hashtable preload = null;
    private static Logger logger = Logger.getMyLogger((String)(class$jade$tools$introspector$Introspector == null ? (class$jade$tools$introspector$Introspector = Introspector.class$("jade.tools.introspector.Introspector")) : class$jade$tools$introspector$Introspector).getName());
    public static final int STEP_EVENT = 1;
    public static final int BREAK_EVENT = 2;
    public static final int SLOW_EVENT = 3;
    public static final int GO_EVENT = 4;
    public static final int KILL_EVENT = 5;
    public static final int SUSPEND_EVENT = 6;
    private IntrospectorGUI myGUI;
    private Sensor guiSensor = new Sensor();
    private String myContainerName;
    private Map windowMap = Collections.synchronizedMap(new TreeMap());
    private Set stepByStepAgents = new HashSet();
    private Set slowAgents = new HashSet();
    private Map pendingReplies = new HashMap();
    private Map notifiers = new HashMap();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    static /* synthetic */ Class class$jade$tools$introspector$Introspector;

    public void toolSetup() {
        ACLMessage aCLMessage = this.getRequest();
        aCLMessage.setOntology("JADE-Agent-Management");
        this.AMSSubscribe.addSubBehaviour((Behaviour)new SenderBehaviour((Agent)this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour((Behaviour)new IntrospectorAMSListenerBehaviour());
        this.addBehaviour((Behaviour)this.AMSSubscribe);
        this.addBehaviour((Behaviour)new IntrospectionListenerBehaviour());
        this.addBehaviour((Behaviour)new ControlListenerBehaviour((Agent)this));
        this.addBehaviour((Behaviour)new RequestListenerBehaviour());
        this.addBehaviour((Behaviour)new SensorManager((Agent)this, this.guiSensor){

            public void onEvent(Event event) {
                AID aID = ((MainWindow)event.getSource()).getDebugged();
                switch (event.getType()) {
                    case 1: {
                        Introspector.this.proceed(aID);
                        break;
                    }
                    case 2: {
                        Introspector.this.stepByStepAgents.add(aID);
                        Introspector.this.slowAgents.remove(aID);
                        break;
                    }
                    case 3: {
                        Introspector.this.stepByStepAgents.remove(aID);
                        Introspector.this.slowAgents.add(aID);
                        Introspector.this.proceed(aID);
                        break;
                    }
                    case 4: {
                        Introspector.this.stepByStepAgents.remove(aID);
                        Introspector.this.slowAgents.remove(aID);
                        Introspector.this.proceed(aID);
                    }
                }
            }
        });
        this.allAgents = new HashSet();
        this.preload = new Hashtable();
        Object[] objectArray = this.getArguments();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.parsePreloadDescription((String)objectArray[n]);
                ++n;
            }
        }
        this.myGUI = new IntrospectorGUI(this);
        this.myGUI.setVisible(true);
    }

    public boolean addAgent(AID aID) {
        if (!this.windowMap.containsKey(aID)) {
            MainWindow mainWindow = new MainWindow(this.guiSensor, aID);
            this.myGUI.addWindow(mainWindow);
            this.windowMap.put(aID, mainWindow);
            this.requestDebugOn(aID);
            return true;
        }
        return false;
    }

    private void requestDebugOn(AID aID) {
        try {
            ACLMessage aCLMessage = this.getRequest();
            DebugOn debugOn = new DebugOn();
            debugOn.setDebugger(this.getAID());
            debugOn.addDebuggedAgents(aID);
            Action action = new Action();
            action.setActor(this.getAMS());
            action.setAction((Concept)debugOn);
            this.getContentManager().fillContent(aCLMessage, (ContentElement)action);
            this.addBehaviour((Behaviour)new AMSRequester("DebugOn", aCLMessage));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeAgent(AID aID) {
        block2: {
            if (!this.windowMap.containsKey(aID)) break block2;
            try {
                MainWindow mainWindow = (MainWindow)this.windowMap.get(aID);
                this.myGUI.closeInternal(mainWindow);
                this.windowMap.remove(aID);
                this.stepByStepAgents.remove(aID);
                this.slowAgents.remove(aID);
                this.proceed(aID);
                ACLMessage aCLMessage = this.getRequest();
                DebugOff debugOff = new DebugOff();
                debugOff.setDebugger(this.getAID());
                debugOff.addDebuggedAgents(aID);
                Action action = new Action();
                action.setActor(this.getAMS());
                action.setAction((Concept)debugOff);
                this.getContentManager().fillContent(aCLMessage, (ContentElement)action);
                this.addBehaviour((Behaviour)new AMSRequester("DebugOff", aCLMessage));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void toolTakeDown() {
        block4: {
            if (!this.windowMap.isEmpty()) {
                Action action;
                ACLMessage aCLMessage = this.getRequest();
                DebugOff debugOff = new DebugOff();
                debugOff.setDebugger(this.getAID());
                Iterator iterator = this.windowMap.keySet().iterator();
                while (iterator.hasNext()) {
                    action = (AID)iterator.next();
                    debugOff.addDebuggedAgents((AID)action);
                }
                action = new Action();
                action.setActor(this.getAMS());
                action.setAction((Concept)debugOff);
                try {
                    this.getContentManager().fillContent(aCLMessage, (ContentElement)action);
                    FIPAService.doFipaRequestClient((Agent)this, (ACLMessage)aCLMessage);
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Logger.WARNING)) break block4;
                    logger.log(Logger.WARNING, exception.getMessage());
                }
            }
        }
        this.send(this.getCancel());
        this.myGUI.disposeAsync();
    }

    public AgentTreeModel getModel() {
        return this.myGUI.getModel();
    }

    private void proceed(AID aID) {
        String string = (String)this.pendingReplies.remove(aID);
        AID aID2 = (AID)this.notifiers.get(aID);
        if (string != null && aID2 != null) {
            ACLMessage aCLMessage = new ACLMessage(7);
            aCLMessage.addReceiver(aID2);
            aCLMessage.setInReplyTo(string);
            this.send(aCLMessage);
        }
    }

    public void doDelete() {
        AID aID = this.getAMS();
        if (this.windowMap.containsKey(aID)) {
            try {
                MainWindow mainWindow = (MainWindow)this.windowMap.get(aID);
                this.myGUI.closeInternal(mainWindow);
                this.windowMap.remove(aID);
                this.stepByStepAgents.remove(aID);
                this.slowAgents.remove(aID);
                this.proceed(aID);
                ACLMessage aCLMessage = this.getRequest();
                DebugOff debugOff = new DebugOff();
                debugOff.setDebugger(this.getAID());
                debugOff.addDebuggedAgents(aID);
                Action action = new Action();
                action.setActor(this.getAMS());
                action.setAction((Concept)debugOff);
                this.getContentManager().fillContent(aCLMessage, (ContentElement)action);
                this.addBehaviour((Behaviour)new AMSRequester("DebugOff", aCLMessage){

                    public int onEnd() {
                        this.myAgent.doDelete();
                        return 0;
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            super.doDelete();
        }
    }

    protected String preloadContains(String string) {
        Enumeration enumeration = this.preload.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.isMatch(string2, string)) continue;
            return string2;
        }
        return null;
    }

    protected boolean isMatch(String string, String string2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '*') {
                return true;
            }
            if (n2 == string2.length()) {
                return false;
            }
            if (c != '?' && c != string2.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return n == string2.length();
    }

    private void parsePreloadDescription(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        if (!string2.endsWith("*") && (n = string2.lastIndexOf(64)) == -1) {
            string2 = string2 + "@" + this.getHap();
        }
        n = ACLMessage.getAllPerformativeNames().length;
        boolean[] blArray = new boolean[n];
        boolean bl = !stringTokenizer.hasMoreTokens();
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = bl;
            ++n2;
        }
        while (stringTokenizer.hasMoreTokens()) {
            int n3 = ACLMessage.getInteger((String)stringTokenizer.nextToken());
            if (n3 == -1) continue;
            blArray[n3] = true;
        }
        this.preload.put(string2, blArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$402(Introspector introspector, String string) {
        introspector.myContainerName = string;
        return introspector.myContainerName;
    }

    static /* synthetic */ Map access$500(Introspector introspector) {
        return introspector.windowMap;
    }

    static /* synthetic */ void access$600(Introspector introspector, AID aID) {
        introspector.requestDebugOn(aID);
    }

    private class RequestListenerBehaviour
    extends SimpleAchieveREResponder {
        private Action requestAction;
        private AgentAction aa;

        RequestListenerBehaviour() {
            super((Agent)Introspector.this, MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.MatchOntology((String)"JADE-Agent-Management")));
        }

        protected ACLMessage prepareResponse(ACLMessage aCLMessage) {
            ACLMessage aCLMessage2;
            block5: {
                aCLMessage2 = aCLMessage.createReply();
                try {
                    this.requestAction = (Action)Introspector.this.getContentManager().extractContent(aCLMessage);
                    this.aa = (AgentAction)this.requestAction.getAction();
                    if (this.aa instanceof DebugOn || this.aa instanceof DebugOff) {
                        if (Introspector.this.getAID().equals((Object)this.requestAction.getActor())) {
                            aCLMessage2.setPerformative(1);
                            aCLMessage2.setContent(aCLMessage.getContent());
                        } else {
                            aCLMessage2.setPerformative(14);
                            aCLMessage2.setContent("((unrecognised-parameter-value actor " + this.requestAction.getActor() + "))");
                        }
                        break block5;
                    }
                    aCLMessage2.setPerformative(14);
                    aCLMessage2.setContent("((unsupported-act " + this.aa.getClass().getName() + "))");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    aCLMessage2.setPerformative(10);
                }
            }
            return aCLMessage2;
        }

        protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) {
            int n;
            ArrayList arrayList;
            DebugOn debugOn;
            if (this.aa instanceof DebugOn) {
                debugOn = (DebugOn)this.aa;
                arrayList = debugOn.getCloneOfDebuggedAgents();
                n = 0;
                while (n < arrayList.size()) {
                    AID aID = (AID)arrayList.get(n);
                    if (Introspector.this.allAgents.contains(aID)) {
                        Introspector.this.addAgent(aID);
                    } else {
                        int n2 = ACLMessage.getAllPerformativeNames().length;
                        boolean[] blArray = new boolean[n2];
                        int n3 = 0;
                        while (n3 < n2) {
                            blArray[n3] = true;
                            ++n3;
                        }
                        Introspector.this.preload.put(aID.getName(), blArray);
                    }
                    ++n;
                }
            } else {
                debugOn = (DebugOff)this.aa;
                arrayList = debugOn.getCloneOfDebuggedAgents();
                n = 0;
                while (n < arrayList.size()) {
                    AID aID = (AID)arrayList.get(n);
                    Introspector.this.removeAgent(aID);
                    ++n;
                }
            }
            debugOn = aCLMessage.createReply();
            debugOn.setPerformative(7);
            arrayList = new Done((Concept)this.requestAction);
            try {
                this.myAgent.getContentManager().fillContent((ACLMessage)debugOn, (ContentElement)arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return debugOn;
        }
    }

    private class ControlListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate template;

        ControlListenerBehaviour(Agent agent) {
            super(agent);
            this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)"JADE-Introspection"), (MessageTemplate)MessageTemplate.MatchConversationId((String)(Introspector.this.getName() + "-control")));
        }

        public void action() {
            ACLMessage aCLMessage = Introspector.this.receive(this.template);
            if (aCLMessage != null) {
                try {
                    Done done = (Done)Introspector.this.getContentManager().extractContent(aCLMessage);
                    Action action = (Action)done.getAction();
                    AID aID = action.getActor();
                    StartNotify startNotify = (StartNotify)action.getAction();
                    AID aID2 = startNotify.getObserved();
                    Introspector.this.notifiers.put(aID2, aID);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }

    private class IntrospectionListenerBehaviour
    extends CyclicBehaviour {
        private MessageTemplate template;
        private Map handlers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        IntrospectionListenerBehaviour() {
            this.template = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)"JADE-Introspection"), (MessageTemplate)MessageTemplate.MatchConversationId((String)(Introspector.this.getName() + "-event")));
            this.handlers.put("changed-agent-state", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                }
            });
            this.handlers.put("added-behaviour", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    AddedBehaviour addedBehaviour = (AddedBehaviour)event;
                    AID aID = addedBehaviour.getAgent();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).behaviourAdded(mainWindow, addedBehaviour);
                    }
                }
            });
            this.handlers.put("removed-behaviour", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    RemovedBehaviour removedBehaviour = (RemovedBehaviour)event;
                    AID aID = removedBehaviour.getAgent();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).behaviourRemoved(mainWindow, removedBehaviour);
                    }
                }
            });
            this.handlers.put("changed-behaviour-state", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    ChangedBehaviourState changedBehaviourState = (ChangedBehaviourState)event;
                    AID aID = changedBehaviourState.getAgent();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).behaviourChangeState(mainWindow, changedBehaviourState);
                    }
                    if (Introspector.access$800(IntrospectionListenerBehaviour.access$1000(this.this$1)).contains(aID)) {
                        return;
                    }
                    if (Introspector.access$900(IntrospectionListenerBehaviour.access$1000(this.this$1)).contains(aID)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Introspector.access$700(IntrospectionListenerBehaviour.access$1000(this.this$1), aID);
                }
            });
            this.handlers.put("sent-message", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    SentMessage sentMessage = (SentMessage)event;
                    AID aID = sentMessage.getSender();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).messageSent(mainWindow, sentMessage);
                    }
                }
            });
            this.handlers.put("received-message", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    ReceivedMessage receivedMessage = (ReceivedMessage)event;
                    AID aID = receivedMessage.getReceiver();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).messageReceived(mainWindow, receivedMessage);
                    }
                }
            });
            this.handlers.put("posted-message", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    PostedMessage postedMessage = (PostedMessage)event;
                    AID aID = postedMessage.getReceiver();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).messagePosted(mainWindow, postedMessage);
                    }
                }
            });
            this.handlers.put("changed-agent-state", new ToolAgent.EventHandler(this){
                private final /* synthetic */ IntrospectionListenerBehaviour this$1;
                {
                    this.this$1 = introspectionListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    ChangedAgentState changedAgentState = (ChangedAgentState)event;
                    AID aID = changedAgentState.getAgent();
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectionListenerBehaviour.access$1000(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectionListenerBehaviour.access$1000(this.this$1)).changedAgentState(mainWindow, changedAgentState);
                    }
                }
            });
        }

        public void action() {
            ACLMessage aCLMessage = Introspector.this.receive(this.template);
            if (aCLMessage != null) {
                AID aID = aCLMessage.getSender();
                try {
                    ToolAgent.EventHandler eventHandler;
                    Object object;
                    Occurred occurred = (Occurred)Introspector.this.getContentManager().extractContent(aCLMessage);
                    EventRecord eventRecord = occurred.getWhat();
                    jade.domain.introspection.Event event = eventRecord.getWhat();
                    if (logger.isLoggable(Logger.FINEST)) {
                        logger.log(Logger.FINEST, "Received event " + event);
                    }
                    if (aCLMessage.getReplyWith() != null) {
                        object = (ChangedBehaviourState)event;
                        Introspector.this.pendingReplies.put(object.getAgent(), aCLMessage.getReplyWith());
                    }
                    if ((eventHandler = (ToolAgent.EventHandler)this.handlers.get(object = event.getName())) != null) {
                        eventHandler.handle(event);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.block();
            }
        }

        static /* synthetic */ Introspector access$1000(IntrospectionListenerBehaviour introspectionListenerBehaviour) {
            return introspectionListenerBehaviour.Introspector.this;
        }
    }

    class IntrospectorAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        IntrospectorAMSListenerBehaviour() {
            super((ToolAgent)Introspector.this);
        }

        protected void installHandlers(Map map) {
            map.put("meta_reset-events", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    ResetEvents resetEvents = (ResetEvents)event;
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).resetTree();
                }
            });
            map.put("added-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    AddedContainer addedContainer = (AddedContainer)event;
                    ContainerID containerID = addedContainer.getContainer();
                    String string = containerID.getName();
                    String string2 = containerID.getAddress();
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string2);
                        Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).addContainer(string, inetAddress);
                    }
                    catch (UnknownHostException unknownHostException) {
                        Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).addContainer(string, null);
                    }
                }
            });
            map.put("removed-container", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    RemovedContainer removedContainer = (RemovedContainer)event;
                    ContainerID containerID = removedContainer.getContainer();
                    String string = containerID.getName();
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).removeContainer(string);
                }
            });
            map.put("born-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    BornAgent bornAgent = (BornAgent)event;
                    ContainerID containerID = bornAgent.getWhere();
                    String string = containerID.getName();
                    AID aID = bornAgent.getAgent();
                    Introspector.access$300(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).add(aID);
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).addAgent(string, aID);
                    if (IntrospectorAMSListenerBehaviour.access$200(this.this$1).preloadContains(aID.getName()) != null) {
                        IntrospectorAMSListenerBehaviour.access$200(this.this$1).addAgent(aID);
                    }
                    if (aID.equals((Object)IntrospectorAMSListenerBehaviour.access$200(this.this$1).getAID())) {
                        Introspector.access$402(IntrospectorAMSListenerBehaviour.access$200(this.this$1), string);
                    }
                }
            });
            map.put("dead-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    DeadAgent deadAgent = (DeadAgent)event;
                    ContainerID containerID = deadAgent.getWhere();
                    String string = containerID.getName();
                    AID aID = deadAgent.getAgent();
                    Introspector.access$300(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).remove(aID);
                    MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).get(aID);
                    if (mainWindow != null) {
                        Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).closeInternal(mainWindow);
                        Introspector.access$500(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).remove(aID);
                    }
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).removeAgent(string, aID);
                }
            });
            map.put("moved-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ IntrospectorAMSListenerBehaviour this$1;
                {
                    this.this$1 = introspectorAMSListenerBehaviour;
                }

                public void handle(jade.domain.introspection.Event event) {
                    MovedAgent movedAgent = (MovedAgent)event;
                    AID aID = movedAgent.getAgent();
                    ContainerID containerID = movedAgent.getFrom();
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).removeAgent(containerID.getName(), aID);
                    ContainerID containerID2 = movedAgent.getTo();
                    Introspector.access$000(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).addAgent(containerID2.getName(), aID);
                    if (Introspector.access$500(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).containsKey(aID)) {
                        MainWindow mainWindow = (MainWindow)Introspector.access$500(IntrospectorAMSListenerBehaviour.access$200(this.this$1)).get(aID);
                        Introspector.access$600(IntrospectorAMSListenerBehaviour.access$200(this.this$1), aID);
                    }
                }
            });
        }

        static /* synthetic */ Introspector access$200(IntrospectorAMSListenerBehaviour introspectorAMSListenerBehaviour) {
            return introspectorAMSListenerBehaviour.Introspector.this;
        }
    }

    private class AMSRequester
    extends SimpleAchieveREInitiator {
        private String actionName;

        public AMSRequester(String string, ACLMessage aCLMessage) {
            super((Agent)Introspector.this, aCLMessage);
            this.actionName = string;
        }

        protected void handleNotUnderstood(ACLMessage aCLMessage) {
            Introspector.this.myGUI.showError("NOT-UNDERSTOOD received during " + this.actionName);
        }

        protected void handleRefuse(ACLMessage aCLMessage) {
            Introspector.this.myGUI.showError("REFUSE received during " + this.actionName);
        }

        protected void handleAgree(ACLMessage aCLMessage) {
            if (logger.isLoggable(Logger.FINEST)) {
                logger.log(Logger.FINEST, "AGREE received");
            }
        }

        protected void handleFailure(ACLMessage aCLMessage) {
            Introspector.this.myGUI.showError("FAILURE received during " + this.actionName);
        }

        protected void handleInform(ACLMessage aCLMessage) {
            if (logger.isLoggable(Logger.FINEST)) {
                logger.log(Logger.FINEST, "INFORM received");
            }
        }
    }
}

