/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AID;
import jade.tools.introspector.Sensor;
import jade.tools.introspector.gui.BehaviourPanel;
import jade.tools.introspector.gui.MainBar;
import jade.tools.introspector.gui.MainBarListener;
import jade.tools.introspector.gui.MessagePanel;
import jade.tools.introspector.gui.MessageTableModel;
import jade.tools.introspector.gui.StatePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class MainWindow
extends JInternalFrame
implements InternalFrameListener {
    private Sensor debuggerSensor;
    private AID debuggedID;
    private JSplitPane splitPanel;
    private MainBar mainBar;
    private MessagePanel messagePanel;
    private StatePanel statePanel;
    private BehaviourPanel behaviourPanel;
    private MainBarListener list;
    private int lastDividerLocation;

    public MainWindow(Sensor sensor, AID aID) {
        super(aID.getName());
        this.debuggerSensor = sensor;
        this.debuggedID = aID;
        MessageTableModel messageTableModel = new MessageTableModel(new Vector(), "Incoming Messages -- Pending");
        MessageTableModel messageTableModel2 = new MessageTableModel(new Vector(), "Incoming Messages --  Received");
        MessageTableModel messageTableModel3 = new MessageTableModel(new Vector(), "Outgoing Messages -- Pending");
        MessageTableModel messageTableModel4 = new MessageTableModel(new Vector(), "Outgoing Messages -- Sent");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Behaviours"));
        boolean bl = true;
        this.list = new MainBarListener(this, this.debuggerSensor);
        this.mainBar = new MainBar(this.list);
        this.messagePanel = new MessagePanel(messageTableModel, messageTableModel2, messageTableModel3, messageTableModel4);
        this.statePanel = new StatePanel(this.list);
        this.behaviourPanel = new BehaviourPanel(defaultTreeModel);
        this.splitPanel = new JSplitPane();
        this.build();
    }

    public AID getDebugged() {
        return this.debuggedID;
    }

    public void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitPanel, "Center");
        this.getContentPane().add((Component)this.statePanel, "West");
        this.splitPanel.setOrientation(0);
        this.splitPanel.setContinuousLayout(true);
        this.setBehaviourPanelVisible(true);
        this.setMessagePanelVisible(true);
        this.setClosable(false);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setJMenuBar(this.mainBar);
    }

    public void adjustDividerLocation() {
        this.splitPanel.setDividerLocation(this.getHeight() / 2);
        this.lastDividerLocation = this.splitPanel.getDividerLocation();
    }

    public void setMessagePanelVisible(boolean bl) {
        if (!bl) {
            this.lastDividerLocation = this.splitPanel.getDividerLocation();
            this.splitPanel.remove(this.messagePanel);
        } else {
            this.splitPanel.add((Component)this.messagePanel, "top");
            this.splitPanel.setDividerLocation(this.lastDividerLocation);
        }
    }

    public void setBehaviourPanelVisible(boolean bl) {
        if (!bl) {
            this.lastDividerLocation = this.splitPanel.getDividerLocation();
            this.splitPanel.remove(this.behaviourPanel);
        } else {
            this.splitPanel.add((Component)this.behaviourPanel, "bottom");
            this.splitPanel.setDividerLocation(this.lastDividerLocation);
        }
    }

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    public BehaviourPanel getBehaviourPanel() {
        return this.behaviourPanel;
    }

    public StatePanel getStatePanel() {
        return this.statePanel;
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.moveToFront();
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }
}

