/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.BehaviourID;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.RemovedBehaviour;
import jade.tools.introspector.gui.BehaviourPanel;
import jade.tools.introspector.gui.BehaviourTreeNode;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUpdater
implements Runnable {
    private BehaviourID behaviour;
    private BehaviourPanel gui;
    private int action;
    private String state;
    private static final int ADD_NODE = 0;
    private static final int REMOVE_NODE = 1;
    private static final int CHANGE_NODE = 2;

    public TreeUpdater(AddedBehaviour addedBehaviour, BehaviourPanel behaviourPanel) {
        this.behaviour = addedBehaviour.getBehaviour();
        this.gui = behaviourPanel;
        this.action = 0;
        this.state = "READY";
    }

    public TreeUpdater(RemovedBehaviour removedBehaviour, BehaviourPanel behaviourPanel) {
        this.behaviour = removedBehaviour.getBehaviour();
        this.gui = behaviourPanel;
        this.action = 1;
        this.state = "READY";
    }

    public TreeUpdater(ChangedBehaviourState changedBehaviourState, BehaviourPanel behaviourPanel) {
        this.behaviour = changedBehaviourState.getBehaviour();
        this.gui = behaviourPanel;
        this.action = 2;
        this.state = changedBehaviourState.getTo();
    }

    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode, Iterator iterator) {
        while (iterator.hasNext()) {
            BehaviourID behaviourID = (BehaviourID)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new BehaviourTreeNode(behaviourID, this.state));
            if (!behaviourID.isSimple()) {
                this.createTree(defaultMutableTreeNode2, (Iterator)behaviourID.getAllChildren());
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public void run() {
        Object object;
        Object object2;
        JTree jTree = this.gui.getBehaviourTree();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        if (this.action == 2) {
            boolean bl = false;
            jTree.clearSelection();
            object2 = defaultMutableTreeNode.breadthFirstEnumeration();
            if (object2.hasMoreElements()) {
                object2.nextElement();
            }
            while (object2.hasMoreElements()) {
                object = (DefaultMutableTreeNode)object2.nextElement();
                BehaviourTreeNode behaviourTreeNode = (BehaviourTreeNode)((DefaultMutableTreeNode)object).getUserObject();
                BehaviourID behaviourID = behaviourTreeNode.getBehaviour();
                if (!behaviourID.equals((Object)this.behaviour)) continue;
                Object[] objectArray = ((DefaultMutableTreeNode)object).getPath();
                TreePath treePath = new TreePath(objectArray);
                jTree.setSelectionPath(treePath);
                TreeUpdater.description(this.gui.getBehaviourText(), behaviourID);
                if (!this.state.equals(behaviourTreeNode.getState())) {
                    behaviourTreeNode.setState(this.state);
                    defaultTreeModel.nodeChanged((TreeNode)object);
                }
                bl = true;
                break;
            }
        }
        if (this.action == 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new BehaviourTreeNode(this.behaviour, this.state));
            if (!this.behaviour.isSimple()) {
                this.createTree(defaultMutableTreeNode2, (Iterator)this.behaviour.getAllChildren());
            }
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultTreeModel.getChildCount(defaultMutableTreeNode));
        }
        if (this.action == 1) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                object = (BehaviourTreeNode)((DefaultMutableTreeNode)object2).getUserObject();
                if (!((BehaviourTreeNode)object).getBehaviour().equals((Object)this.behaviour)) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)object2);
                break;
            }
        }
    }

    public static void description(JTextArea jTextArea, BehaviourID behaviourID) {
        jTextArea.setText("Name:\t" + behaviourID.getName() + "\nClass:\t" + behaviourID.getClassName() + "\nKind:\t" + behaviourID.getKind());
    }
}

