/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.tools.rma.rma;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageMTPsDialog
extends JDialog {
    private static final Object[] EMPTY_LIST = new Object[0];
    private AbstractAction addMTPAction = new AbstractAction("Add MTP..."){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ManageMTPsDialog.this.containers.getSelectedValue();
            ManageMTPsDialog.this.myRMA.installMTP(string);
        }
    };
    private AbstractAction removeMTPAction = new AbstractAction("Remove MTP"){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(ManageMTPsDialog.this, "Are you sure you want to remove the selected MTP?", "Removing MTP", 0, 3);
            if (n == 0) {
                String string = (String)ManageMTPsDialog.this.containers.getSelectedValue();
                String string2 = (String)ManageMTPsDialog.this.addresses.getSelectedValue();
                ManageMTPsDialog.this.myRMA.uninstallMTP(string, string2);
            }
        }
    };
    private rma myRMA;
    private Frame owner;
    private Map data;
    private JPanel lists;
    private JList containers;
    private JList addresses;
    private JPanel buttons;
    private JButton addMTP;
    private JButton removeMTP;
    private JButton closeDlg;

    public ManageMTPsDialog(rma rma2, Frame frame, boolean bl, Map map) {
        super(frame, "Platform MTPs Management", bl);
        this.myRMA = rma2;
        this.owner = frame;
        this.data = map;
        this.initComponents();
    }

    public void showCentered() {
        this.setLocation(this.owner.getX() + (this.owner.getWidth() - this.getWidth()) / 2, this.owner.getY() + (this.owner.getHeight() - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void setData(List list, Map map) {
        this.data = map;
        Object[] objectArray = list.toArray();
        this.containers.setListData(objectArray);
        this.addresses.setListData(EMPTY_LIST);
        this.addMTP.setEnabled(false);
        this.removeMTP.setEnabled(false);
    }

    private void initComponents() {
        this.lists = new JPanel();
        this.containers = new JList<Object>(EMPTY_LIST);
        this.addresses = new JList<Object>(EMPTY_LIST);
        this.buttons = new JPanel();
        this.addMTP = new JButton();
        this.addMTP.setText((String)this.addMTPAction.getValue("Name"));
        this.addMTP.setIcon((Icon)this.addMTPAction.getValue("SmallIcon"));
        this.addMTP.setToolTipText((String)this.addMTPAction.getValue("ShortDescription"));
        this.addMTP.addActionListener(this.addMTPAction);
        this.removeMTP = new JButton();
        this.removeMTP.setText((String)this.removeMTPAction.getValue("Name"));
        this.removeMTP.setIcon((Icon)this.removeMTPAction.getValue("SmallIcon"));
        this.removeMTP.setToolTipText((String)this.removeMTPAction.getValue("ShortDescription"));
        this.removeMTP.addActionListener(this.removeMTPAction);
        this.closeDlg = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManageMTPsDialog.this.closeDialog(windowEvent);
            }
        });
        this.lists.setLayout(new GridLayout(1, 2));
        this.lists.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 5, 5, 5)), new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(5, 5, 5, 5)))));
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), " Containers "));
        jPanel.add(new JScrollPane(this.containers));
        this.lists.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), " Addresses "));
        jPanel2.add(new JScrollPane(this.addresses));
        this.lists.add(jPanel2);
        this.getContentPane().add(this.lists);
        this.buttons.setLayout(new BoxLayout(this.buttons, 0));
        this.buttons.add(Box.createHorizontalGlue());
        this.buttons.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.addMTP.setToolTipText("Install a new MTP on the selected container");
        this.buttons.add(this.addMTP);
        this.removeMTP.setToolTipText("Uninstall the selected MTP");
        this.buttons.add(this.removeMTP);
        this.buttons.add(Box.createHorizontalStrut(10));
        this.closeDlg.setToolTipText("Close the MTP management dialog");
        this.closeDlg.setText("Close");
        this.buttons.add(this.closeDlg);
        this.buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)this.buttons, "South");
        this.pack();
        this.containers.setSelectionMode(0);
        this.containers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object e = ManageMTPsDialog.this.containers.getSelectedValue();
                    ManageMTPsDialog.this.addMTP.setEnabled(e != null);
                    ManageMTPsDialog.this.removeMTP.setEnabled(false);
                    if (e == null) {
                        ManageMTPsDialog.this.addresses.setListData(EMPTY_LIST);
                        return;
                    }
                    List list = (List)ManageMTPsDialog.this.data.get(e);
                    if (list != null) {
                        ManageMTPsDialog.this.addresses.setListData(list.toArray());
                    } else {
                        ManageMTPsDialog.this.addresses.setListData(EMPTY_LIST);
                    }
                }
            }
        });
        this.addresses.setSelectionMode(0);
        this.addresses.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Object e = ManageMTPsDialog.this.containers.getSelectedValue();
                    ManageMTPsDialog.this.removeMTP.setEnabled(e != null);
                }
            }
        });
        this.closeDlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageMTPsDialog.this.setVisible(false);
                ManageMTPsDialog.this.dispose();
            }
        });
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

