/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.Boot;
import jade.BootException;
import jade.PropertyType;
import jade.gui.TreeHelp;
import jade.util.BasicProperties;
import jade.util.ExpandedProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class BootGUI
extends JDialog {
    static String EXTENSION = "conf";
    static String TITLE = "--JADE Properties--";
    Vector propertiesVector = null;
    File currentDir = null;
    JTextField statusField = new JTextField();
    JPanel topPanel = new JPanel();
    JPanel propertyPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    String propertyFileName = null;
    BasicProperties outProp = null;
    BootGUI thisBootGui = this;
    Boot booter;

    public BootGUI(Boot boot) {
        JComponent jComponent;
        Object object;
        JPanel jPanel;
        this.booter = boot;
        this.propertiesVector = this.createPropertyVector(this.booter.getProperties());
        this.setTitle("JADE Configurator");
        Border border = BorderFactory.createRaisedBevelBorder();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(border);
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.propertyPanel.setLayout(new BoxLayout(this.propertyPanel, 1));
        Enumeration enumeration = this.propertiesVector.elements();
        while (enumeration.hasMoreElements()) {
            jPanel = new singlePanel();
            object = (PropertyType)enumeration.nextElement();
            jComponent = ((singlePanel)jPanel).newSinglePanel((PropertyType)object);
            this.propertyPanel.add(jComponent);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.statusField.setEditable(false);
        this.statusField.setFont(new Font("Monospaced", 0, 12));
        this.statusField.setPreferredSize(new Dimension(600, 50));
        this.statusField.setMinimumSize(new Dimension(50, 50));
        jPanel.add((Component)this.statusField, "Center");
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        object = new JButton("Open File");
        ((JComponent)object).setToolTipText("Read configuration from file");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    int n;
                    String string = actionEvent.getActionCommand();
                    if (!string.equals("Open File")) break block5;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new myFileFilter());
                    if (BootGUI.this.currentDir != null) {
                        jFileChooser.setCurrentDirectory(BootGUI.this.currentDir);
                    }
                    if ((n = jFileChooser.showOpenDialog(null)) == 0) {
                        BootGUI.this.currentDir = jFileChooser.getCurrentDirectory();
                        String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                        try {
                            BootGUI.this.loadPropertiesFromFile(string2);
                            BootGUI.this.propertyFileName = string2;
                            BootGUI.this.updateProperties();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.out.println("File not found Exception");
                        }
                        catch (IOException iOException) {
                            System.out.println("IO Exception");
                        }
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.buttonPanel.add((Component)object);
        jComponent = new JButton("Save File");
        jComponent.setToolTipText("Save configuration into a file");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block7: {
                    String string = actionEvent.getActionCommand();
                    if (!string.equals("Save File")) break block7;
                    BasicProperties basicProperties = BootGUI.this.extractPropertiesFromGui();
                    try {
                        int n;
                        BootGUI.this.booter.setProperties(basicProperties);
                        basicProperties = BootGUI.this.booter.getProperties();
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setFileFilter(new myFileFilter());
                        if (BootGUI.this.currentDir != null) {
                            jFileChooser.setCurrentDirectory(BootGUI.this.currentDir);
                        }
                        if ((n = jFileChooser.showSaveDialog(null)) != 0) break block7;
                        BootGUI.this.currentDir = jFileChooser.getCurrentDirectory();
                        String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                        boolean bl = BootGUI.this.hasExtension(string2);
                        if (!bl) {
                            string2 = string2.concat(".conf");
                        }
                        BootGUI.this.propertyFileName = string2;
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(string2);
                            basicProperties.put("conf", (Object)"false");
                            basicProperties.store(fileOutputStream, TITLE);
                            fileOutputStream.close();
                            BootGUI.this.outProp = basicProperties;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.out.println("File not found Exception");
                        }
                        catch (IOException iOException) {
                            System.out.println("IO exception");
                        }
                    }
                    catch (BootException bootException) {
                        BootGUI.this.statusField.setText(bootException.getMessage());
                    }
                }
            }
        });
        this.buttonPanel.add(jComponent);
        JButton jButton = new JButton("Run");
        jButton.setToolTipText("Launch the system");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block14: {
                    String string = actionEvent.getActionCommand();
                    if (!string.equals("Run")) break block14;
                    BasicProperties basicProperties = BootGUI.this.extractPropertiesFromGui();
                    try {
                        BootGUI.this.booter.setProperties(basicProperties);
                        basicProperties = BootGUI.this.booter.getProperties();
                        boolean bl = false;
                        if (BootGUI.this.propertyFileName != null) {
                            BasicProperties basicProperties2 = BootGUI.this.readPropertiesFromFile(BootGUI.this.propertyFileName);
                            bl = BootGUI.this.compareProperties(basicProperties, basicProperties2);
                        }
                        if (bl || BootGUI.this.propertyFileName == null) {
                            int n = JOptionPane.showConfirmDialog(BootGUI.this.topPanel, "Save this configuration?", "JADE Configurator", 1);
                            if (n == 2) {
                                return;
                            }
                            if (n == 0) {
                                int n2;
                                JFileChooser jFileChooser = new JFileChooser();
                                jFileChooser.setFileFilter(new myFileFilter());
                                if (BootGUI.this.currentDir != null) {
                                    jFileChooser.setCurrentDirectory(BootGUI.this.currentDir);
                                }
                                if ((n2 = jFileChooser.showSaveDialog(null)) == 0) {
                                    BootGUI.this.currentDir = jFileChooser.getCurrentDirectory();
                                    String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                                    boolean bl2 = BootGUI.this.hasExtension(string2);
                                    if (!bl2) {
                                        string2 = string2.concat(".conf");
                                    }
                                    try {
                                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                                        basicProperties.store(fileOutputStream, TITLE);
                                        fileOutputStream.close();
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        System.out.println("File not found exception");
                                    }
                                    catch (IOException iOException) {
                                        System.out.println("IO exception");
                                    }
                                }
                            }
                        }
                        BootGUI.this.outProp = basicProperties;
                        BootGUI.this.dispose();
                    }
                    catch (BootException bootException) {
                        BootGUI.this.statusField.setText(bootException.getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("File not found");
                    }
                    catch (IOException iOException) {
                        System.out.println("Io Exception");
                    }
                }
            }
        });
        this.buttonPanel.add(jButton);
        JButton jButton2 = new JButton("Exit");
        jButton2.setToolTipText("Exit without executing");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Exit")) {
                    System.exit(0);
                }
            }
        });
        this.buttonPanel.add(jButton2);
        JButton jButton3 = new JButton("Help");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Help")) {
                    TreeHelp treeHelp = new TreeHelp((Dialog)BootGUI.this.thisBootGui, "Boot Help", "help/BOOTGUI.html");
                    treeHelp.setVisible(true);
                    treeHelp.requestFocus();
                }
            }
        });
        this.buttonPanel.add(jButton3);
        this.topPanel.add(this.buttonPanel);
        this.topPanel.add(this.propertyPanel);
        jPanel2.add(this.topPanel);
        jPanel2.add(jPanel);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.setResizable(false);
        this.setModal(true);
        this.ShowCorrect();
    }

    BasicProperties extractPropertiesFromGui() {
        BasicProperties basicProperties = new BasicProperties();
        int n = this.propertyPanel.getComponentCount();
        Enumeration enumeration = this.propertiesVector.elements();
        while (enumeration.hasMoreElements()) {
            PropertyType propertyType = (PropertyType)enumeration.nextElement();
            String string = propertyType.getName();
            String string2 = propertyType.getType();
            String string3 = propertyType.getDefaultValue();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n && !bl) {
                JPanel jPanel = (JPanel)this.propertyPanel.getComponent(n2);
                JLabel jLabel = (JLabel)jPanel.getComponent(0);
                if (string.equalsIgnoreCase(jLabel.getText())) {
                    JComponent jComponent;
                    bl = true;
                    if (string2.equalsIgnoreCase(PropertyType.COMBO_TYPE)) {
                        jComponent = (JComboBox)jPanel.getComponent(1);
                        basicProperties.setProperty(string.toLowerCase(), ((JComboBox)jComponent).getSelectedItem().toString());
                    }
                    if (string2.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                        jComponent = (JCheckBox)jPanel.getComponent(1);
                        basicProperties.setProperty(string.toLowerCase(), new Boolean(((AbstractButton)jComponent).isSelected()).toString());
                    } else {
                        jComponent = (JTextField)jPanel.getComponent(1);
                        String string4 = ((JTextComponent)jComponent).getText();
                        if (string4.length() == 0) {
                            string4 = string3;
                        }
                        basicProperties.setProperty(string.toLowerCase(), string4);
                    }
                }
                ++n2;
            }
        }
        return basicProperties;
    }

    boolean compareProperties(BasicProperties basicProperties, BasicProperties basicProperties2) {
        Enumeration<Object> enumeration = basicProperties.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            String string = (String)enumeration.nextElement();
            String string2 = basicProperties.getProperty(string);
            String string3 = basicProperties2.getProperty(string);
            if (string2 == null) {
                bl = string3 != null;
                continue;
            }
            boolean bl2 = bl = !string2.equalsIgnoreCase(string3);
        }
        return bl;
    }

    void updateProperties() {
        int n = this.propertyPanel.getComponentCount();
        Enumeration enumeration = this.propertiesVector.elements();
        while (enumeration.hasMoreElements()) {
            PropertyType propertyType = (PropertyType)enumeration.nextElement();
            String string = propertyType.getName();
            String string2 = propertyType.getType();
            String string3 = propertyType.getDefaultValue();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n && !bl) {
                JPanel jPanel = (JPanel)this.propertyPanel.getComponent(n2);
                JLabel jLabel = (JLabel)jPanel.getComponent(0);
                if (string.equalsIgnoreCase(jLabel.getText())) {
                    JComponent jComponent;
                    bl = true;
                    if (string2.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                        jComponent = (JCheckBox)jPanel.getComponent(1);
                        ((AbstractButton)jComponent).setSelected(string3.equalsIgnoreCase("true"));
                    } else {
                        jComponent = (JTextField)jPanel.getComponent(1);
                        ((JTextComponent)jComponent).setText(string3);
                    }
                }
                ++n2;
            }
        }
    }

    void ShowCorrect() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setBounds(n, n2, dimension2.width, dimension2.height);
        this.setResizable(true);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    void loadPropertiesFromFile(String string) throws FileNotFoundException, IOException {
        BasicProperties basicProperties = this.readPropertiesFromFile(string);
        Enumeration<Object> enumeration = basicProperties.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            String string2 = (String)enumeration.nextElement();
            Enumeration enumeration2 = this.propertiesVector.elements();
            while (enumeration2.hasMoreElements() && !bl) {
                PropertyType propertyType = (PropertyType)enumeration2.nextElement();
                if (!propertyType.getName().equalsIgnoreCase(string2)) continue;
                bl = true;
                propertyType.setDefaultValue(basicProperties.getProperty(string2));
            }
        }
    }

    BasicProperties readPropertiesFromFile(String string) throws FileNotFoundException, IOException {
        ExpandedProperties expandedProperties = new ExpandedProperties();
        FileInputStream fileInputStream = new FileInputStream(string);
        expandedProperties.load(fileInputStream);
        fileInputStream.close();
        return expandedProperties;
    }

    boolean hasExtension(String string) {
        String string2 = null;
        boolean bl = false;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        if (string2 != null && string2.equalsIgnoreCase("conf")) {
            bl = true;
        }
        return bl;
    }

    Vector createPropertyVector(BasicProperties basicProperties) {
        Vector<PropertyType> vector = new Vector<PropertyType>();
        String[] stringArray = new String[]{"Simple", "Unix", "NT", "Kerberos"};
        vector.add(new PropertyType("auth", PropertyType.COMBO_TYPE, stringArray, basicProperties.getProperty("auth"), "User Authentication context", false));
        vector.add(new PropertyType("host", PropertyType.STRING_TYPE, basicProperties.getProperty("host"), "Host Name of the main-container", false));
        vector.add(new PropertyType("gui", PropertyType.BOOLEAN_TYPE, new Boolean(basicProperties.getBooleanProperty("gui", false)).toString(), "Select to launch the RMA Gui", false));
        vector.add(new PropertyType("port", PropertyType.STRING_TYPE, new Integer(basicProperties.getIntProperty("port", 1099)).toString(), "Port Number of the main-container", false));
        vector.add(new PropertyType("name", PropertyType.STRING_TYPE, basicProperties.getProperty("name"), "The symbolic plaform name", false));
        vector.add(new PropertyType("container", PropertyType.BOOLEAN_TYPE, new Boolean(basicProperties.getBooleanProperty("container", false)).toString(), "Select to launch an agent-container", false));
        vector.add(new PropertyType("mtp", PropertyType.STRING_TYPE, basicProperties.getProperty("mtp"), "List of MTPs to activate", false));
        vector.add(new PropertyType("nomtp", PropertyType.BOOLEAN_TYPE, new Boolean(basicProperties.getBooleanProperty("nomtp", false)).toString(), "Disable all external MTPs on this container", false));
        vector.add(new PropertyType("aclcodec", PropertyType.STRING_TYPE, basicProperties.getProperty("aclcodec"), "List of ACLCodec to install", false));
        vector.add(new PropertyType("agents", PropertyType.STRING_TYPE, basicProperties.getProperty("agents"), "Agents to launch", false));
        vector.add(new PropertyType("nomobility", PropertyType.BOOLEAN_TYPE, new Boolean(basicProperties.getBooleanProperty("nomobility", false)).toString(), "Disable Mobility", false));
        return vector;
    }

    class myFileFilter
    extends FileFilter {
        myFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equals(EXTENSION);
            }
            return false;
        }

        public String getDescription() {
            return "Configuration file (*." + EXTENSION + ")";
        }

        String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    class singlePanel
    extends JPanel {
        singlePanel() {
        }

        JPanel newSinglePanel(PropertyType propertyType) {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            Border border = BorderFactory.createEtchedBorder(Color.white, Color.gray);
            String string = propertyType.getName();
            JLabel jLabel = new JLabel(string.toUpperCase());
            jLabel.setPreferredSize(new Dimension(80, 26));
            jLabel.setMaximumSize(new Dimension(80, 26));
            jLabel.setMinimumSize(new Dimension(80, 26));
            jPanel.add(jLabel);
            String string2 = propertyType.getType();
            String string3 = propertyType.getDefaultValue();
            if (string2.equalsIgnoreCase(PropertyType.COMBO_TYPE)) {
                JComboBox<String> jComboBox = new JComboBox<String>(propertyType.getComboValues());
                jComboBox.setSelectedIndex(0);
                jComboBox.setToolTipText(propertyType.getToolTip());
                jPanel.add(jComboBox);
            } else if (string2.equalsIgnoreCase(PropertyType.BOOLEAN_TYPE)) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(new Boolean(string3));
                jCheckBox.setToolTipText(propertyType.getToolTip());
                jPanel.add(jCheckBox);
            } else {
                JTextField jTextField = new JTextField();
                jTextField.setBorder(border);
                if (string2.equalsIgnoreCase(PropertyType.INTEGER_TYPE)) {
                    jTextField.setPreferredSize(new Dimension(100, 26));
                    jTextField.setMaximumSize(new Dimension(100, 26));
                } else {
                    jTextField.setPreferredSize(new Dimension(600, 26));
                }
                jTextField.setMinimumSize(new Dimension(50, 26));
                jTextField.setText(string3);
                jTextField.setToolTipText(propertyType.getToolTip());
                jPanel.add(jTextField);
            }
            return jPanel;
        }
    }
}

