/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsPredicate;
import jade.content.lang.sl.SL1Ontology;
import jade.content.lang.sl.SL2Vocabulary;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.IRESchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.VariableSchema;
import jade.core.CaseInsensitiveString;

class SL2Ontology
extends SL1Ontology
implements SL2Vocabulary {
    public static final String ONTOLOGY_NAME = "SL2-ONTOLOGY";
    private static Ontology theInstance = new SL2Ontology("SL2-ONTOLOGY", SL1Ontology.getInstance(), null);

    public static Ontology getInstance() {
        return theInstance;
    }

    protected SL2Ontology(String string, Ontology ontology, Introspector introspector) {
        super(string, ontology, introspector);
        try {
            this.add(VariableSchema.getBaseSchema());
            this.add(new IRESchema("iota"));
            this.add(new IRESchema("any"));
            this.add(new IRESchema("all"));
            this.add(new PredicateSchema("forall"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("exists"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("B"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("U"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("PG"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("I"), AbsPredicate.getJavaClass());
            this.add(new PredicateSchema("feasible"), AbsPredicate.getJavaClass());
            this.add(new AgentActionSchema(";"), AbsAgentAction.getJavaClass());
            this.add(new AgentActionSchema("|"), AbsAgentAction.getJavaClass());
            PredicateSchema predicateSchema = (PredicateSchema)this.getSchema("exists");
            predicateSchema.add("what", (VariableSchema)VariableSchema.getBaseSchema());
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("forall");
            predicateSchema.add("what", (VariableSchema)VariableSchema.getBaseSchema());
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("B");
            predicateSchema.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("U");
            predicateSchema.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("PG");
            predicateSchema.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("I");
            predicateSchema.add("agent", (ConceptSchema)this.getSchema("agent-identifier"));
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema());
            predicateSchema = (PredicateSchema)this.getSchema("feasible");
            predicateSchema.add("action", (VariableSchema)VariableSchema.getBaseSchema());
            predicateSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema(), 1);
            AgentActionSchema agentActionSchema = (AgentActionSchema)this.getSchema(";");
            agentActionSchema.add("first", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            agentActionSchema.add("second", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            agentActionSchema.setEncodingByOrder(true);
            agentActionSchema = (AgentActionSchema)this.getSchema("|");
            agentActionSchema.add("first", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            agentActionSchema.add("second", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            agentActionSchema.setEncodingByOrder(true);
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
    }

    boolean isQuantifier(String string) {
        return CaseInsensitiveString.equalsIgnoreCase("exists", string) || CaseInsensitiveString.equalsIgnoreCase("forall", string);
    }

    boolean isModalOp(String string) {
        return CaseInsensitiveString.equalsIgnoreCase("B", string) || CaseInsensitiveString.equalsIgnoreCase("U", string) || CaseInsensitiveString.equalsIgnoreCase("PG", string) || CaseInsensitiveString.equalsIgnoreCase("I", string);
    }

    boolean isActionOp(String string) {
        return super.isActionOp(string) || CaseInsensitiveString.equalsIgnoreCase("feasible", string);
    }

    boolean isSLFunctionWithoutSlotNames(String string) {
        return super.isSLFunctionWithoutSlotNames(string) || CaseInsensitiveString.equalsIgnoreCase(";", string) || CaseInsensitiveString.equalsIgnoreCase("|", string);
    }
}

