/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.Term;
import jade.content.abs.AbsObject;
import jade.content.onto.Introspector;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.schema.ObjectSchema;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Serializable;
import java.util.Date;
import java.util.Hashtable;

public class Ontology
implements Serializable {
    private static final String DEFAULT_INTROSPECTOR_CLASS = "jade.content.onto.ReflectiveIntrospector";
    private Ontology[] base;
    private String name;
    private Introspector introspector;
    private Hashtable elements;
    private Hashtable classes;
    private Hashtable schemas;
    private Logger logger;
    private static Class absObjectClass = null;

    public Ontology(String string, Ontology ontology) {
        this(string, ontology, null);
        try {
            this.introspector = (Introspector)Class.forName(DEFAULT_INTROSPECTOR_CLASS).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Class jade.content.onto.ReflectiveIntrospectorfor default Introspector not found");
        }
    }

    public Ontology(String string, Introspector introspector) {
        this(string, new Ontology[0], introspector);
    }

    public Ontology(String string, Ontology ontology, Introspector introspector) {
        Ontology[] ontologyArray;
        if (ontology != null) {
            Ontology[] ontologyArray2 = new Ontology[1];
            ontologyArray = ontologyArray2;
            ontologyArray2[0] = ontology;
        } else {
            ontologyArray = new Ontology[]{};
        }
        this(string, ontologyArray, introspector);
    }

    public Ontology(String string, Ontology[] ontologyArray, Introspector introspector) {
        this.base = new Ontology[0];
        this.name = null;
        this.introspector = null;
        this.elements = new Hashtable();
        this.classes = new Hashtable();
        this.schemas = new Hashtable();
        this.logger = Logger.getMyLogger(this.getClass().getName());
        this.name = string;
        this.introspector = introspector;
        this.base = ontologyArray != null ? ontologyArray : new Ontology[]{};
    }

    public String getName() {
        return this.name;
    }

    public void add(ObjectSchema objectSchema) throws OntologyException {
        this.add(objectSchema, null);
    }

    public void add(ObjectSchema objectSchema, Class clazz) throws OntologyException {
        if (objectSchema.getTypeName() == null) {
            throw new OntologyException("Invalid schema identifier");
        }
        String string = objectSchema.getTypeName().toLowerCase();
        this.elements.put(string, objectSchema);
        if (clazz != null) {
            this.classes.put(string, clazz);
            if (!absObjectClass.isAssignableFrom(clazz)) {
                if (this.introspector != null) {
                    this.introspector.checkClass(objectSchema, clazz, this);
                }
                this.schemas.put(clazz, objectSchema);
            } else if (!clazz.isInstance(objectSchema.newInstance())) {
                throw new OntologyException("Java class " + clazz.getName() + " can't represent instances of schema " + objectSchema);
            }
        }
    }

    public ObjectSchema getSchema(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Null schema identifier");
        }
        ObjectSchema objectSchema = (ObjectSchema)this.elements.get(string.toLowerCase());
        if (objectSchema == null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema for " + string + " not found");
            }
            int n = 0;
            while (n < this.base.length) {
                if (this.base[n] == null && this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Base ontology # " + n + " for ontology " + this.getName() + " is null");
                }
                if ((objectSchema = this.base[n].getSchema(string)) != null) {
                    return objectSchema;
                }
                ++n;
            }
        }
        return objectSchema;
    }

    public Object toObject(AbsObject absObject) throws OntologyException, UngroundedException {
        if (absObject == null) {
            return null;
        }
        try {
            return this.toObject(absObject, absObject.getTypeName().toLowerCase(), this);
        }
        catch (UnknownSchemaException unknownSchemaException) {
            throw new OntologyException("No schema found for type " + absObject.getTypeName());
        }
        catch (OntologyException ontologyException) {
            if (!absObject.isGrounded()) {
                throw new UngroundedException();
            }
            throw ontologyException;
        }
    }

    public AbsObject fromObject(Object object) throws OntologyException {
        if (object == null) {
            return null;
        }
        try {
            return this.fromObject(object, this);
        }
        catch (UnknownSchemaException unknownSchemaException) {
            throw new OntologyException("No schema found for class " + object.getClass().getName());
        }
    }

    public Class getClassForElement(String string) throws OntologyException {
        if (string == null) {
            throw new OntologyException("Null schema identifier");
        }
        Class clazz = (Class)this.classes.get(string.toLowerCase());
        if (clazz == null) {
            int n = 0;
            while (n < this.base.length) {
                clazz = this.base[n].getClassForElement(string);
                if (clazz != null) {
                    return clazz;
                }
                ++n;
            }
        }
        return clazz;
    }

    protected Object toObject(AbsObject absObject, String string, Ontology ontology) throws UnknownSchemaException, UngroundedException, OntologyException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Abs is: " + absObject);
        }
        ObjectSchema objectSchema = (ObjectSchema)this.elements.get(string);
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema is: " + objectSchema);
        }
        if (objectSchema != null) {
            Class clazz = (Class)this.classes.get(string);
            if (clazz == null) {
                throw new OntologyException("No java class associated to type " + absObject.getTypeName());
            }
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Class is: " + clazz.getName());
            }
            if (absObjectClass.isAssignableFrom(clazz)) {
                return absObject;
            }
            if (this.introspector != null) {
                if (this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Try to internalise " + absObject + " through " + this.introspector);
                }
                return this.introspector.internalise(absObject, objectSchema, clazz, ontology);
            }
        }
        int n = 0;
        while (n < this.base.length) {
            try {
                return this.base[n].toObject(absObject, string, ontology);
            }
            catch (UnknownSchemaException unknownSchemaException) {
                ++n;
            }
        }
        throw new UnknownSchemaException();
    }

    protected AbsObject fromObject(Object object, Ontology ontology) throws UnknownSchemaException, OntologyException {
        if (object instanceof AbsObject) {
            return (AbsObject)object;
        }
        Class<?> clazz = object.getClass();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Class is: " + clazz);
        }
        ObjectSchema objectSchema = (ObjectSchema)this.schemas.get(clazz);
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Schema is: " + objectSchema);
        }
        if (objectSchema != null && this.introspector != null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "Ontology " + this.getName() + ". Try to externalise " + object + " through " + this.introspector);
            }
            return this.introspector.externalise(object, objectSchema, clazz, ontology);
        }
        int n = 0;
        while (n < this.base.length) {
            try {
                return this.base[n].fromObject(object, ontology);
            }
            catch (UnknownSchemaException unknownSchemaException) {
                ++n;
            }
        }
        throw new UnknownSchemaException();
    }

    public static void checkIsTerm(Object object) throws OntologyException {
        if (object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Date || object instanceof Term) {
            return;
        }
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Ontology.checkIsTerm(iterator.next());
            }
            return;
        }
        throw new OntologyException("Object " + object + " of class " + object.getClass().getName() + " is not a term");
    }

    static {
        try {
            absObjectClass = Class.forName("jade.content.abs.AbsObject");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

