/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsConcept;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.schema.ConceptSchema;
import jade.content.schema.PrimitiveSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import starlight.util.Base64;

public class SerializableOntology
extends Ontology {
    private static final SerializableOntology theInstance = new SerializableOntology();
    private static final String SERIALIZABLE = "serializable";
    private static final String SERIALIZABLE_VALUE = "value";

    public static Ontology getInstance() {
        return theInstance;
    }

    private SerializableOntology() {
        super("Serializable-ontology", (Ontology)null, null);
        try {
            PrimitiveSchema primitiveSchema = (PrimitiveSchema)BasicOntology.getInstance().getSchema("BO_String");
            this.add(primitiveSchema);
            ConceptSchema conceptSchema = new ConceptSchema(SERIALIZABLE);
            conceptSchema.add(SERIALIZABLE_VALUE, primitiveSchema);
            this.add(conceptSchema);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Object toObject(AbsObject absObject, String string, Ontology ontology) throws UnknownSchemaException, UngroundedException, OntologyException {
        if (SERIALIZABLE.equals(absObject.getTypeName())) {
            try {
                AbsPrimitive absPrimitive = (AbsPrimitive)absObject.getAbsObject(SERIALIZABLE_VALUE);
                String string2 = absPrimitive.getString();
                byte[] byArray = Base64.decode(string2.toCharArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                return objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                throw new OntologyException("Error in object deserialization.", throwable);
            }
        }
        throw new OntologyException("Abs-object " + absObject + " is not serializable");
    }

    protected AbsObject fromObject(Object object, Ontology ontology) throws UnknownSchemaException, OntologyException {
        if (object instanceof AbsObject) {
            return (AbsObject)object;
        }
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                AbsConcept absConcept = new AbsConcept(SERIALIZABLE);
                String string = new String(Base64.encode(byteArrayOutputStream.toByteArray()));
                absConcept.set(SERIALIZABLE_VALUE, string);
                return absConcept;
            }
            catch (Throwable throwable) {
                throw new OntologyException("Error in object deserialization.", throwable);
            }
        }
        throw new OntologyException("Object " + object + " is not serializable");
    }
}

