/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CommandProcessor;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceManager;
import jade.core.VerticalCommand;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;
import jade.util.leap.Serializable;

public abstract class BaseNode
implements Node,
Serializable {
    private Logger myLogger;
    protected transient ServiceManager myServiceManager;
    private transient CommandProcessor processor;
    private String myName;
    private boolean hasLocalPM = false;
    private transient Map localSlices;

    public BaseNode(String string, boolean bl) {
        this.myName = string;
        this.hasLocalPM = bl;
        this.localSlices = new HashMap(5);
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    public void setName(String string) {
        this.myName = string;
    }

    public String getName() {
        return this.myName;
    }

    public boolean hasPlatformManager() {
        return this.hasLocalPM;
    }

    public void exportSlice(String string, Service.Slice slice) {
        this.localSlices.put(string, slice);
    }

    public void unexportSlice(String string) {
        this.localSlices.remove(string);
    }

    protected Service.Slice getSlice(String string) {
        return (Service.Slice)this.localSlices.get(string);
    }

    public Object serveHorizontalCommand(HorizontalCommand horizontalCommand) throws ServiceException {
        Service.Slice slice;
        String string = horizontalCommand.getService();
        String string2 = horizontalCommand.getName();
        Object[] objectArray = horizontalCommand.getParams();
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Node " + this.myName + " serving incoming H-Command " + string2 + " of Service " + string);
        }
        if ((slice = this.getSlice(string)) != null) {
            Object object = null;
            VerticalCommand verticalCommand = slice.serve(horizontalCommand);
            if (verticalCommand != null) {
                verticalCommand.setPrincipal(horizontalCommand.getPrincipal());
                verticalCommand.setCredentials(horizontalCommand.getCredentials());
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Node " + this.myName + " issuing incoming V-Command " + verticalCommand.getName() + " of Service " + verticalCommand.getService());
                }
                this.serveVerticalCommand(verticalCommand);
                object = verticalCommand.getReturnValue();
            } else {
                object = horizontalCommand.getReturnValue();
            }
            if (object != null && this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Node " + this.myName + " return value for incoming H-Command " + string2 + " of Service " + string + " = " + object);
            }
            return object;
        }
        String string3 = new String("Node " + this.myName + ": Service " + string + " Unknown. Command = " + string2);
        throw new ServiceException("-- " + string3 + " --");
    }

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.processor = commandProcessor;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.myServiceManager = serviceManager;
    }

    public void platformManagerDead(String string, String string2) throws IMTPException {
        this.myServiceManager.addAddress(string2);
        this.myServiceManager.removeAddress(string);
    }

    private Object serveVerticalCommand(VerticalCommand verticalCommand) throws ServiceException {
        if (this.processor == null) {
            throw new ServiceException("No command processor for node <" + this.getName() + ">");
        }
        return this.processor.processIncoming(verticalCommand);
    }
}

