/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Serializable;

class Scheduler
implements Serializable {
    protected List readyBehaviours = new LinkedList();
    protected List blockedBehaviours = new LinkedList();
    private Agent owner;
    private int currentIndex;

    public Scheduler(Agent agent) {
        this.owner = agent;
        this.currentIndex = 0;
    }

    public synchronized void add(Behaviour behaviour) {
        this.readyBehaviours.add(behaviour);
        this.notify();
        this.owner.notifyAddBehaviour(behaviour);
    }

    public synchronized void block(Behaviour behaviour) {
        if (this.removeFromReady(behaviour)) {
            this.blockedBehaviours.add(behaviour);
            this.owner.notifyChangeBehaviourState(behaviour, "READY", "BLOCKED");
        }
    }

    public synchronized void restart(Behaviour behaviour) {
        if (this.removeFromBlocked(behaviour)) {
            this.readyBehaviours.add(behaviour);
            this.notify();
            this.owner.notifyChangeBehaviourState(behaviour, "BLOCKED", "READY");
        }
    }

    public synchronized void restartAll() {
        Object object;
        Behaviour[] behaviourArray = new Behaviour[this.readyBehaviours.size()];
        int n = 0;
        Iterator iterator = this.readyBehaviours.iterator();
        while (iterator.hasNext()) {
            behaviourArray[n++] = (Behaviour)iterator.next();
        }
        int n2 = 0;
        while (n2 < behaviourArray.length) {
            object = behaviourArray[n2];
            ((Behaviour)object).restart();
            ++n2;
        }
        behaviourArray = new Behaviour[this.blockedBehaviours.size()];
        n = 0;
        object = this.blockedBehaviours.iterator();
        while (object.hasNext()) {
            behaviourArray[n++] = (Behaviour)object.next();
        }
        int n3 = 0;
        while (n3 < behaviourArray.length) {
            Behaviour behaviour = behaviourArray[n3];
            behaviour.restart();
            ++n3;
        }
    }

    public synchronized void remove(Behaviour behaviour) {
        boolean bl = this.removeFromBlocked(behaviour);
        if (!bl) {
            bl = this.removeFromReady(behaviour);
        }
        if (bl) {
            this.owner.notifyRemoveBehaviour(behaviour);
        }
    }

    public synchronized Behaviour schedule() throws InterruptedException {
        while (this.readyBehaviours.isEmpty()) {
            this.owner.idle();
        }
        Behaviour behaviour = (Behaviour)this.readyBehaviours.get(this.currentIndex);
        this.currentIndex = (this.currentIndex + 1) % this.readyBehaviours.size();
        return behaviour;
    }

    public synchronized Behaviour[] getBehaviours() {
        Behaviour[] behaviourArray = new Behaviour[this.blockedBehaviours.size() + this.readyBehaviours.size()];
        Iterator iterator = this.readyBehaviours.iterator();
        Iterator iterator2 = this.blockedBehaviours.iterator();
        int n = 0;
        while (n < behaviourArray.length) {
            Behaviour behaviour = null;
            behaviour = iterator.hasNext() ? (Behaviour)iterator.next() : (Behaviour)iterator2.next();
            behaviourArray[n] = behaviour;
            ++n;
        }
        return behaviourArray;
    }

    public void setBehaviours(Behaviour[] behaviourArray) {
        this.readyBehaviours.clear();
        this.blockedBehaviours.clear();
        int n = 0;
        while (n < behaviourArray.length) {
            Behaviour behaviour = behaviourArray[n];
            if (behaviour.isRunnable()) {
                this.readyBehaviours.add(behaviour);
            } else {
                this.blockedBehaviours.add(behaviour);
            }
            ++n;
        }
        this.currentIndex = 0;
    }

    private boolean removeFromBlocked(Behaviour behaviour) {
        return this.blockedBehaviours.remove(behaviour);
    }

    private boolean removeFromReady(Behaviour behaviour) {
        int n = this.readyBehaviours.indexOf(behaviour);
        if (n != -1) {
            this.readyBehaviours.remove(behaviour);
            if (n < this.currentIndex) {
                --this.currentIndex;
            } else if (n == this.currentIndex && this.currentIndex == this.readyBehaviours.size()) {
                this.currentIndex = 0;
            }
        }
        return n != -1;
    }
}

