/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.util.leap.Serializable;

public interface Service {
    public static final String NEW_NODE = "New-Node";
    public static final String DEAD_NODE = "Dead-Node";
    public static final String NEW_SLICE = "New-Slice";
    public static final String DEAD_SLICE = "Dead-Slice";
    public static final String NEW_REPLICA = "New-Replica";
    public static final String DEAD_REPLICA = "Dead-Replica";

    public String getName();

    public Slice getSlice(String var1) throws ServiceException;

    public Slice getLocalSlice();

    public Slice[] getAllSlices() throws ServiceException;

    public Class getHorizontalInterface();

    public int getNumberOfSlices();

    public Filter getCommandFilter(boolean var1);

    public Sink getCommandSink(boolean var1);

    public String[] getOwnedCommands();

    public ServiceHelper getHelper(Agent var1) throws ServiceException;

    public Behaviour getAMSBehaviour();

    public void init(AgentContainer var1, Profile var2) throws ProfileException;

    public void boot(Profile var1) throws ServiceException;

    public void shutdown();

    public Object submit(VerticalCommand var1) throws ServiceException;

    public static class SliceProxy
    implements Slice {
        private Node myNode;
        private transient Service myService;

        public SliceProxy() {
            this(null, null);
        }

        public SliceProxy(Service service, Node node) {
            this.myService = service;
            this.myNode = node;
        }

        public Service getService() {
            return this.myService;
        }

        public Node getNode() throws ServiceException {
            return this.myNode;
        }

        public void setNode(Node node) {
            this.myNode = node;
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            try {
                horizontalCommand.setReturnValue(this.myNode.accept(horizontalCommand));
            }
            catch (IMTPException iMTPException) {
                horizontalCommand.setReturnValue(new ServiceException("An error occurred while routing the command to the remote implementation", iMTPException));
            }
            return null;
        }
    }

    public static interface Slice
    extends Serializable {
        public Service getService();

        public Node getNode() throws ServiceException;

        public VerticalCommand serve(HorizontalCommand var1);
    }
}

