/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Timer;
import java.util.Vector;

public class TimerDispatcher
implements Runnable {
    private static TimerDispatcher theDispatcher;
    private Thread myThread = null;
    private Vector timers = new Vector();
    private boolean active;

    void setThread(Thread thread) {
        if (this.myThread == null) {
            this.myThread = thread;
        }
    }

    public synchronized Timer add(Timer timer) {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.start();
        }
        while (!this.addTimer(timer)) {
            timer.setExpirationTime(timer.expirationTime() + 1L);
        }
        if (this.timers.firstElement() == timer) {
            this.notifyAll();
        }
        return timer;
    }

    public synchronized void remove(Timer timer) {
        this.timers.removeElement(timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.active) {
                Timer timer = null;
                TimerDispatcher timerDispatcher = this;
                synchronized (timerDispatcher) {
                    while (this.active) {
                        long l = 0L;
                        if (!this.timers.isEmpty()) {
                            timer = (Timer)this.timers.firstElement();
                            if (timer.isExpired()) {
                                this.timers.removeElement(timer);
                                break;
                            }
                            l = timer.expirationTime() - System.currentTimeMillis();
                            if (l <= 0L) {
                                l = 1L;
                            }
                        }
                        this.wait(l);
                    }
                }
                if (!this.active) continue;
                timer.fire();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.timers.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Thread thread = this.myThread;
        synchronized (thread) {
            this.active = true;
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.myThread != null) {
            Thread thread = this.myThread;
            synchronized (thread) {
                if (Thread.currentThread().equals(this.myThread)) {
                    System.out.println("Deadlock avoidance: TimerDispatcher thread calling stop on itself!");
                } else {
                    this.active = false;
                    TimerDispatcher timerDispatcher = this;
                    synchronized (timerDispatcher) {
                        this.notifyAll();
                    }
                    try {
                        this.myThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.myThread = null;
            }
        }
    }

    public static TimerDispatcher getTimerDispatcher() {
        if (theDispatcher == null) {
            theDispatcher = new TimerDispatcher();
        }
        return theDispatcher;
    }

    static void setTimerDispatcher(TimerDispatcher timerDispatcher) {
        theDispatcher = timerDispatcher;
    }

    private boolean addTimer(Timer timer) {
        if (!this.timers.contains(timer)) {
            int n = this.timers.size();
            int n2 = 0;
            while (n2 < n) {
                Timer timer2 = (Timer)this.timers.elementAt(n2);
                if (timer.expirationTime() < timer2.expirationTime()) {
                    this.timers.insertElementAt(timer, n2);
                    return true;
                }
                ++n2;
            }
            this.timers.addElement(timer);
            return true;
        }
        return false;
    }
}

