/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SerialBehaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FSMBehaviour
extends SerialBehaviour {
    private Map states = new HashMap();
    private Behaviour current = null;
    private List lastStates = new ArrayList();
    private String firstName = null;
    private String currentName = null;
    private String previousName = null;
    private int lastExitValue;
    private boolean transitionForced = false;
    private String forcedTransitionDest = null;
    private TransitionTable theTransitionTable = new TransitionTable();
    private java.util.Map persistentSubBehaviours = new java.util.HashMap();
    private Set persistentLastStates = new HashSet();
    private Set persistentTransitions = new HashSet();

    public FSMBehaviour() {
    }

    public FSMBehaviour(Agent agent) {
        super(agent);
    }

    public void registerState(Behaviour behaviour, String string) {
        behaviour.setBehaviourName(string);
        behaviour.setParent(this);
        behaviour.setAgent(this.myAgent);
        this.states.put(string, behaviour);
        if (string.equals(this.currentName)) {
            this.current = behaviour;
        }
        this.persistentSubBehaviours.put(string, behaviour);
    }

    public void registerFirstState(Behaviour behaviour, String string) {
        this.registerState(behaviour, string);
        this.firstName = string;
    }

    public void registerLastState(Behaviour behaviour, String string) {
        this.registerState(behaviour, string);
        if (!this.lastStates.contains(string)) {
            this.lastStates.add(string);
            this.persistentLastStates.add(string);
        }
    }

    public void registerTransition(String string, String string2, int n) {
        this.registerTransition(string, string2, n, null);
    }

    public void registerTransition(String string, String string2, int n, String[] stringArray) {
        Transition transition = new Transition(this, string, string2, n, stringArray);
        this.theTransitionTable.addTransition(transition);
    }

    public void registerDefaultTransition(String string, String string2) {
        this.registerDefaultTransition(string, string2, null);
    }

    public void registerDefaultTransition(String string, String string2, String[] stringArray) {
        Transition transition = new Transition(this, string, string2, stringArray);
        this.theTransitionTable.addTransition(transition);
    }

    public Behaviour getState(String string) {
        Behaviour behaviour = null;
        if (string != null) {
            behaviour = (Behaviour)this.states.get(string);
        }
        return behaviour;
    }

    public String getName(Behaviour behaviour) {
        jade.util.leap.Iterator iterator = this.states.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Behaviour behaviour2 = (Behaviour)this.states.get(string);
            if (behaviour != behaviour2) continue;
            return string;
        }
        return null;
    }

    public int getLastExitValue() {
        return this.lastExitValue;
    }

    public int onEnd() {
        return this.getLastExitValue();
    }

    protected void scheduleFirst() {
        if (this.transitionForced) {
            this.currentName = this.forcedTransitionDest;
            this.transitionForced = false;
        } else {
            this.currentName = this.firstName;
        }
        this.current = this.getState(this.currentName);
    }

    protected void scheduleNext(boolean bl, int n) {
        block5: {
            if (!bl) break block5;
            try {
                this.previousName = this.currentName;
                if (this.transitionForced) {
                    this.currentName = this.forcedTransitionDest;
                    this.transitionForced = false;
                } else {
                    Transition transition = this.theTransitionTable.getTransition(this.currentName, n);
                    this.resetStates(transition.toBeReset);
                    this.currentName = transition.dest;
                }
                this.current = this.getState(this.currentName);
                if (this.current == null) {
                    throw new NullPointerException();
                }
                this.handleStateEntered(this.current);
            }
            catch (NullPointerException nullPointerException) {
                this.current = null;
                this.handleInconsistentFSM(this.previousName, n);
            }
        }
    }

    protected void handleInconsistentFSM(String string, int n) {
        throw new RuntimeException("Inconsistent FSM. State: " + string + " event: " + n);
    }

    protected void handleStateEntered(Behaviour behaviour) {
    }

    protected boolean checkTermination(boolean bl, int n) {
        if (bl) {
            this.lastExitValue = n;
            return this.lastStates.contains(this.currentName);
        }
        return false;
    }

    protected Behaviour getCurrent() {
        return this.current;
    }

    public Collection getChildren() {
        return this.states.values();
    }

    protected void forceTransitionTo(String string) {
        Behaviour behaviour = this.getState(string);
        if (behaviour != null) {
            this.transitionForced = true;
            this.forcedTransitionDest = string;
        }
    }

    public void reset() {
        super.reset();
        this.transitionForced = false;
        this.forcedTransitionDest = null;
    }

    public void resetStates(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Behaviour behaviour = this.getState(stringArray[n]);
                behaviour.reset();
                ++n;
            }
        }
    }

    private boolean isTransitionForced() {
        return this.transitionForced;
    }

    private void setTransitionForced(boolean bl) {
        this.transitionForced = bl;
    }

    private String getForcedTransitionDest() {
        return this.forcedTransitionDest;
    }

    private void setForcedTransitionDest(String string) {
        this.forcedTransitionDest = string;
    }

    private java.util.Map getSubBehaviours() {
        return this.persistentSubBehaviours;
    }

    private void setSubBehaviours(java.util.Map map) {
        this.states.clear();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.states.put(entry.getKey(), entry.getValue());
        }
        this.persistentSubBehaviours = map;
    }

    private String getFirstState() {
        return this.firstName;
    }

    private void setFirstState(String string) {
        this.firstName = string;
    }

    private Set getLastStates() {
        return this.persistentLastStates;
    }

    private void setLastStates(Set set) {
        if (this.persistentLastStates != set) {
            this.lastStates.clear();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.lastStates.add(iterator.next());
            }
            this.persistentLastStates = set;
        }
    }

    private Set getTransitions() {
        return this.persistentTransitions;
    }

    private void setTransitions(Set set) {
        if (!this.persistentTransitions.equals(set)) {
            this.theTransitionTable.clear();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Transition transition = (Transition)iterator.next();
                this.theTransitionTable.addTransition(transition);
            }
        }
        this.persistentTransitions = set;
    }

    class TransitionsFromState
    extends Hashtable {
        private Transition defaultTransition = null;
        private static final long serialVersionUID = 3487495895819005L;

        TransitionsFromState() {
        }

        void setDefaultTransition(Transition transition) {
            this.defaultTransition = transition;
        }

        Transition getDefaultTransition() {
            return this.defaultTransition;
        }

        public Object get(Object object) {
            Transition transition = (Transition)super.get(object);
            if (transition == null) {
                transition = this.defaultTransition;
            }
            return transition;
        }
    }

    static class Transition
    implements Serializable {
        private FSMBehaviour fsm;
        private String src;
        private String dest;
        private int trigger;
        private boolean def;
        private String[] toBeReset;
        private static final long serialVersionUID = 3487495895819004L;
        private Long persistentID;

        public Transition() {
        }

        public Transition(FSMBehaviour fSMBehaviour, String string, String string2, int n, String[] stringArray) {
            this.fsm = fSMBehaviour;
            this.src = string;
            this.dest = string2;
            this.trigger = n;
            this.def = false;
            this.toBeReset = stringArray;
        }

        public Transition(FSMBehaviour fSMBehaviour, String string, String string2, String[] stringArray) {
            this.fsm = fSMBehaviour;
            this.src = string;
            this.dest = string2;
            this.trigger = 0;
            this.def = true;
            this.toBeReset = stringArray;
        }

        public FSMBehaviour getFSM() {
            return this.fsm;
        }

        public void setFSM(FSMBehaviour fSMBehaviour) {
            this.fsm = fSMBehaviour;
        }

        public String getFromState() {
            return this.src;
        }

        public void setFromState(String string) {
            this.src = string;
        }

        public String getToState() {
            return this.dest;
        }

        public void setToState(String string) {
            this.dest = string;
        }

        public int getTrigger() {
            return this.trigger;
        }

        public void setTrigger(int n) {
            this.trigger = n;
        }

        public boolean isDefault() {
            return this.def;
        }

        public void setDefault(boolean bl) {
            this.def = bl;
        }

        public String[] getStatesToReset() {
            return this.toBeReset;
        }

        public void setStatesToReset(String[] stringArray) {
            this.toBeReset = stringArray;
        }

        private Long getPersistentID() {
            return this.persistentID;
        }

        private void setPersistentID(Long l) {
            this.persistentID = l;
        }
    }

    class TransitionTable
    implements Serializable {
        private Hashtable transitions = new Hashtable();
        private static final long serialVersionUID = 3487495895819003L;

        TransitionTable() {
        }

        void clear() {
            this.transitions.clear();
            FSMBehaviour.this.persistentTransitions.clear();
        }

        void addTransition(Transition transition) {
            String string = transition.getFromState();
            TransitionsFromState transitionsFromState = null;
            if (!this.transitions.containsKey(string)) {
                transitionsFromState = new TransitionsFromState();
                this.transitions.put(string, transitionsFromState);
            } else {
                transitionsFromState = (TransitionsFromState)this.transitions.get(string);
            }
            if (transition.isDefault()) {
                transitionsFromState.setDefaultTransition(transition);
            } else {
                Integer n = new Integer(transition.getTrigger());
                transitionsFromState.put(n, transition);
            }
            FSMBehaviour.this.persistentTransitions.add(transition);
        }

        void removeTransition(String string, int n) {
            Transition transition;
            TransitionsFromState transitionsFromState = (TransitionsFromState)this.transitions.get(string);
            if (transitionsFromState != null && (transition = (Transition)transitionsFromState.remove(new Integer(n))) != null) {
                if (transitionsFromState.isEmpty() && transitionsFromState.getDefaultTransition() == null) {
                    this.transitions.remove(string);
                }
                FSMBehaviour.this.persistentTransitions.remove(transition);
            }
        }

        void removeTransition(String string) {
            TransitionsFromState transitionsFromState = (TransitionsFromState)this.transitions.get(string);
            if (transitionsFromState != null) {
                Transition transition = transitionsFromState.getDefaultTransition();
                transitionsFromState.setDefaultTransition(null);
                if (transitionsFromState.isEmpty()) {
                    this.transitions.remove(string);
                }
                FSMBehaviour.this.persistentTransitions.remove(transition);
            }
        }

        Transition getTransition(String string, int n) {
            TransitionsFromState transitionsFromState = (TransitionsFromState)this.transitions.get(string);
            if (transitionsFromState != null) {
                Transition transition = (Transition)transitionsFromState.get(new Integer(n));
                return transition;
            }
            return null;
        }
    }
}

