/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.BehaviourList;
import jade.core.behaviours.CompositeBehaviour;
import jade.util.leap.Collection;
import jade.util.leap.Iterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class ParallelBehaviour
extends CompositeBehaviour {
    public static final int WHEN_ALL = 0;
    public static final int WHEN_ANY = 1;
    private int whenToStop;
    private BehaviourList subBehaviours = new BehaviourList();
    private Hashtable blockedChildren = new Hashtable();
    private BehaviourList terminatedChildren = new BehaviourList();
    private Set persistentSubBehaviours = new HashSet();
    private Set persistentTerminatedChildren = new HashSet();

    public ParallelBehaviour() {
        this.whenToStop = 0;
    }

    public ParallelBehaviour(int n) {
        this.whenToStop = n;
    }

    public ParallelBehaviour(Agent agent, int n) {
        super(agent);
        this.whenToStop = n;
    }

    protected void scheduleFirst() {
        this.subBehaviours.begin();
        Behaviour behaviour = this.subBehaviours.getCurrent();
        if (behaviour != null && this.blockedChildren.size() < this.subBehaviours.size()) {
            while (!behaviour.isRunnable()) {
                behaviour = this.subBehaviours.next();
            }
        }
    }

    protected void scheduleNext(boolean bl, int n) {
        Behaviour behaviour = this.subBehaviours.next();
        if (behaviour != null && this.blockedChildren.size() < this.subBehaviours.size()) {
            while (!behaviour.isRunnable()) {
                behaviour = this.subBehaviours.next();
            }
        }
    }

    protected boolean checkTermination(boolean bl, int n) {
        if (bl) {
            Behaviour behaviour = this.subBehaviours.getCurrent();
            this.subBehaviours.removeElement(behaviour);
            behaviour.setParent(null);
            this.terminatedChildren.addElement(behaviour);
            this.persistentSubBehaviours.remove(behaviour);
            this.persistentTerminatedChildren.add(behaviour);
        }
        if (!this.evalCondition()) {
            if (this.blockedChildren.size() == this.subBehaviours.size()) {
                this.myEvent.init(false, -1);
                super.handle(this.myEvent);
            }
            return false;
        }
        return true;
    }

    protected Behaviour getCurrent() {
        return this.subBehaviours.getCurrent();
    }

    public Collection getChildren() {
        return this.subBehaviours;
    }

    public void addSubBehaviour(Behaviour behaviour) {
        this.subBehaviours.addElement(behaviour);
        this.persistentSubBehaviours.add(behaviour);
        behaviour.setParent(this);
        behaviour.setAgent(this.myAgent);
        if (behaviour.isRunnable()) {
            if (!this.isRunnable()) {
                this.myEvent.init(true, -1);
                super.handle(this.myEvent);
                if (this.myAgent != null) {
                    this.myAgent.notifyRestarted(this);
                }
                this.currentExecuted = true;
            }
        } else {
            this.blockedChildren.put(behaviour, behaviour);
        }
    }

    public void removeSubBehaviour(Behaviour behaviour) {
        boolean bl = this.subBehaviours.removeElement(behaviour);
        this.persistentSubBehaviours.remove(behaviour);
        if (bl) {
            behaviour.setParent(null);
        }
        if (!behaviour.isRunnable()) {
            this.blockedChildren.remove(behaviour);
        } else if (!this.subBehaviours.isEmpty() && this.blockedChildren.size() == this.subBehaviours.size()) {
            this.myEvent.init(false, -1);
            super.handle(this.myEvent);
        }
    }

    public void reset() {
        this.blockedChildren.clear();
        this.terminatedChildren.begin();
        Behaviour behaviour = this.terminatedChildren.getCurrent();
        while (behaviour != null) {
            this.terminatedChildren.removeElement(behaviour);
            behaviour.setParent(this);
            this.subBehaviours.addElement(behaviour);
            this.persistentTerminatedChildren.remove(behaviour);
            this.persistentSubBehaviours.add(behaviour);
            behaviour = this.terminatedChildren.next();
        }
        this.subBehaviours.begin();
        super.reset();
    }

    protected void handle(Behaviour.RunnableChangedEvent runnableChangedEvent) {
        block7: {
            Behaviour behaviour;
            block5: {
                Behaviour behaviour2;
                block8: {
                    block6: {
                        if (!runnableChangedEvent.isUpwards()) break block5;
                        behaviour2 = runnableChangedEvent.getSource();
                        if (behaviour2 != this) break block6;
                        super.handle(runnableChangedEvent);
                        break block7;
                    }
                    if (!runnableChangedEvent.isRunnable()) break block8;
                    Object v = this.blockedChildren.remove(behaviour2);
                    if (v != null && !this.isRunnable()) {
                        this.myEvent.init(true, -1);
                        super.handle(this.myEvent);
                        this.currentExecuted = true;
                    }
                    break block7;
                }
                Behaviour behaviour3 = this.blockedChildren.put(behaviour2, behaviour2);
                if (behaviour3 == null || this.blockedChildren.size() != this.subBehaviours.size()) break block7;
                this.myEvent.init(false, -1);
                super.handle(this.myEvent);
                break block7;
            }
            boolean bl = runnableChangedEvent.isRunnable();
            this.setRunnable(bl);
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                behaviour = (Behaviour)iterator.next();
                behaviour.handle(runnableChangedEvent);
            }
            if (bl) {
                this.blockedChildren.clear();
            } else {
                iterator = this.getChildren().iterator();
                while (iterator.hasNext()) {
                    behaviour = (Behaviour)iterator.next();
                    this.blockedChildren.put(behaviour, behaviour);
                }
            }
        }
    }

    private boolean evalCondition() {
        boolean bl;
        switch (this.whenToStop) {
            case 0: {
                bl = this.subBehaviours.isEmpty();
                break;
            }
            case 1: {
                bl = this.terminatedChildren.size() > 0;
                break;
            }
            default: {
                bl = this.terminatedChildren.size() >= this.whenToStop;
            }
        }
        return bl;
    }

    private Set getSubBehaviours() {
        return this.persistentSubBehaviours;
    }

    private void setSubBehaviours(Set set) {
        this.subBehaviours.clear();
        this.blockedChildren.clear();
        java.util.Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            this.subBehaviours.addElement(behaviour);
            if (behaviour.isRunnable()) continue;
            this.blockedChildren.put(behaviour, behaviour);
        }
        this.subBehaviours.begin();
        this.persistentSubBehaviours = set;
    }

    private Set getTerminatedChildren() {
        return this.persistentTerminatedChildren;
    }

    private void setTerminatedChildren(Set set) {
        this.terminatedChildren.clear();
        java.util.Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            this.terminatedChildren.addElement(behaviour);
        }
        this.persistentTerminatedChildren = set;
    }

    private int getWhenToStop() {
        return this.whenToStop;
    }

    private void setWhenToStop(int n) {
        this.whenToStop = n;
    }
}

