/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.ContainerID;
import jade.core.event.JADEEvent;
import jade.wrapper.PlatformController;

public class PlatformEvent
extends JADEEvent
implements jade.wrapper.PlatformEvent {
    public static final int ADDED_CONTAINER = 1;
    public static final int REMOVED_CONTAINER = 2;
    public static final int MOVED_AGENT = 5;
    public static final int SUSPENDED_AGENT = 6;
    public static final int RESUMED_AGENT = 7;
    public static final int CHANGED_AGENT_PRINCIPAL = 8;
    public static final int CHANGED_CONTAINER_PRINCIPAL = 9;
    public static final int FROZEN_AGENT = 10;
    public static final int THAWED_AGENT = 11;
    private ContainerID newContainer = null;
    private String myPlatformName = null;
    private AID agent = null;
    private String oldOwnership = null;
    private String newOwnership = null;

    public PlatformEvent(int n, ContainerID containerID) {
        super(n, containerID);
        if (!this.isContainerBD()) {
            throw new InternalError("Bad event kind: it must be a container related kind.");
        }
    }

    public PlatformEvent(int n, AID aID, ContainerID containerID) {
        super(n, containerID);
        if (!this.isAgentBD()) {
            throw new InternalError("Bad event kind: it must be an agent related kind.");
        }
        this.agent = aID;
    }

    public PlatformEvent(AID aID, ContainerID containerID, ContainerID containerID2) {
        super(5, containerID);
        this.agent = aID;
        this.newContainer = containerID2;
    }

    public PlatformEvent(int n, AID aID, ContainerID containerID, ContainerID containerID2) {
        super(n, containerID);
        this.agent = aID;
        this.newContainer = containerID2;
    }

    public PlatformEvent(int n, AID aID, ContainerID containerID, String string, String string2) {
        super(n, containerID);
        this.agent = aID;
        this.oldOwnership = string;
        this.newOwnership = string2;
    }

    public ContainerID getContainer() {
        return (ContainerID)this.getSource();
    }

    public ContainerID getNewContainer() {
        return this.newContainer;
    }

    public AID getAgent() {
        return this.agent;
    }

    public String getOldOwnership() {
        return this.oldOwnership;
    }

    public String getNewOwnership() {
        return this.newOwnership;
    }

    public boolean isContainerBD() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isAgentBD() {
        return this.type == 3 || this.type == 4 || this.type == 6 || this.type == 7 || this.type == 10;
    }

    public int getEventType() {
        return this.type;
    }

    public void setSource(Object object) {
        this.source = object;
        if (this.source instanceof PlatformController) {
            this.myPlatformName = ((PlatformController)this.source).getName();
        }
    }

    public String getPlatformName() {
        return this.myPlatformName;
    }

    public String getAgentGUID() {
        if (this.agent != null) {
            return this.agent.getName();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("PlatformEvent[");
        switch (this.type) {
            case 1: {
                stringBuffer.append("add container: ").append(this.getSource());
                break;
            }
            case 2: {
                stringBuffer.append("remove container: ").append(this.getSource());
                break;
            }
            case 3: {
                stringBuffer.append("born agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 4: {
                stringBuffer.append("dead agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 6: {
                stringBuffer.append("suspended agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 7: {
                stringBuffer.append("resumed agent: ").append(this.agent).append(" in ").append(this.getSource());
                break;
            }
            case 5: {
                stringBuffer.append("moved agent: ").append(this.agent).append(" from: ").append(this.getSource()).append(" to: ").append(this.newContainer);
                break;
            }
            case 8: {
                stringBuffer.append("changed agent ownership: ").append(this.agent).append(" in: ").append(this.getSource()).append(" from: ").append(this.oldOwnership).append(" to: ").append(this.newOwnership);
                break;
            }
            case 9: {
                stringBuffer.append("changed container ownership: ").append(this.getSource()).append(" from: ").append(this.oldOwnership).append(" to: ").append(this.newOwnership);
                break;
            }
            default: {
                stringBuffer.append("Error: bad event type ID in PlatformEvent.toString()");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

