/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.management.AgentManagementSlice;
import jade.core.management.JarClassLoader;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import java.io.IOException;

public class AgentManagementService
extends BaseService {
    static final String NAME = "jade.core.management.AgentManagement";
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    public static final String AGENTS_PATH = "jade_AgentManagement_agentspath";
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Create", "Request-Kill", "Request-State-Change", "Inform-Created", "Inform-Killed", "Inform-State-Changed", "Kill-Container", "Add-Tool", "Remove-Tool"};
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private String agentsPath = null;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
        this.agentsPath = profile.getParameter(AGENTS_PATH, null);
        if (this.agentsPath != null && !this.agentsPath.endsWith("/")) {
            this.agentsPath = this.agentsPath + '/';
        }
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.management.AgentManagementSlice");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        return null;
    }

    public Sink getCommandSink(boolean bl) {
        if (!bl) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    private void initAgent(AID aID, Agent agent, VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NameClashException, NotFoundException, ServiceException {
        Agent agent2 = this.myContainer.addLocalAgent(aID, agent);
        try {
            AgentManagementSlice agentManagementSlice = (AgentManagementSlice)this.getSlice("$$$Main-Slice$$$");
            try {
                agentManagementSlice.bornAgent(aID, this.myContainer.getID(), verticalCommand);
            }
            catch (IMTPException iMTPException) {
                agentManagementSlice = (AgentManagementSlice)this.getFreshSlice("$$$Main-Slice$$$");
                agentManagementSlice.bornAgent(aID, this.myContainer.getID(), verticalCommand);
            }
        }
        catch (NameClashException nameClashException) {
            this.myContainer.removeLocalAgent(aID);
            if (agent2 != null) {
                this.myContainer.addLocalAgent(aID, agent2);
            }
            throw nameClashException;
        }
        catch (IMTPException iMTPException) {
            this.myContainer.removeLocalAgent(aID);
            throw iMTPException;
        }
        catch (NotFoundException notFoundException) {
            this.myContainer.removeLocalAgent(aID);
            throw notFoundException;
        }
        catch (JADESecurityException jADESecurityException) {
            this.myContainer.removeLocalAgent(aID);
            throw jADESecurityException;
        }
    }

    protected Service.Slice getFreshSlice(String string) throws ServiceException {
        return super.getFreshSlice(string);
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return AgentManagementService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AgentManagementService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            GenericCommand genericCommand = null;
            try {
                String string = horizontalCommand.getName();
                Object[] objectArray = horizontalCommand.getParams();
                if (string.equals("1")) {
                    GenericCommand genericCommand2 = new GenericCommand("Request-Create", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    String string2 = (String)objectArray[1];
                    Object[] objectArray2 = (Object[])objectArray[2];
                    JADEPrincipal jADEPrincipal = (JADEPrincipal)objectArray[3];
                    Credentials credentials = (Credentials)objectArray[4];
                    Boolean bl = (Boolean)objectArray[5];
                    genericCommand2.addParam(aID);
                    genericCommand2.addParam(string2);
                    genericCommand2.addParam(objectArray2);
                    genericCommand2.addParam(jADEPrincipal);
                    genericCommand2.addParam(credentials);
                    genericCommand2.addParam(bl);
                    genericCommand = genericCommand2;
                } else if (string.equals("2")) {
                    GenericCommand genericCommand3 = new GenericCommand("Request-Kill", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    genericCommand3.addParam(aID);
                    genericCommand = genericCommand3;
                } else if (string.equals("3")) {
                    GenericCommand genericCommand4 = new GenericCommand("Request-State-Change", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    Integer n = (Integer)objectArray[1];
                    genericCommand4.addParam(aID);
                    genericCommand4.addParam(n);
                    genericCommand = genericCommand4;
                } else if (string.equals("4")) {
                    GenericCommand genericCommand5 = new GenericCommand("Inform-Created", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    genericCommand5.addParam(aID);
                    genericCommand5.addParam(containerID);
                    genericCommand = genericCommand5;
                } else if (string.equals("5")) {
                    GenericCommand genericCommand6 = new GenericCommand("Inform-Killed", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    genericCommand6.addParam(aID);
                    genericCommand = genericCommand6;
                } else if (string.equals("6")) {
                    GenericCommand genericCommand7 = new GenericCommand("Inform-State-Changed", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    genericCommand7.addParam(aID);
                    genericCommand7.addParam("suspended");
                    genericCommand7.addParam("*");
                    genericCommand = genericCommand7;
                } else if (string.equals("7")) {
                    GenericCommand genericCommand8 = new GenericCommand("Inform-State-Changed", AgentManagementService.NAME, null);
                    AID aID = (AID)objectArray[0];
                    genericCommand8.addParam(aID);
                    genericCommand8.addParam("active");
                    genericCommand8.addParam("suspended");
                    genericCommand = genericCommand8;
                } else if (string.equals("8")) {
                    GenericCommand genericCommand9;
                    genericCommand = genericCommand9 = new GenericCommand("Kill-Container", AgentManagementService.NAME, null);
                }
            }
            catch (Throwable throwable) {
                horizontalCommand.setReturnValue(throwable);
            }
            return genericCommand;
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Request-Create")) {
                    this.handleRequestCreate(verticalCommand);
                } else if (string.equals("Request-Kill")) {
                    this.handleRequestKill(verticalCommand);
                } else if (string.equals("Request-State-Change")) {
                    this.handleRequestStateChange(verticalCommand);
                } else if (string.equals("Inform-Killed")) {
                    this.handleInformKilled(verticalCommand);
                } else if (string.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(verticalCommand);
                } else if (string.equals("Inform-Created")) {
                    this.handleInformCreated(verticalCommand);
                } else if (string.equals("Kill-Container")) {
                    this.handleKillContainer(verticalCommand);
                }
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
        }

        private void handleRequestCreate(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, NameClashException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            String string = (String)objectArray[1];
            Object[] objectArray2 = (Object[])objectArray[2];
            JADEPrincipal jADEPrincipal = (JADEPrincipal)objectArray[3];
            Credentials credentials = (Credentials)objectArray[4];
            boolean bl = (Boolean)objectArray[5];
            if (AgentManagementService.this.logger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.logger.log(Logger.FINE, "Target sink consuming command REQUEST_CREATE: Name is " + aID.getName());
            }
            this.createAgent(aID, string, objectArray2, jADEPrincipal, credentials, bl);
        }

        private void handleRequestKill(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            if (AgentManagementService.this.logger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.logger.log(Logger.FINE, "Target sink consuming command REQUEST_KILL: Name is " + aID.getName());
            }
            this.killAgent(aID);
        }

        private void handleRequestStateChange(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            int n = (Integer)objectArray[1];
            this.changeAgentState(aID, n);
        }

        private void handleInformCreated(VerticalCommand verticalCommand) throws NotFoundException, NameClashException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            if (AgentManagementService.this.logger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.logger.log(Logger.FINE, "Target sink consuming command INFORM_CREATED: Name is " + aID.getName());
            }
            this.bornAgent(aID, containerID, verticalCommand.getPrincipal(), verticalCommand.getCredentials());
        }

        private void handleInformKilled(VerticalCommand verticalCommand) throws NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            if (AgentManagementService.this.logger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.logger.log(Logger.FINE, "Target sink consuming command INFORM_KILLED: Name is " + aID.getName());
            }
            this.deadAgent(aID);
        }

        private void handleInformStateChanged(VerticalCommand verticalCommand) throws NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            String string = (String)objectArray[1];
            String string2 = (String)objectArray[2];
            if (string.equals("suspended")) {
                this.suspendedAgent(aID);
            } else if (string.equals("active")) {
                this.resumedAgent(aID);
            }
        }

        private void handleKillContainer(VerticalCommand verticalCommand) {
            if (AgentManagementService.this.logger.isLoggable(Logger.FINE)) {
                AgentManagementService.this.logger.log(Logger.FINE, "Target sink consuming command KILL_CONTAINER");
            }
            this.exitContainer();
        }

        private void createAgent(AID aID, String string, Object[] objectArray, JADEPrincipal jADEPrincipal, Credentials credentials, boolean bl) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
            Agent agent = null;
            try {
                String string2 = string.replace('.', '_') + ".jar";
                if (AgentManagementService.this.agentsPath != null) {
                    string2 = AgentManagementService.this.agentsPath + string2;
                }
                try {
                    JarClassLoader jarClassLoader = new JarClassLoader(string2, this.getClass().getClassLoader());
                    agent = (Agent)jarClassLoader.loadClass(string).newInstance();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                agent.setArguments(objectArray);
                AgentManagementService.this.myContainer.initAgent(aID, agent, jADEPrincipal, credentials);
                if (bl) {
                    AgentManagementService.this.myContainer.powerUpLocalAgent(aID);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IMTPException("Class " + string + " for agent " + aID + " not found", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new IMTPException("Class " + string + " for agent " + aID + " cannot be instantiated", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IMTPException("Illegal access exception in createAgent()", illegalAccessException);
            }
        }

        private void killAgent(AID aID) throws IMTPException, NotFoundException {
            Agent agent = AgentManagementService.this.myContainer.acquireLocalAgent(aID);
            if (agent == null) {
                throw new NotFoundException("Kill-Agent failed to find " + aID);
            }
            agent.doDelete();
            AgentManagementService.this.myContainer.releaseLocalAgent(aID);
        }

        private void changeAgentState(AID aID, int n) throws IMTPException, NotFoundException {
            Agent agent = AgentManagementService.this.myContainer.acquireLocalAgent(aID);
            if (agent == null) {
                throw new NotFoundException("Change-Agent-State failed to find " + aID);
            }
            if (n == 4) {
                agent.doSuspend();
            } else if (n == 5) {
                agent.doWait();
            } else if (n == 2) {
                int n2 = agent.getState();
                if (n2 == 4) {
                    agent.doActivate();
                } else {
                    agent.doWake();
                }
            }
            AgentManagementService.this.myContainer.releaseLocalAgent(aID);
        }

        private void bornAgent(AID aID, ContainerID containerID, JADEPrincipal jADEPrincipal, Credentials credentials) throws NameClashException, NotFoundException {
            block6: {
                JADEPrincipal jADEPrincipal2;
                MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
                if (mainContainer == null) break block6;
                String string = "NONE";
                if (credentials != null && (jADEPrincipal2 = credentials.getOwner()) != null) {
                    string = jADEPrincipal2.getName();
                }
                try {
                    mainContainer.bornAgent(aID, containerID, jADEPrincipal, string, false);
                }
                catch (NameClashException nameClashException) {
                    try {
                        ContainerID containerID2 = mainContainer.getContainerID(aID);
                        Node node = mainContainer.getContainerNode(containerID2).getNode();
                        node.ping(false);
                        throw nameClashException;
                    }
                    catch (NameClashException nameClashException2) {
                        throw nameClashException2;
                    }
                    catch (Exception exception) {
                        mainContainer.bornAgent(aID, containerID, jADEPrincipal, string, true);
                    }
                }
            }
        }

        private void deadAgent(AID aID) throws NotFoundException {
            MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.deadAgent(aID);
            }
        }

        private void suspendedAgent(AID aID) throws NotFoundException {
            MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.suspendedAgent(aID);
            }
        }

        private void resumedAgent(AID aID) throws NotFoundException {
            MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.resumedAgent(aID);
            }
        }

        private void exitContainer() {
            AgentManagementService.this.myContainer.shutDown();
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Request-Create")) {
                    this.handleRequestCreate(verticalCommand);
                } else if (string.equals("Request-Kill")) {
                    this.handleRequestKill(verticalCommand);
                } else if (string.equals("Request-State-Change")) {
                    this.handleRequestStateChange(verticalCommand);
                } else if (string.equals("Inform-Created")) {
                    this.handleInformCreated(verticalCommand);
                } else if (string.equals("Inform-Killed")) {
                    this.handleInformKilled(verticalCommand);
                } else if (string.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(verticalCommand);
                } else if (string.equals("Kill-Container")) {
                    this.handleKillContainer(verticalCommand);
                } else if (string.equals("Add-Tool")) {
                    this.handleAddTool(verticalCommand);
                } else if (string.equals("Remove-Tool")) {
                    this.handleRemoveTool(verticalCommand);
                }
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
        }

        private void handleRequestCreate(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, NameClashException, ServiceException {
            MainContainer mainContainer;
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            Object[] objectArray2 = (String[])objectArray[2];
            ContainerID containerID = (ContainerID)objectArray[3];
            JADEPrincipal jADEPrincipal = (JADEPrincipal)objectArray[4];
            Credentials credentials = (Credentials)objectArray[5];
            if (AgentManagementService.this.logger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.logger.log(Logger.CONFIG, "Source Sink consuming command REQUEST_CREATE. Name is " + string);
            }
            if ((mainContainer = AgentManagementService.this.myContainer.getMain()) != null) {
                AID aID = new AID(string, false);
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(containerID.getName());
                if (agentManagementSlice != null) {
                    try {
                        agentManagementSlice.createAgent(aID, string2, objectArray2, jADEPrincipal, credentials, true, verticalCommand);
                    }
                    catch (IMTPException iMTPException) {
                        agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(containerID.getName());
                        agentManagementSlice.createAgent(aID, string2, objectArray2, jADEPrincipal, credentials, true, verticalCommand);
                    }
                } else {
                    throw new NotFoundException("Container " + containerID.getName() + " not found");
                }
            }
        }

        private void handleRequestKill(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            block3: {
                MainContainer mainContainer;
                Object[] objectArray = verticalCommand.getParams();
                AID aID = (AID)objectArray[0];
                if (AgentManagementService.this.logger.isLoggable(Logger.CONFIG)) {
                    AgentManagementService.this.logger.log(Logger.CONFIG, "Source Sink consuming command REQUEST_KILL. Name is " + aID.getName());
                }
                if ((mainContainer = AgentManagementService.this.myContainer.getMain()) == null) break block3;
                ContainerID containerID = mainContainer.getContainerID(aID);
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(containerID.getName());
                try {
                    agentManagementSlice.killAgent(aID, verticalCommand);
                }
                catch (IMTPException iMTPException) {
                    agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(containerID.getName());
                    agentManagementSlice.killAgent(aID, verticalCommand);
                }
            }
        }

        private void handleRequestStateChange(VerticalCommand verticalCommand) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            block7: {
                Object[] objectArray = verticalCommand.getParams();
                AID aID = (AID)objectArray[0];
                AgentState agentState = (AgentState)objectArray[1];
                int n = 0;
                if (agentState.equals("suspended")) {
                    n = 4;
                } else if (agentState.equals("waiting")) {
                    n = 5;
                } else if (agentState.equals("active")) {
                    n = 2;
                }
                MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
                if (mainContainer == null) break block7;
                ContainerID containerID = mainContainer.getContainerID(aID);
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(containerID.getName());
                try {
                    agentManagementSlice.changeAgentState(aID, n);
                }
                catch (IMTPException iMTPException) {
                    agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(containerID.getName());
                    agentManagementSlice.changeAgentState(aID, n);
                }
            }
        }

        private void handleInformCreated(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            Agent agent = (Agent)objectArray[1];
            if (AgentManagementService.this.logger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.logger.log(Logger.CONFIG, "Source Sink consuming command INFORM_CREATED. Name is " + aID.getName());
            }
            AgentManagementService.this.initAgent(aID, agent, verticalCommand);
        }

        private void handleInformKilled(VerticalCommand verticalCommand) throws IMTPException, NotFoundException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            if (AgentManagementService.this.logger.isLoggable(Logger.CONFIG)) {
                AgentManagementService.this.logger.log(Logger.CONFIG, "Source Sink consuming command INFORM_KILLED. Name is " + aID.getName());
            }
            AgentManagementService.this.myContainer.removeLocalAgent(aID);
            AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
            try {
                agentManagementSlice.deadAgent(aID, verticalCommand);
            }
            catch (IMTPException iMTPException) {
                agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                agentManagementSlice.deadAgent(aID, verticalCommand);
            }
        }

        private void handleInformStateChanged(VerticalCommand verticalCommand) {
            block12: {
                AgentState agentState;
                AID aID;
                block13: {
                    Object[] objectArray = verticalCommand.getParams();
                    aID = (AID)objectArray[0];
                    agentState = (AgentState)objectArray[1];
                    AgentState agentState2 = (AgentState)objectArray[2];
                    if (!agentState2.equals("suspended")) break block13;
                    try {
                        AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
                        try {
                            agentManagementSlice.suspendedAgent(aID);
                            break block12;
                        }
                        catch (IMTPException iMTPException) {
                            agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                            agentManagementSlice.suspendedAgent(aID);
                        }
                    }
                    catch (IMTPException iMTPException) {
                        iMTPException.printStackTrace();
                    }
                    catch (NotFoundException notFoundException) {
                        notFoundException.printStackTrace();
                    }
                    catch (ServiceException serviceException) {
                        serviceException.printStackTrace();
                    }
                    break block12;
                }
                if (!agentState.equals("suspended")) break block12;
                try {
                    AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        agentManagementSlice.resumedAgent(aID);
                    }
                    catch (IMTPException iMTPException) {
                        agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                        agentManagementSlice.resumedAgent(aID);
                    }
                }
                catch (IMTPException iMTPException) {
                    iMTPException.printStackTrace();
                }
                catch (NotFoundException notFoundException) {
                    notFoundException.printStackTrace();
                }
                catch (ServiceException serviceException) {
                    serviceException.printStackTrace();
                }
            }
        }

        private void handleKillContainer(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException {
            block4: {
                Object[] objectArray = verticalCommand.getParams();
                ContainerID containerID = (ContainerID)objectArray[0];
                if (AgentManagementService.this.logger.isLoggable(Logger.CONFIG)) {
                    AgentManagementService.this.logger.log(Logger.CONFIG, "Source Sink consuming command KILL_CONTAINER. Container is " + containerID.getName());
                }
                AgentManagementSlice agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getSlice(containerID.getName());
                try {
                    if (agentManagementSlice != null) {
                        agentManagementSlice.exitContainer();
                    }
                }
                catch (IMTPException iMTPException) {
                    agentManagementSlice = (AgentManagementSlice)AgentManagementService.this.getFreshSlice(containerID.getName());
                    if (agentManagementSlice == null) break block4;
                    agentManagementSlice.exitContainer();
                }
            }
        }

        private void handleAddTool(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.toolAdded(aID);
            }
        }

        private void handleRemoveTool(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            MainContainer mainContainer = AgentManagementService.this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.toolRemoved(aID);
            }
        }
    }
}

