/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.PersistentDeliveryFilter;
import jade.core.messaging.PersistentDeliveryManager;
import jade.core.messaging.PersistentDeliverySlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.io.IOException;

public class PersistentDeliveryService
extends BaseService {
    public static final String PERSISTENT_DELIVERY_FILTER = "persistent-delivery-filter";
    public static final String PERSISTENT_DELIVERY_SENDFAILUREPERIOD = "persistent-delivery-sendfailureperiod";
    public static final String PERSISTENT_DELIVERY_STORAGEMETHOD = "persistent-delivery-storagemethod";
    public static final String PERSISTENT_DELIVERY_BASEDIR = "persistent-delivery-basedir";
    static final String ACL_USERDEF_DUE_DATE = "JADE-persistentdelivery-duedate";
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private static final String[] OWNED_COMMANDS = new String[0];
    private AgentContainer myContainer;
    private ServiceFinder myServiceFinder;
    private PersistentDeliveryManager myManager;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandOutgoingFilter outFilter = new CommandOutgoingFilter();
    private final CommandIncomingFilter inFilter = new CommandIncomingFilter();
    private PersistentDeliveryFilter messageFilter;

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myContainer = agentContainer;
        this.myServiceFinder = this.myContainer.getServiceFinder();
        try {
            MessageManager.Channel channel = (MessageManager.Channel)((Object)this.myServiceFinder.findService("jade.core.messaging.Messaging"));
            this.myManager = PersistentDeliveryManager.instance(profile, channel);
            this.myManager.start();
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
    }

    public String getName() {
        return "jade.core.messaging.PersistentDelivery";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.messaging.PersistentDeliverySlice");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        if (!bl) {
            return this.inFilter;
        }
        return this.outFilter;
    }

    public Sink getCommandSink(boolean bl) {
        return null;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile profile) throws ServiceException {
        try {
            String string = profile.getParameter(PERSISTENT_DELIVERY_FILTER, null);
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                this.messageFilter = (PersistentDeliveryFilter)clazz.newInstance();
                this.logger.log(Logger.INFO, "Using message filter of type " + this.messageFilter.getClass().getName());
            }
        }
        catch (Exception exception) {
            throw new ServiceException("Exception in message filter initialization", exception);
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return PersistentDeliveryService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return PersistentDeliveryService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            VerticalCommand verticalCommand = null;
            try {
                String string = horizontalCommand.getName();
                Object[] objectArray = horizontalCommand.getParams();
                if (string.equals("5")) {
                    String string2 = (String)objectArray[0];
                    ACLMessage aCLMessage = (ACLMessage)objectArray[1];
                    Envelope envelope = (Envelope)objectArray[2];
                    byte[] byArray = (byte[])objectArray[3];
                    GenericMessage genericMessage = new GenericMessage();
                    genericMessage.update(aCLMessage, envelope, byArray);
                    AID aID = (AID)objectArray[4];
                    boolean bl = this.storeMessage(string2, genericMessage, aID);
                    horizontalCommand.setReturnValue(new Boolean(bl));
                } else if (string.equals("6")) {
                    AID aID = (AID)objectArray[0];
                    this.flushMessages(aID);
                }
            }
            catch (Throwable throwable) {
                horizontalCommand.setReturnValue(throwable);
            }
            return verticalCommand;
        }

        private boolean storeMessage(String string, GenericMessage genericMessage, AID aID) throws IMTPException, ServiceException {
            if (PersistentDeliveryService.this.messageFilter != null) {
                long l;
                long l2;
                boolean bl;
                block10: {
                    bl = false;
                    l = l2 = System.currentTimeMillis();
                    try {
                        String string2 = genericMessage.getACLMessage().getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE);
                        l = Long.parseLong(string2);
                    }
                    catch (Exception exception) {
                        long l3 = PersistentDeliveryService.this.messageFilter.delayBeforeExpiration(genericMessage.getACLMessage());
                        if (l3 == 0L) break block10;
                        l = l3 == -1L ? l3 : l2 + l3;
                        genericMessage.getACLMessage().addUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE, String.valueOf(l));
                        bl = true;
                    }
                }
                if (l > l2 || l == -1L) {
                    try {
                        if (bl) {
                            if (PersistentDeliveryService.this.logger.isLoggable(Logger.INFO)) {
                                PersistentDeliveryService.this.logger.log(Logger.INFO, "Storing message\n" + MessageManager.stringify(genericMessage) + " for agent " + aID.getName() + "\nDue date is " + l);
                            }
                        } else if (PersistentDeliveryService.this.logger.isLoggable(Logger.FINE)) {
                            PersistentDeliveryService.this.logger.log(Logger.FINE, "Re-storing message\n" + MessageManager.stringify(genericMessage) + " for agent " + aID.getName() + "\nDue date is " + l);
                        }
                        PersistentDeliveryService.this.myManager.storeMessage(string, genericMessage, aID);
                        return true;
                    }
                    catch (IOException iOException) {
                        throw new ServiceException("I/O Error in message storage", iOException);
                    }
                }
            }
            return false;
        }

        private void flushMessages(AID aID) {
            int n = PersistentDeliveryService.this.myManager.flushMessages(aID);
            if (n > 0) {
                PersistentDeliveryService.this.logger.log(Logger.INFO, "Delivered " + n + " messages to agent " + aID);
            }
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        public void postProcess(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Inform-Created")) {
                    this.handleInformCreated(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                verticalCommand.setReturnValue(iMTPException);
            }
            catch (ServiceException serviceException) {
                verticalCommand.setReturnValue(serviceException);
            }
        }

        private void handleInformCreated(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            final AID aID = (AID)objectArray[0];
            Thread thread = new Thread(){

                public void run() {
                    try {
                        Service.Slice[] sliceArray = PersistentDeliveryService.this.getAllSlices();
                        int n = 0;
                        while (n < sliceArray.length) {
                            PersistentDeliverySlice persistentDeliverySlice = (PersistentDeliverySlice)sliceArray[n];
                            try {
                                persistentDeliverySlice.flushMessages(aID);
                            }
                            catch (Exception exception) {
                                PersistentDeliveryService.this.logger.log(Logger.WARNING, "Error trying to flush messages for agent " + aID.getName() + " on node " + persistentDeliverySlice.getNode().getName());
                            }
                            ++n;
                        }
                    }
                    catch (ServiceException serviceException) {
                        serviceException.printStackTrace();
                    }
                }
            };
            thread.start();
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        public boolean accept(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Notify-Failure")) {
                    return this.handleNotifyFailure(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                verticalCommand.setReturnValue(iMTPException);
            }
            catch (ServiceException serviceException) {
                verticalCommand.setReturnValue(serviceException);
            }
            return true;
        }

        private boolean handleNotifyFailure(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            GenericMessage genericMessage = (GenericMessage)objectArray[0];
            AID aID = (AID)objectArray[1];
            ACLMessage aCLMessage = genericMessage.getACLMessage();
            if (PersistentDeliveryService.this.logger.isLoggable(Logger.FINE)) {
                PersistentDeliveryService.this.logger.log(Logger.FINE, "Processing failed message " + MessageManager.stringify(genericMessage) + " for agent " + aID.getName());
            }
            Service.Slice[] sliceArray = PersistentDeliveryService.this.getAllSlices();
            int n = 0;
            while (n < sliceArray.length) {
                PersistentDeliverySlice persistentDeliverySlice = (PersistentDeliverySlice)sliceArray[n];
                try {
                    boolean bl = aCLMessage.getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE) == null;
                    boolean bl2 = false;
                    try {
                        bl2 = persistentDeliverySlice.storeMessage(null, genericMessage, aID);
                    }
                    catch (IMTPException iMTPException) {
                        persistentDeliverySlice = (PersistentDeliverySlice)PersistentDeliveryService.this.getFreshSlice(persistentDeliverySlice.getNode().getName());
                        bl2 = persistentDeliverySlice.storeMessage(null, genericMessage, aID);
                    }
                    if (bl2) {
                        PersistentDeliveryService.this.logger.log(bl ? Logger.INFO : Logger.FINE, "Message " + MessageManager.stringify(genericMessage) + " for agent " + aID.getName() + " stored on node " + persistentDeliverySlice.getNode().getName());
                        return false;
                    }
                }
                catch (Exception exception) {
                    PersistentDeliveryService.this.logger.log(Logger.WARNING, "Error trying to store message " + MessageManager.stringify(genericMessage) + " for agent " + aID.getName() + " on node " + persistentDeliverySlice.getNode().getName());
                }
                ++n;
            }
            return true;
        }
    }
}

