/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.nodeMonitoring.UDPMonitorServer;
import jade.util.Logger;
import jade.util.leap.Collection;

class UDPNodeFailureMonitor
extends NodeFailureMonitor {
    public static final int STATE_CONNECTED = 0;
    public static final int STATE_UNREACHABLE = 1;
    public static final int STATE_FINAL = 2;
    private long deadline = -1L;
    private long lastPing = -1L;
    private int state = -1;
    private UDPMonitorServer server;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public UDPNodeFailureMonitor(UDPMonitorServer uDPMonitorServer) {
        this.server = uDPMonitorServer;
    }

    public void start(Node node, NodeEventListener nodeEventListener) {
        super.start(node, nodeEventListener);
        this.setState(0);
        this.server.register(this);
    }

    public void stop() {
        this.server.deregister(this);
    }

    public Collection getChildNodes() {
        return this.childNodes;
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public int getState() {
        return this.state;
    }

    void setState(int n) {
        if (this.logger.isLoggable(Logger.FINEST)) {
            this.logger.log(Logger.FINEST, "Transition to state " + n + " for node '" + this.target.getName() + "'");
        }
        if (this.state == -1 && n == 0) {
            this.fireNodeAdded();
        } else if (this.state == 0 && n == 1) {
            this.fireNodeUnreachable();
        } else if (this.state == 1 && n == 0) {
            this.fireNodeReachable();
        } else if (n == 2) {
            this.fireNodeRemoved();
            this.server.deregister(this);
        }
        this.state = n;
    }

    void setLastPing(long l) {
        this.lastPing = l;
    }

    void setDeadline(long l) {
        this.deadline = l;
    }
}

