/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.RequestFIPAServiceBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

public class AMSService
extends FIPAService {
    private static Codec c = new SLCodec();
    private static Ontology o = FIPAManagementOntology.getInstance();
    private static ContentManager cm = new ContentManager();

    static void checkIsValid(AMSAgentDescription aMSAgentDescription) throws MissingParameter {
        if (aMSAgentDescription.getName() == null) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        if (aMSAgentDescription.getState() == null) {
            throw new MissingParameter("ams-agent-description", "state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Agent agent, AID aID, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        if (aMSAgentDescription.getName() == null) {
            aMSAgentDescription.setName(agent.getAID());
        }
        if (aMSAgentDescription.getState() == null) {
            aMSAgentDescription.setState("active");
        }
        AMSService.checkIsValid(aMSAgentDescription);
        Register register = new Register();
        register.setDescription(aMSAgentDescription);
        Action action = new Action();
        action.setActor(aID);
        action.setAction(register);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(aCLMessage, action);
            }
            catch (Exception exception) {
                throw new FIPAException("Error encoding REQUEST content. " + exception);
            }
        }
        FIPAService.doFipaRequestClient(agent, aCLMessage);
    }

    public static void register(Agent agent, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        AMSService.register(agent, agent.getAMS(), aMSAgentDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregister(Agent agent, AID aID, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        if (aMSAgentDescription.getName() == null) {
            aMSAgentDescription.setName(agent.getAID());
        }
        if (aMSAgentDescription.getState() == null) {
            aMSAgentDescription.setState("active");
        }
        Deregister deregister = new Deregister();
        deregister.setDescription(aMSAgentDescription);
        Action action = new Action();
        action.setActor(aID);
        action.setAction(deregister);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(aCLMessage, action);
            }
            catch (Exception exception) {
                throw new FIPAException("Error encoding REQUEST content. " + exception);
            }
        }
        FIPAService.doFipaRequestClient(agent, aCLMessage);
    }

    public static void deregister(Agent agent, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        AMSService.deregister(agent, agent.getAMS(), aMSAgentDescription);
    }

    public static void deregister(Agent agent, AID aID) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(agent.getAID());
        AMSService.deregister(agent, aID, aMSAgentDescription);
    }

    public static void deregister(Agent agent) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(agent.getAID());
        AMSService.deregister(agent, aMSAgentDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modify(Agent agent, AID aID, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        if (aMSAgentDescription.getName() == null) {
            aMSAgentDescription.setName(agent.getAID());
        }
        AMSService.checkIsValid(aMSAgentDescription);
        Modify modify = new Modify();
        modify.setDescription(aMSAgentDescription);
        Action action = new Action();
        action.setActor(aID);
        action.setAction(modify);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(aCLMessage, action);
            }
            catch (Exception exception) {
                throw new FIPAException("Error encoding REQUEST content. " + exception);
            }
        }
        FIPAService.doFipaRequestClient(agent, aCLMessage);
    }

    public static void modify(Agent agent, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        AMSService.modify(agent, agent.getAMS(), aMSAgentDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMSAgentDescription[] search(Agent agent, AID aID, AMSAgentDescription aMSAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        Search search = new Search();
        search.setDescription(aMSAgentDescription);
        search.setConstraints(searchConstraints);
        Action action = new Action();
        action.setActor(aID);
        action.setAction(search);
        ContentManager contentManager = cm;
        synchronized (contentManager) {
            try {
                cm.fillContent(aCLMessage, action);
            }
            catch (Exception exception) {
                throw new FIPAException("Error encoding REQUEST content. " + exception);
            }
        }
        ACLMessage aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage);
        Result result = null;
        ContentManager contentManager2 = cm;
        synchronized (contentManager2) {
            try {
                result = (Result)cm.extractContent(aCLMessage2);
            }
            catch (Exception exception) {
                throw new FIPAException("Error decoding INFORM content. " + exception);
            }
        }
        return AMSService.toArray(result.getItems());
    }

    private static AMSAgentDescription[] toArray(List list) throws FIPAException {
        try {
            AMSAgentDescription[] aMSAgentDescriptionArray = new AMSAgentDescription[list.size()];
            int n = 0;
            while (n < list.size()) {
                aMSAgentDescriptionArray[n] = (AMSAgentDescription)list.get(n);
                ++n;
            }
            return aMSAgentDescriptionArray;
        }
        catch (ClassCastException classCastException) {
            throw new FIPAException("Found items are not AMSAgentDescriptions. " + classCastException);
        }
    }

    public static AMSAgentDescription[] search(Agent agent, AMSAgentDescription aMSAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return AMSService.search(agent, agent.getAMS(), aMSAgentDescription, searchConstraints);
    }

    public static AMSAgentDescription[] search(Agent agent, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.search(agent, agent.getAMS(), aMSAgentDescription, searchConstraints);
    }

    public static AMSAgentDescription[] search(Agent agent, AID aID, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.search(agent, aID, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string, AMSAgentDescription aMSAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return new RequestFIPAServiceBehaviour(agent, aID, string, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string, AMSAgentDescription aMSAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return AMSService.getNonBlockingBehaviour(agent, agent.getAMS(), string, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(agent.getAID());
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(agent, agent.getAMS(), string, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setName(agent.getAID());
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(agent, aID, string, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(agent, agent.getAMS(), string, aMSAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string, AMSAgentDescription aMSAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        return AMSService.getNonBlockingBehaviour(agent, aID, string, aMSAgentDescription, searchConstraints);
    }

    public static AID getFailedReceiver(Agent agent, ACLMessage aCLMessage) throws FIPAException {
        if (aCLMessage.getPerformative() != 6 || !aCLMessage.getSender().equals(agent.getAMS())) {
            throw new FIPAException("Invalid AMS FAILURE message");
        }
        try {
            String string = aCLMessage.getContent();
            int n = string.indexOf("MTS-error");
            n = string.indexOf("agent-identifier", n);
            SimpleSLTokenizer simpleSLTokenizer = new SimpleSLTokenizer(string.substring(n));
            return AMSService.parseAID(simpleSLTokenizer);
        }
        catch (Exception exception) {
            throw new FIPAException("Invalid content. " + exception);
        }
    }

    private static AID parseAID(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        AID aID = new AID("", true);
        simpleSLTokenizer.getElement();
        while (simpleSLTokenizer.nextToken().startsWith(":")) {
            Iterator iterator;
            String string = simpleSLTokenizer.getElement();
            if (string.equals("name")) {
                aID.setName(simpleSLTokenizer.getElement());
                continue;
            }
            if (string.equals("addresses")) {
                iterator = AMSService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    aID.addAddresses((String)iterator.next());
                }
                continue;
            }
            if (!string.equals("resolvers")) continue;
            iterator = AMSService.parseAggregate(simpleSLTokenizer).iterator();
            while (iterator.hasNext()) {
                aID.addResolvers((AID)iterator.next());
            }
        }
        simpleSLTokenizer.consumeChar(')');
        return aID;
    }

    private static List parseAggregate(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        ArrayList arrayList = new ArrayList();
        simpleSLTokenizer.consumeChar('(');
        simpleSLTokenizer.getElement();
        String string = simpleSLTokenizer.nextToken();
        while (!string.startsWith(")")) {
            if (!string.startsWith("(")) {
                arrayList.add(simpleSLTokenizer.getElement());
            } else {
                simpleSLTokenizer.consumeChar('(');
                string = simpleSLTokenizer.nextToken();
                if (string.equals("agent-identifier")) {
                    arrayList.add(AMSService.parseAID(simpleSLTokenizer));
                }
            }
            string = simpleSLTokenizer.nextToken();
        }
        simpleSLTokenizer.consumeChar(')');
        return arrayList;
    }

    static {
        cm.registerLanguage(c, "fipa-sl0");
        cm.registerOntology(o);
    }
}

