/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Result;
import jade.domain.DFGUIManagement.DeregisterFrom;
import jade.domain.DFGUIManagement.Federate;
import jade.domain.DFGUIManagement.GetDescription;
import jade.domain.DFGUIManagement.GetDescriptionUsed;
import jade.domain.DFGUIManagement.GetParents;
import jade.domain.DFGUIManagement.ModifyOn;
import jade.domain.DFGUIManagement.RegisterWith;
import jade.domain.DFGUIManagement.SearchOn;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.domain.RequestManagementBehaviour;
import jade.domain.df;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.leap.List;

class DFAppletManagementBehaviour
extends RequestManagementBehaviour {
    private df theDF;

    protected DFAppletManagementBehaviour(df df2, MessageTemplate messageTemplate) {
        super(df2, messageTemplate);
        this.theDF = df2;
    }

    protected ACLMessage performAction(Action action, ACLMessage aCLMessage) throws JADESecurityException, FIPAException {
        Concept concept = action.getAction();
        List list = null;
        boolean bl = false;
        if (concept instanceof GetParents) {
            list = this.theDF.getParentsAction((GetParents)concept, aCLMessage.getSender());
        } else if (concept instanceof GetDescription) {
            list = this.theDF.getDescriptionAction((GetDescription)concept, aCLMessage.getSender());
        } else if (concept instanceof GetDescriptionUsed) {
            list = this.theDF.getDescriptionUsedAction((GetDescriptionUsed)concept, aCLMessage.getSender());
        } else if (concept instanceof Federate) {
            this.theDF.federateAction((Federate)concept, aCLMessage.getSender());
            bl = true;
        } else if (concept instanceof RegisterWith) {
            this.theDF.registerWithAction((RegisterWith)concept, aCLMessage.getSender());
            bl = true;
        } else if (concept instanceof DeregisterFrom) {
            this.theDF.deregisterFromAction((DeregisterFrom)concept, aCLMessage.getSender());
            bl = true;
        } else if (concept instanceof ModifyOn) {
            this.theDF.modifyOnAction((ModifyOn)concept, aCLMessage.getSender());
            bl = true;
        } else if (concept instanceof SearchOn) {
            this.theDF.searchOnAction((SearchOn)concept, aCLMessage.getSender());
            bl = true;
        } else {
            throw new UnsupportedFunction();
        }
        if (!bl) {
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(7);
            Predicate predicate = null;
            predicate = list != null ? new Result(action, list) : new Done(action);
            try {
                this.theDF.getContentManager().fillContent(aCLMessage2, predicate);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return aCLMessage2;
        }
        this.theDF.storePendingRequest(concept, aCLMessage);
        return null;
    }
}

