/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.FIPAAgentManagement;

import jade.content.Concept;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.util.Date;

public class Envelope
implements Concept,
Serializable {
    private static final int EXPECTED_LIST_SIZE = 2;
    private ArrayList to = new ArrayList(2);
    private AID from;
    private String comments;
    private String aclRepresentation;
    private Long payloadLength;
    private String payloadEncoding;
    private Date date;
    private ArrayList intendedReceiver = new ArrayList(2);
    private Properties transportBehaviour;
    private ArrayList stamps = new ArrayList(2);
    private ArrayList properties = new ArrayList(2);

    public Envelope() {
        this.payloadLength = new Long(-1L);
    }

    public void addTo(AID aID) {
        this.to.add(aID);
    }

    public boolean removeTo(AID aID) {
        return this.to.remove(aID);
    }

    public void clearAllTo() {
        this.to.clear();
    }

    public Iterator getAllTo() {
        return this.to.iterator();
    }

    public void setFrom(AID aID) {
        this.from = aID;
    }

    public AID getFrom() {
        return this.from;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getComments() {
        return this.comments;
    }

    public void setAclRepresentation(String string) {
        this.aclRepresentation = string;
    }

    public String getAclRepresentation() {
        return this.aclRepresentation;
    }

    public void setPayloadLength(Long l) {
        this.payloadLength = l;
    }

    public Long getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadEncoding(String string) {
        this.payloadEncoding = string;
    }

    public String getPayloadEncoding() {
        return this.payloadEncoding;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void addIntendedReceiver(AID aID) {
        this.intendedReceiver.add(aID);
    }

    public boolean removeIntendedReceiver(AID aID) {
        return this.intendedReceiver.remove(aID);
    }

    public void clearAllIntendedReceiver() {
        this.intendedReceiver.clear();
    }

    public Iterator getAllIntendedReceiver() {
        return this.intendedReceiver.iterator();
    }

    public void setReceived(ReceivedObject receivedObject) {
        this.addStamp(receivedObject);
    }

    public ReceivedObject getReceived() {
        if (this.stamps.isEmpty()) {
            return null;
        }
        return (ReceivedObject)this.stamps.get(this.stamps.size() - 1);
    }

    public void addStamp(ReceivedObject receivedObject) {
        this.stamps.add(receivedObject);
    }

    public ReceivedObject[] getStamps() {
        ReceivedObject[] receivedObjectArray = new ReceivedObject[this.stamps.size()];
        int n = 0;
        Iterator iterator = this.stamps.iterator();
        while (iterator.hasNext()) {
            receivedObjectArray[n++] = (ReceivedObject)iterator.next();
        }
        return receivedObjectArray;
    }

    public void addProperties(Property property) {
        this.properties.add(property);
    }

    public boolean removeProperties(Property property) {
        return this.properties.remove(property);
    }

    public void clearAllProperties() {
        this.properties.clear();
    }

    public Iterator getAllProperties() {
        return this.properties.iterator();
    }

    public String toString() {
        int n;
        ReceivedObject[] receivedObjectArray;
        String string = new String("(Envelope ");
        ReceivedObject[] receivedObjectArray2 = this.getAllTo();
        if (receivedObjectArray2.hasNext()) {
            string = string + " :to (sequence ";
            receivedObjectArray = receivedObjectArray2;
            while (receivedObjectArray.hasNext()) {
                string = string + " " + receivedObjectArray.next().toString();
            }
            string = string + ") ";
        }
        if (this.getFrom() != null) {
            string = string + " :from " + this.getFrom().toString();
        }
        if (this.getComments() != null) {
            string = string + " :comments " + this.getComments();
        }
        if (this.getAclRepresentation() != null) {
            string = string + " :acl-representation " + this.getAclRepresentation();
        }
        if (this.getPayloadLength() != null) {
            string = string + " :payload-length " + this.getPayloadLength().toString();
        }
        if (this.getPayloadEncoding() != null) {
            string = string + " :payload-encoding " + this.getPayloadEncoding();
        }
        if (this.getDate() != null) {
            string = string + " :date " + this.getDate().toString();
        }
        if ((receivedObjectArray2 = this.getAllIntendedReceiver()).hasNext()) {
            string = string + " :intended-receiver (sequence ";
            receivedObjectArray = receivedObjectArray2;
            while (receivedObjectArray.hasNext()) {
                string = string + " " + receivedObjectArray.next().toString();
            }
            string = string + ") ";
        }
        if ((receivedObjectArray = this.getStamps()).length > 0) {
            string = string + " :received-object (sequence ";
            n = 0;
            while (n < receivedObjectArray.length) {
                if (receivedObjectArray[n] != null) {
                    string = string + " " + receivedObjectArray[n].toString();
                }
                ++n;
            }
            string = string + ") ";
        }
        if (this.properties.size() > 0) {
            string = string + " :properties (set";
            n = 0;
            while (n < this.properties.size()) {
                Property property = (Property)this.properties.get(n);
                string = string + " " + property.getName() + " " + property.getValue();
                ++n;
            }
            string = string + ")";
        }
        return string + ")";
    }

    public Object clone() {
        Envelope envelope = new Envelope();
        envelope.to = new ArrayList(this.to.size());
        int n = 0;
        while (n < this.to.size()) {
            AID aID = (AID)this.to.get(n);
            envelope.to.add(aID.clone());
            ++n;
        }
        envelope.intendedReceiver = new ArrayList(this.intendedReceiver.size());
        int n2 = 0;
        while (n2 < this.intendedReceiver.size()) {
            AID aID = (AID)this.intendedReceiver.get(n2);
            envelope.intendedReceiver.add(aID.clone());
            ++n2;
        }
        envelope.stamps = (ArrayList)this.stamps.clone();
        if (this.from != null) {
            envelope.from = (AID)this.from.clone();
        }
        envelope.comments = this.comments;
        envelope.aclRepresentation = this.aclRepresentation;
        envelope.payloadLength = this.payloadLength;
        envelope.payloadEncoding = this.payloadEncoding;
        envelope.date = this.date;
        envelope.transportBehaviour = this.transportBehaviour;
        envelope.properties = (ArrayList)this.properties.clone();
        return envelope;
    }

    private void setTo(ArrayList arrayList) {
        this.to = arrayList;
    }

    private ArrayList getTo() {
        return this.to;
    }

    private void setIntendedReceivers(ArrayList arrayList) {
        this.intendedReceiver = arrayList;
    }

    private ArrayList getIntendedReceivers() {
        return this.intendedReceiver;
    }

    private void setProperties(ArrayList arrayList) {
        this.properties = arrayList;
    }

    private ArrayList getProperties() {
        return this.properties;
    }
}

