/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601 {
    private static Calendar localCal = Calendar.getInstance();
    private static Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static char plus = (char)43;
    private static char minus = (char)45;
    private static String z = "Z";
    private static char t = (char)84;
    private static final long year = 31536000000L;
    private static final long month = 2592000000L;
    private static final long day = 86400000L;
    private static final long hour = 3600000L;
    private static final long minute = 60000L;
    private static final long sec = 1000L;

    private static Date parseutcDateFormat(String string) throws Exception {
        ISO8601.subparse(utcCal, string);
        return utcCal.getTime();
    }

    private static Date parselocalDateFormat(String string) throws Exception {
        ISO8601.subparse(localCal, string);
        return localCal.getTime();
    }

    private static void subparse(Calendar calendar, String string) {
        calendar.set(1, Integer.parseInt(string.substring(0, 4)));
        calendar.set(2, Integer.parseInt(string.substring(4, 6)) - 1);
        calendar.set(5, Integer.parseInt(string.substring(6, 8)));
        calendar.set(11, Integer.parseInt(string.substring(9, 11)));
        calendar.set(12, Integer.parseInt(string.substring(11, 13)));
        calendar.set(13, Integer.parseInt(string.substring(13, 15)));
        calendar.set(14, Integer.parseInt(string.substring(15, 18)));
    }

    private static String formatlocalDate(Date date) {
        localCal.setTime(date);
        return ISO8601.subFormatDate(localCal);
    }

    private static String formatutcDate(Date date) {
        utcCal.setTime(date);
        return ISO8601.subFormatDate(utcCal) + z;
    }

    private static String subFormatDate(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(1), 4));
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(2) + 1, 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(5), 2));
        stringBuffer.append(t);
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(11), 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(12), 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(13), 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(calendar.get(14), 3));
        return stringBuffer.toString();
    }

    public static synchronized Date toDate(String string) throws Exception {
        if (string == null) {
            return new Date();
        }
        char c = string.charAt(0);
        if (c == plus || c == minus) {
            long l = Long.parseLong(string.substring(1, 5)) * 31536000000L + Long.parseLong(string.substring(5, 7)) * 2592000000L + Long.parseLong(string.substring(7, 9)) * 86400000L + Long.parseLong(string.substring(10, 12)) * 3600000L + Long.parseLong(string.substring(12, 14)) * 60000L + Long.parseLong(string.substring(14, 16)) * 1000L;
            System.out.println("sign=" + c + " millisec=" + l);
            System.out.println("31536000000 2592000000 86400000 3600000");
            System.out.println("currentTime=" + System.currentTimeMillis());
            l = System.currentTimeMillis() + (c == plus ? l : -l);
            return new Date(l);
        }
        if (string.endsWith(z)) {
            return ISO8601.parseutcDateFormat(string);
        }
        return ISO8601.parselocalDateFormat(string);
    }

    public static synchronized String toString(Date date, boolean bl) {
        if (bl) {
            return ISO8601.formatutcDate(date);
        }
        return ISO8601.formatlocalDate(date);
    }

    public static String toString(Date date) {
        return ISO8601.toString(date, true);
    }

    public static String toRelativeTimeString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l > 0L) {
            stringBuffer.append(plus);
        } else {
            stringBuffer.append(minus);
            l = -l;
        }
        long l2 = l / 1000L;
        long l3 = l - l2 * 1000L;
        l = l2;
        l2 = l / 60L;
        long l4 = l - l2 * 60L;
        l = l2;
        l2 = l / 60L;
        long l5 = l - l2 * 60L;
        l = l2;
        l2 = l / 24L;
        long l6 = l - l2 * 24L;
        l = l2;
        l2 = l / 30L;
        long l7 = l - l2 * 30L;
        l = l2;
        l2 = l / 12L;
        long l8 = l - l2 * 12L;
        long l9 = l = l2;
        stringBuffer.append(ISO8601.zeroPaddingNumber(l9, 4));
        stringBuffer.append(ISO8601.zeroPaddingNumber(l8, 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(l7, 2));
        stringBuffer.append(t);
        stringBuffer.append(ISO8601.zeroPaddingNumber(l6, 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(l5, 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(l4, 2));
        stringBuffer.append(ISO8601.zeroPaddingNumber(l3, 3));
        return stringBuffer.toString();
    }

    private static String zeroPaddingNumber(long l, int n) {
        String string = Long.toString(l);
        int n2 = n - string.length();
        int n3 = 0;
        while (n3 < n2) {
            string = "0" + string;
            ++n3;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Date date;
        System.out.println(localCal);
        System.out.println("USAGE: java ISO8601 DateTimetoken");
        System.out.println(stringArray[0]);
        try {
            System.out.println("Testing default behaviour (using UTC DateTime):");
            System.out.println("  ISO8601.toDate(" + stringArray[0] + ") returns:" + ISO8601.toDate(stringArray[0]));
            System.out.println("  converting that back to a string gives:" + ISO8601.toString(ISO8601.toDate(stringArray[0])));
            date = new Date();
            System.out.println("  ISO8601.toString( new Date() ) returns:" + ISO8601.toString(date));
            System.out.println("  converting that back to a date gives:" + ISO8601.toDate(ISO8601.toString(date)));
            System.out.println("Testing local time (for backwards compatability):");
            System.out.println("  ISO8601.toDate(" + stringArray[0] + ") returns:" + ISO8601.toDate(stringArray[0]));
            System.out.println("  converting that back to a string gives:" + ISO8601.toString(ISO8601.toDate(stringArray[0]), false));
            System.out.println("  ISO8601.toString( new Date(), false ) returns:" + ISO8601.toString(date, false));
            System.out.println("  converting that back to a date gives:" + ISO8601.toDate(ISO8601.toString(date, false)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.out.println("ISO8601.toRelativeTimeString(" + stringArray[0] + ") returns:" + ISO8601.toRelativeTimeString(Long.parseLong(stringArray[0])));
            date = new Date(Integer.parseInt(stringArray[0]));
            System.out.println("ISO8601.toString(" + date + ", false) returns:" + ISO8601.toString(date, false));
        }
        catch (Exception exception) {}
    }
}

