/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Hashtable;

public class SubscriptionResponder
extends FSMBehaviour
implements FIPANames.InteractionProtocol {
    public final String SUBSCRIPTION_KEY;
    public final String CANCEL_KEY;
    public final String RESPONSE_KEY;
    private static final String RECEIVE_SUBSCRIPTION = "Receive-subscription";
    private static final String PREPARE_RESPONSE = "Prepare-response";
    private static final String HANDLE_CANCEL = "Handle-cancel";
    private static final String SEND_RESPONSE = "Send-response";
    private static final String SEND_NOTIFICATIONS = "Send-notifications";
    private MsgReceiver msgRecBehaviour;
    private Hashtable subscriptions;
    private List notifications;
    protected SubscriptionManager mySubscriptionManager;

    public static MessageTemplate createMessageTemplate(int n) {
        return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-subscribe"), MessageTemplate.or(MessageTemplate.MatchPerformative(n), MessageTemplate.MatchPerformative(2)));
    }

    public SubscriptionResponder(Agent agent, MessageTemplate messageTemplate, SubscriptionManager subscriptionManager) {
        this(agent, messageTemplate, subscriptionManager, new DataStore());
    }

    public SubscriptionResponder(Agent agent, MessageTemplate messageTemplate, SubscriptionManager subscriptionManager, DataStore dataStore) {
        super(agent);
        this.CANCEL_KEY = this.SUBSCRIPTION_KEY = "__subs_canc" + this.hashCode();
        this.RESPONSE_KEY = "__response" + this.hashCode();
        this.msgRecBehaviour = null;
        this.subscriptions = new Hashtable();
        this.notifications = new ArrayList();
        this.mySubscriptionManager = null;
        this.setDataStore(dataStore);
        this.mySubscriptionManager = subscriptionManager;
        this.registerDefaultTransition(RECEIVE_SUBSCRIPTION, PREPARE_RESPONSE);
        this.registerTransition(RECEIVE_SUBSCRIPTION, HANDLE_CANCEL, 2);
        this.registerTransition(RECEIVE_SUBSCRIPTION, SEND_NOTIFICATIONS, -1002);
        this.registerDefaultTransition(PREPARE_RESPONSE, SEND_RESPONSE);
        this.registerDefaultTransition(HANDLE_CANCEL, SEND_RESPONSE);
        this.registerDefaultTransition(SEND_RESPONSE, RECEIVE_SUBSCRIPTION, new String[]{PREPARE_RESPONSE, HANDLE_CANCEL});
        this.registerDefaultTransition(SEND_NOTIFICATIONS, RECEIVE_SUBSCRIPTION);
        OneShotBehaviour oneShotBehaviour = null;
        this.msgRecBehaviour = new MsgReceiver(this.myAgent, messageTemplate, -1L, this.getDataStore(), this.SUBSCRIPTION_KEY);
        this.registerFirstState(this.msgRecBehaviour, RECEIVE_SUBSCRIPTION);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(SubscriptionResponder.this.SUBSCRIPTION_KEY);
                ACLMessage aCLMessage2 = null;
                try {
                    aCLMessage2 = SubscriptionResponder.this.prepareResponse(aCLMessage);
                }
                catch (NotUnderstoodException notUnderstoodException) {
                    aCLMessage2 = notUnderstoodException.getACLMessage();
                }
                catch (RefuseException refuseException) {
                    aCLMessage2 = refuseException.getACLMessage();
                }
                dataStore.put(SubscriptionResponder.this.RESPONSE_KEY, aCLMessage2);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, PREPARE_RESPONSE);
        oneShotBehaviour = new ReplySender(this.myAgent, this.RESPONSE_KEY, this.SUBSCRIPTION_KEY);
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_RESPONSE);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore dataStore = this.getDataStore();
                ACLMessage aCLMessage = (ACLMessage)dataStore.get(SubscriptionResponder.this.CANCEL_KEY);
                ACLMessage aCLMessage2 = null;
                try {
                    aCLMessage2 = SubscriptionResponder.this.handleCancel(aCLMessage);
                }
                catch (FailureException failureException) {
                    aCLMessage2 = failureException.getACLMessage();
                }
                dataStore.put(SubscriptionResponder.this.RESPONSE_KEY, aCLMessage2);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_CANCEL);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){

            public void action() {
                SubscriptionResponder.this.sendNotifications();
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, SEND_NOTIFICATIONS);
    }

    public void reset() {
        super.reset();
        DataStore dataStore = this.getDataStore();
        dataStore.remove(this.SUBSCRIPTION_KEY);
        dataStore.remove(this.RESPONSE_KEY);
    }

    public void reset(MessageTemplate messageTemplate) {
        this.reset();
        this.msgRecBehaviour.reset(messageTemplate, -1L, this.getDataStore(), this.SUBSCRIPTION_KEY);
    }

    protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
        this.mySubscriptionManager.register(this.createSubscription(aCLMessage));
        return null;
    }

    protected ACLMessage handleCancel(ACLMessage aCLMessage) throws FailureException {
        Subscription subscription = this.getSubscription(aCLMessage);
        if (subscription != null) {
            this.mySubscriptionManager.deregister(subscription);
            subscription.close();
        }
        return null;
    }

    public void registerPrepareResponse(Behaviour behaviour) {
        this.registerState(behaviour, PREPARE_RESPONSE);
        behaviour.setDataStore(this.getDataStore());
    }

    public void registerHandleCancel(Behaviour behaviour) {
        this.registerState(behaviour, HANDLE_CANCEL);
        behaviour.setDataStore(this.getDataStore());
    }

    public Subscription createSubscription(ACLMessage aCLMessage) {
        Subscription subscription = new Subscription(this, aCLMessage);
        String string = aCLMessage.getConversationId();
        if (string != null) {
            this.subscriptions.put(string, subscription);
        }
        return subscription;
    }

    public Subscription getSubscription(ACLMessage aCLMessage) {
        Subscription subscription = null;
        String string = aCLMessage.getConversationId();
        if (string != null) {
            subscription = (Subscription)this.subscriptions.get(string);
        }
        return subscription;
    }

    private synchronized void addNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) {
        ACLMessage[] aCLMessageArray = new ACLMessage[]{aCLMessage, aCLMessage2};
        this.notifications.add(aCLMessageArray);
        this.msgRecBehaviour.interrupt();
    }

    private synchronized void sendNotifications() {
        Iterator iterator = this.notifications.iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            boolean bl2 = true;
            ACLMessage[] aCLMessageArray = (ACLMessage[])iterator.next();
            if (aCLMessageArray[0].getAllReceiver().hasNext()) {
                bl = false;
            }
            if (aCLMessageArray[0].getReplyWith() != null) {
                bl2 = false;
            }
            ReplySender.adjustReply(this.myAgent, aCLMessageArray[0], aCLMessageArray[1]);
            this.myAgent.send(aCLMessageArray[0]);
            if (bl) {
                aCLMessageArray[0].clearAllReceiver();
            }
            if (!bl2) continue;
            aCLMessageArray[0].setReplyWith(null);
        }
        this.notifications.clear();
    }

    private SubscriptionResponder() {
        this.CANCEL_KEY = this.SUBSCRIPTION_KEY = "__subs_canc" + this.hashCode();
        this.RESPONSE_KEY = "__response" + this.hashCode();
        this.msgRecBehaviour = null;
        this.subscriptions = new Hashtable();
        this.notifications = new ArrayList();
        this.mySubscriptionManager = null;
    }

    public static class Subscription {
        private ACLMessage subscription;
        private SubscriptionResponder myResponder;

        private Subscription(SubscriptionResponder subscriptionResponder, ACLMessage aCLMessage) {
            this.myResponder = subscriptionResponder;
            this.subscription = aCLMessage;
        }

        public ACLMessage getMessage() {
            return this.subscription;
        }

        public void notify(ACLMessage aCLMessage) {
            this.myResponder.addNotification(aCLMessage, this.subscription);
        }

        public void close() {
            String string = this.subscription.getConversationId();
            if (string != null) {
                this.myResponder.subscriptions.remove(string);
            }
        }
    }

    public static interface SubscriptionManager {
        public boolean register(Subscription var1) throws RefuseException, NotUnderstoodException;

        public boolean deregister(Subscription var1) throws FailureException;
    }
}

