/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.Responder;

public class TwoPhResponder
extends Responder {
    private static final String RECEIVE_CFP = "Receive-Initiation";
    private static final String HANDLE_CFP = "Handle-Cfp";
    private static final String HANDLE_QUERY_IF = "Handle-Query-If";
    private static final String HANDLE_ACCEPT_PROPOSAL = "Handle-Accept";
    private static final String HANDLE_REJECT_PROPOSAL = "Handle-Reject";
    private int phase = 0;

    public TwoPhResponder(Agent agent, MessageTemplate messageTemplate) {
        this(agent, messageTemplate, new DataStore());
    }

    public TwoPhResponder(Agent agent, MessageTemplate messageTemplate, DataStore dataStore) {
        super(agent, messageTemplate, dataStore);
        this.registerTransition("Check-In-seq", HANDLE_CFP, 3);
        this.registerTransition("Check-In-seq", HANDLE_QUERY_IF, 12);
        this.registerTransition("Check-In-seq", HANDLE_ACCEPT_PROPOSAL, 0);
        this.registerTransition("Check-In-seq", HANDLE_REJECT_PROPOSAL, 15);
        this.registerDefaultTransition(HANDLE_CFP, "Send-Reply");
        this.registerDefaultTransition(HANDLE_QUERY_IF, "Send-Reply");
        this.registerDefaultTransition(HANDLE_ACCEPT_PROPOSAL, "Send-Reply");
        this.registerDefaultTransition(HANDLE_REJECT_PROPOSAL, "Send-Reply");
        this.registerTransition("Send-Reply", "Receive-Next", 11, new String[]{HANDLE_CFP});
        this.registerTransition("Send-Reply", "Receive-Next", 4);
        this.registerTransition("Send-Reply", RECEIVE_CFP, 7);
        this.registerTransition("Send-Reply", RECEIVE_CFP, 5);
        this.registerTransition("Send-Reply", RECEIVE_CFP, 6);
        this.registerTransition("Send-Reply", RECEIVE_CFP, 10);
        OneShotBehaviour oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 4487495895818001L;

            public void action() {
                ACLMessage aCLMessage = TwoPhResponder.this.handleCfp((ACLMessage)this.getDataStore().get(TwoPhResponder.this.RECEIVED_KEY));
                this.getDataStore().put(TwoPhResponder.this.REPLY_KEY, aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_CFP);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 4487495895818002L;

            public void action() {
                ACLMessage aCLMessage = TwoPhResponder.this.handleQueryIf((ACLMessage)this.getDataStore().get(TwoPhResponder.this.RECEIVED_KEY));
                this.getDataStore().put(TwoPhResponder.this.REPLY_KEY, aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_QUERY_IF);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 4487495895818003L;

            public void action() {
                ACLMessage aCLMessage = TwoPhResponder.this.handleAcceptProposal((ACLMessage)this.getDataStore().get(TwoPhResponder.this.RECEIVED_KEY));
                this.getDataStore().put(TwoPhResponder.this.REPLY_KEY, aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_ACCEPT_PROPOSAL);
        oneShotBehaviour = new OneShotBehaviour(this.myAgent){
            private static final long serialVersionUID = 4487495895818004L;

            public void action() {
                ACLMessage aCLMessage = TwoPhResponder.this.handleRejectProposal((ACLMessage)this.getDataStore().get(TwoPhResponder.this.RECEIVED_KEY));
                this.getDataStore().put(TwoPhResponder.this.REPLY_KEY, aCLMessage);
            }
        };
        oneShotBehaviour.setDataStore(this.getDataStore());
        this.registerState(oneShotBehaviour, HANDLE_REJECT_PROPOSAL);
    }

    protected ACLMessage handleCfp(ACLMessage aCLMessage) {
        return null;
    }

    protected ACLMessage handleQueryIf(ACLMessage aCLMessage) {
        return null;
    }

    protected ACLMessage handleRejectProposal(ACLMessage aCLMessage) {
        return null;
    }

    protected ACLMessage handleAcceptProposal(ACLMessage aCLMessage) {
        return null;
    }

    public void registerHandleCfp(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_CFP);
    }

    public void registerHandleQueryIf(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_QUERY_IF);
    }

    public void registerHandleRejectProposal(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_REJECT_PROPOSAL);
    }

    public void registerHandleAcceptProposal(Behaviour behaviour) {
        this.registerDSState(behaviour, HANDLE_ACCEPT_PROPOSAL);
    }

    public static MessageTemplate createMessageTemplate() {
        return MessageTemplate.and(MessageTemplate.MatchProtocol("Jade-Two-Phase-Commit"), MessageTemplate.MatchPerformative(3));
    }

    public void reset() {
        super.reset();
        this.phase = 0;
    }

    protected boolean checkInSequence(ACLMessage aCLMessage) {
        int n = aCLMessage.getPerformative();
        switch (this.phase) {
            case 0: {
                return n == 3;
            }
            case 1: {
                return n == 3 || n == 12 || n == 15;
            }
            case 2: {
                return n == 0 || n == 15;
            }
        }
        return false;
    }

    protected void replySent(int n) {
        switch (n) {
            case 11: {
                this.phase = 1;
                break;
            }
            case 4: {
                this.phase = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                this.reset();
            }
        }
    }
}

