/*
 * Decompiled with CFR 0.152.
 */
package jade.tools;

import jade.content.AgentAction;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentState;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.core.behaviours.SimpleBehaviour;
import jade.core.event.AgentEvent;
import jade.core.event.AgentListener;
import jade.core.event.JADEEvent;
import jade.core.event.MessageEvent;
import jade.core.event.MessageListener;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedBehaviour;
import jade.domain.introspection.ChangedAgentState;
import jade.domain.introspection.ChangedBehaviourState;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PostedMessage;
import jade.domain.introspection.ReceivedMessage;
import jade.domain.introspection.RemovedBehaviour;
import jade.domain.introspection.SentMessage;
import jade.domain.introspection.StartNotify;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.tools.ToolAgent;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ToolNotifier
extends ToolAgent
implements MessageListener,
AgentListener {
    private AID observerAgent;
    private Set observedAgents = new HashSet();
    private HashMap pendingEvents = new HashMap();
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    private ACLMessage msg = new ACLMessage(7);
    private boolean closingDown = false;

    public ToolNotifier(AID aID) {
        this.observerAgent = aID;
    }

    protected void toolSetup() {
        this.AMSSubscribe.addSubBehaviour(new SenderBehaviour(this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour(new NotifierAMSListenerBehaviour());
        this.addBehaviour(this.AMSSubscribe);
        this.msg.setSender(this.getAID());
        this.msg.addReceiver(this.observerAgent);
        this.msg.setOntology("JADE-Introspection");
        this.msg.setLanguage("fipa-sl0");
    }

    protected void toolTakeDown() {
        this.closingDown = true;
        this.send(this.getCancel());
        this.notifyAllPendingEvents();
    }

    public void addObservedAgent(AID aID) {
        this.observedAgents.add(aID);
        StartNotify startNotify = new StartNotify();
        startNotify.setObserved(aID);
        this.addBehaviour(new DoneInformer(this, startNotify));
    }

    public void removeObservedAgent(AID aID) {
        this.observedAgents.remove(aID);
        this.notifyPendingEvents(aID);
    }

    public AID getObserver() {
        return this.observerAgent;
    }

    public boolean isEmpty() {
        return this.observedAgents.isEmpty();
    }

    public void sentMessage(MessageEvent messageEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = messageEvent.getSender();
        AID aID2 = messageEvent.getReceiver();
        if (this.observedAgents.contains(aID)) {
            ACLMessage aCLMessage = messageEvent.getMessage();
            jade.domain.introspection.ACLMessage aCLMessage2 = new jade.domain.introspection.ACLMessage();
            Envelope envelope = aCLMessage.getEnvelope();
            if (envelope != null) {
                aCLMessage2.setEnvelope((Envelope)aCLMessage.getEnvelope().clone());
            }
            aCLMessage2.setAclRepresentation("fipa.acl.rep.string.std");
            aCLMessage2.setPayload(aCLMessage.toString());
            SentMessage sentMessage = new SentMessage();
            sentMessage.setSender(aID);
            sentMessage.setReceiver(aID2);
            sentMessage.setMessage(aCLMessage2);
            this.addBehaviour(new EventInformer(this, sentMessage));
        }
    }

    public void postedMessage(MessageEvent messageEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = messageEvent.getSender();
        AID aID2 = messageEvent.getReceiver();
        if (this.observedAgents.contains(aID2)) {
            ACLMessage aCLMessage = messageEvent.getMessage();
            jade.domain.introspection.ACLMessage aCLMessage2 = new jade.domain.introspection.ACLMessage();
            Envelope envelope = aCLMessage.getEnvelope();
            if (envelope != null) {
                aCLMessage2.setEnvelope(aCLMessage.getEnvelope());
                aCLMessage2.setAclRepresentation("fipa.acl.rep.string.std");
            }
            aCLMessage2.setPayload(aCLMessage.toString());
            PostedMessage postedMessage = new PostedMessage();
            postedMessage.setSender(aID);
            postedMessage.setReceiver(aID2);
            postedMessage.setMessage(aCLMessage2);
            this.addBehaviour(new EventInformer(this, postedMessage));
        }
    }

    public void receivedMessage(MessageEvent messageEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = messageEvent.getSender();
        AID aID2 = messageEvent.getReceiver();
        if (this.observedAgents.contains(aID2)) {
            ACLMessage aCLMessage = messageEvent.getMessage();
            jade.domain.introspection.ACLMessage aCLMessage2 = new jade.domain.introspection.ACLMessage();
            Envelope envelope = aCLMessage.getEnvelope();
            if (envelope != null) {
                aCLMessage2.setEnvelope(aCLMessage.getEnvelope());
                aCLMessage2.setAclRepresentation("fipa.acl.rep.string.std");
            }
            aCLMessage2.setPayload(aCLMessage.toString());
            ReceivedMessage receivedMessage = new ReceivedMessage();
            receivedMessage.setSender(aID);
            receivedMessage.setReceiver(aID2);
            receivedMessage.setMessage(aCLMessage2);
            this.addBehaviour(new EventInformer(this, receivedMessage));
        }
    }

    public void routedMessage(MessageEvent messageEvent) {
        if (this.closingDown) {
            return;
        }
    }

    public void changedAgentState(AgentEvent agentEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = agentEvent.getAgent();
        if (this.observedAgents.contains(aID)) {
            AgentState agentState = agentEvent.getFrom();
            AgentState agentState2 = agentEvent.getTo();
            ChangedAgentState changedAgentState = new ChangedAgentState();
            changedAgentState.setAgent(aID);
            changedAgentState.setFrom(agentState);
            changedAgentState.setTo(agentState2);
            this.addBehaviour(new EventInformer(this, changedAgentState));
        }
    }

    public void addedBehaviour(AgentEvent agentEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = agentEvent.getAgent();
        if (this.observedAgents.contains(aID)) {
            AddedBehaviour addedBehaviour = new AddedBehaviour();
            addedBehaviour.setAgent(aID);
            addedBehaviour.setBehaviour(agentEvent.getBehaviour());
            this.addBehaviour(new EventInformer(this, addedBehaviour));
        }
    }

    public void removedBehaviour(AgentEvent agentEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = agentEvent.getAgent();
        if (this.observedAgents.contains(aID)) {
            RemovedBehaviour removedBehaviour = new RemovedBehaviour();
            removedBehaviour.setAgent(aID);
            removedBehaviour.setBehaviour(agentEvent.getBehaviour());
            this.addBehaviour(new EventInformer(this, removedBehaviour));
        }
    }

    public void changedBehaviourState(AgentEvent agentEvent) {
        if (this.closingDown) {
            return;
        }
        AID aID = agentEvent.getAgent();
        if (this.observedAgents.contains(aID)) {
            ChangedBehaviourState changedBehaviourState = new ChangedBehaviourState();
            changedBehaviourState.setAgent(aID);
            changedBehaviourState.setBehaviour(agentEvent.getBehaviour());
            changedBehaviourState.setFrom(agentEvent.getBehaviourFrom());
            changedBehaviourState.setTo(agentEvent.getBehaviourTo());
            if (agentEvent.getBehaviourTo().equals("RUNNING") && agentEvent.getBehaviour().isSimple()) {
                agentEvent.reset();
                this.addPendingEvent(agentEvent, aID);
                this.addBehaviour(new SynchEventInformer(this, changedBehaviourState, agentEvent));
                try {
                    agentEvent.waitUntilProcessed();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            this.addBehaviour(new EventInformer(this, changedBehaviourState));
        }
    }

    public void changedAgentPrincipal(AgentEvent agentEvent) {
        if (this.closingDown) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingEvent(JADEEvent jADEEvent, AID aID) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            List list = (List)this.pendingEvents.get(aID);
            if (list == null) {
                list = new ArrayList();
                this.pendingEvents.put(aID, list);
            }
            list.add(jADEEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingEvent(JADEEvent jADEEvent) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            AID aID = null;
            if (jADEEvent instanceof AgentEvent) {
                aID = ((AgentEvent)jADEEvent).getAgent();
            } else if (jADEEvent instanceof MessageEvent) {
                aID = ((MessageEvent)jADEEvent).getAgent();
            }
            List list = (List)this.pendingEvents.get(aID);
            if (list != null) {
                list.remove(jADEEvent);
                if (list.isEmpty()) {
                    this.pendingEvents.remove(aID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPendingEvents(AID aID) {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            List list = (List)this.pendingEvents.remove(aID);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JADEEvent jADEEvent = (JADEEvent)iterator.next();
                    jADEEvent.notifyProcessed(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllPendingEvents() {
        HashMap hashMap = this.pendingEvents;
        synchronized (hashMap) {
            Iterator iterator = this.pendingEvents.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    JADEEvent jADEEvent = (JADEEvent)iterator2.next();
                    jADEEvent.notifyProcessed(null);
                }
            }
        }
    }

    class ObservationCompleteReceiver
    extends SimpleBehaviour {
        private JADEEvent jev;
        private MessageTemplate mt;
        private boolean finished = false;

        ObservationCompleteReceiver(Agent agent, JADEEvent jADEEvent, String string) {
            super(agent);
            this.jev = jADEEvent;
            this.mt = MessageTemplate.MatchInReplyTo(string);
        }

        public void action() {
            ACLMessage aCLMessage = this.myAgent.receive(this.mt);
            if (aCLMessage != null) {
                this.jev.notifyProcessed(null);
                ToolNotifier.this.removePendingEvent(this.jev);
                this.finished = true;
            }
        }

        public boolean done() {
            return this.finished;
        }
    }

    private class SynchEventInformer
    extends SequentialBehaviour {
        private String replyWith;

        SynchEventInformer(Agent agent, Event event, JADEEvent jADEEvent) {
            super(agent);
            this.replyWith = String.valueOf(jADEEvent.hashCode());
            this.addSubBehaviour(new EventInformer(agent, event));
            this.addSubBehaviour(new ObservationCompleteReceiver(agent, jADEEvent, this.replyWith));
        }

        public void onStart() {
            ToolNotifier.this.msg.setReplyWith(this.replyWith);
        }
    }

    private class EventInformer
    extends OneShotBehaviour {
        private Event ev;

        EventInformer(Agent agent, Event event) {
            super(agent);
            this.ev = event;
            this.setBehaviourName(this.getBehaviourName() + "-" + event.toString());
        }

        public void action() {
            EventRecord eventRecord = new EventRecord(this.ev, ToolNotifier.this.here());
            Occurred occurred = new Occurred();
            occurred.setWhat(eventRecord);
            try {
                ToolNotifier.this.getContentManager().fillContent(ToolNotifier.this.msg, occurred);
                ToolNotifier.this.msg.setConversationId(ToolNotifier.this.observerAgent.getName() + "-event");
                ToolNotifier.this.send(ToolNotifier.this.msg);
                ToolNotifier.this.msg.setReplyWith(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class DoneInformer
    extends OneShotBehaviour {
        private Object act;

        DoneInformer(Agent agent, Object object) {
            super(agent);
            this.act = object;
        }

        public void action() {
            Action action = new Action();
            action.setAction((AgentAction)this.act);
            action.setActor(ToolNotifier.this.getAID());
            Done done = new Done();
            done.setAction(action);
            try {
                ToolNotifier.this.getContentManager().fillContent(ToolNotifier.this.msg, done);
                ToolNotifier.this.msg.setConversationId(ToolNotifier.this.observerAgent.getName() + "-control");
                ToolNotifier.this.send(ToolNotifier.this.msg);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class NotifierAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        NotifierAMSListenerBehaviour() {
        }

        protected void installHandlers(Map map) {
            map.put("dead-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ NotifierAMSListenerBehaviour this$1;
                {
                    this.this$1 = notifierAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    DeadAgent deadAgent = (DeadAgent)event;
                    AID aID = deadAgent.getAgent();
                    NotifierAMSListenerBehaviour.access$000(this.this$1).removeObservedAgent(aID);
                    if (NotifierAMSListenerBehaviour.access$000(this.this$1).isEmpty()) {
                        NotifierAMSListenerBehaviour.access$000(this.this$1).doDelete();
                    }
                }
            });
            map.put("moved-agent", new AMSSubscriber.EventHandler(this){
                private final /* synthetic */ NotifierAMSListenerBehaviour this$1;
                {
                    this.this$1 = notifierAMSListenerBehaviour;
                }

                public void handle(Event event) {
                    MovedAgent movedAgent = (MovedAgent)event;
                    AID aID = movedAgent.getAgent();
                    if (!NotifierAMSListenerBehaviour.access$000(this.this$1).here().equals(movedAgent.getTo())) {
                        NotifierAMSListenerBehaviour.access$000(this.this$1).removeObservedAgent(aID);
                        if (NotifierAMSListenerBehaviour.access$000(this.this$1).isEmpty()) {
                            NotifierAMSListenerBehaviour.access$000(this.this$1).doDelete();
                        }
                    }
                }
            });
        }

        static /* synthetic */ ToolNotifier access$000(NotifierAMSListenerBehaviour notifierAMSListenerBehaviour) {
            return notifierAMSListenerBehaviour.ToolNotifier.this;
        }
    }
}

