/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.Properties;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;

public class JadeGateway {
    private static ContainerController myContainer = null;
    private static AgentController myAgent = null;
    private static String agentType;
    private static ProfileImpl profile;
    private static final Logger myLogger;
    static /* synthetic */ Class class$jade$wrapper$JadeGateway;

    public static final String getProfileProperty(String string, String string2) {
        return profile.getParameter(string, string2);
    }

    public static final synchronized void execute(Object object) throws StaleProxyException, ControllerException, InterruptedException {
        JadeGateway.checkJADE();
        Event event = new Event(-1, object);
        try {
            if (myLogger.isLoggable(Logger.INFO)) {
                myLogger.log(Logger.INFO, "Requesting execution of command " + object);
            }
            myAgent.putO2AObject(event, false);
        }
        catch (StaleProxyException staleProxyException) {
            staleProxyException.printStackTrace();
            JadeGateway.restartJADE();
            myAgent.putO2AObject(event, false);
        }
        event.waitUntilProcessed();
    }

    private static final void checkJADE() throws StaleProxyException, ControllerException {
        if (myContainer == null) {
            myContainer = Runtime.instance().createAgentContainer(profile);
        }
        if (myAgent == null) {
            myAgent = myContainer.createNewAgent("Control" + myContainer.getContainerName(), agentType, null);
            myAgent.start();
        }
    }

    private static final void restartJADE() throws StaleProxyException, ControllerException {
        try {
            if (myAgent != null) {
                myAgent.kill();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (myContainer != null) {
                myContainer.kill();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        myAgent = null;
        myContainer = null;
        JadeGateway.checkJADE();
    }

    public static final void init(String string, Properties properties) {
        agentType = string;
        profile = properties == null ? new ProfileImpl(false) : new ProfileImpl(properties);
    }

    private JadeGateway() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        myLogger = Logger.getMyLogger((class$jade$wrapper$JadeGateway == null ? (class$jade$wrapper$JadeGateway = JadeGateway.class$("jade.wrapper.JadeGateway")) : class$jade$wrapper$JadeGateway).getName());
    }
}

