/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.http.HTTPIO;
import jade.mtp.http.HTTPSocketFactory;
import jade.mtp.http.XMLCodec;
import jade.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class HTTPServer
extends Thread {
    static String CODEC = "org.apache.crimson.parser.XMLReaderImpl";
    private int port;
    private InChannel.Dispatcher dispatcher;
    private int maxKA;
    private int timeout;
    private ServerSocket server;
    private static Logger logger = Logger.getMyLogger((String)(class$jade$mtp$http$HTTPServer == null ? (class$jade$mtp$http$HTTPServer = HTTPServer.class$("jade.mtp.http.HTTPServer")) : class$jade$mtp$http$HTTPServer).getName());
    private Vector threads;
    private static Object lock = new Object();
    boolean active = true;
    static /* synthetic */ Class class$jade$mtp$http$HTTPServer;

    public HTTPServer(int n, InChannel.Dispatcher dispatcher, int n2, String string, int n3, boolean bl) throws IOException {
        this.port = n;
        this.dispatcher = dispatcher;
        this.maxKA = n2;
        this.threads = new Vector(this.maxKA);
        if (string != null) {
            CODEC = string;
        }
        this.timeout = n3;
        try {
            this.server = HTTPSocketFactory.getInstance().createServerSocket(this.port);
        }
        catch (IOException iOException) {
            if (bl) {
                this.server = HTTPSocketFactory.getInstance().createServerSocket(0);
                if (logger.isLoggable(Logger.WARNING)) {
                    logger.log(Logger.WARNING, "Port " + n + " is already in used, selected another one");
                }
            }
            throw iOException;
        }
    }

    public synchronized void desactivate() {
        int n = 0;
        while (n < this.threads.size()) {
            ((ServerThread)this.threads.get(n)).shutdown();
            ++n;
        }
        this.active = false;
        try {
            this.server.close();
        }
        catch (Exception exception) {}
    }

    int getLocalPort() {
        return this.server.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addThread(ServerThread serverThread) {
        Object object = lock;
        synchronized (object) {
            this.threads.addElement(serverThread);
            if (logger.isLoggable(Logger.CONFIG)) {
                logger.log(Logger.CONFIG, " Added Ka threads: " + this.threads.size() + "/" + this.maxKA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerThread serverThread) {
        Object object = lock;
        synchronized (object) {
            this.threads.removeElement(serverThread);
            if (logger.isLoggable(Logger.CONFIG)) {
                logger.log(Logger.CONFIG, " Removed Ka threads: " + this.threads.size() + "/" + this.maxKA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSpaceLeft() {
        Object object = lock;
        synchronized (object) {
            return this.threads.size() < this.maxKA;
        }
    }

    public void run() {
        block3: {
            try {
                while (this.active) {
                    Socket socket = this.server.accept();
                    socket.setSoTimeout(this.timeout);
                    new ServerThread(this, socket, this.dispatcher).start();
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, "HTTP Server closed on port " + this.port);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ServerThread
    extends Thread {
        private HTTPServer father;
        private Socket client;
        private InputStream input;
        private OutputStream output;
        private InChannel.Dispatcher dispatcher;
        private XMLCodec codec;
        private boolean keepAlive = false;
        private boolean active = false;

        public ServerThread(HTTPServer hTTPServer, Socket socket, InChannel.Dispatcher dispatcher) {
            this.father = hTTPServer;
            this.client = socket;
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block23: {
                try {
                    try {
                        this.codec = new XMLCodec(CODEC);
                        this.input = new BufferedInputStream(this.client.getInputStream());
                        this.output = new BufferedOutputStream(this.client.getOutputStream());
                        do {
                            StringBuffer stringBuffer = new StringBuffer(40);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(40);
                            StringBuffer stringBuffer2 = new StringBuffer();
                            String string = HTTPIO.readAll(this.input, stringBuffer, byteArrayOutputStream, stringBuffer2);
                            String string2 = stringBuffer2.toString();
                            if ("200 OK".equals(string)) {
                                StringReader stringReader = new StringReader(stringBuffer.toString());
                                Envelope envelope = this.codec.parse(stringReader);
                                InChannel.Dispatcher dispatcher = this.dispatcher;
                                synchronized (dispatcher) {
                                    if (envelope.getPayloadLength() != null && envelope.getPayloadLength().intValue() != byteArrayOutputStream.size() && logger.isLoggable(Logger.WARNING)) {
                                        logger.log(Logger.WARNING, "Payload size does not match envelope information");
                                    }
                                    this.dispatcher.dispatchMessage(envelope, byteArrayOutputStream.toByteArray());
                                }
                                if ("Keep-Alive".equalsIgnoreCase(string2)) {
                                    if (!this.keepAlive) {
                                        if (this.father.isSpaceLeft()) {
                                            this.active = true;
                                            this.keepAlive = true;
                                            this.father.addThread(this);
                                        } else {
                                            string2 = "close";
                                        }
                                    }
                                } else {
                                    this.active = false;
                                }
                            }
                            HTTPIO.writeAll(this.output, HTTPIO.createHTTPResponse(string, string2));
                        } while (this.active);
                    }
                    catch (SocketException socketException) {
                        Object var11_14 = null;
                        if (this.keepAlive) {
                            this.father.removeThread(this);
                        }
                        break block23;
                    }
                    catch (IOException iOException) {
                        Object var11_15 = null;
                        if (this.keepAlive) {
                            this.father.removeThread(this);
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(Logger.WARNING)) {
                            logger.log(Logger.WARNING, "HTTPServer error : " + exception);
                        }
                        Object var11_16 = null;
                        if (this.keepAlive) {
                            this.father.removeThread(this);
                        }
                    }
                    Object var11_13 = null;
                    if (this.keepAlive) {
                        this.father.removeThread(this);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    if (this.keepAlive) {
                        this.father.removeThread(this);
                    }
                    throw throwable;
                }
            }
            this.shutdown();
        }

        void shutdown() {
            this.active = false;
            this.keepAlive = false;
            try {
                this.client.close();
            }
            catch (Exception exception) {}
        }
    }
}

